/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.mars.safekeyboard_backend;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class KeypadDecrypt {
    private final PrivateKey mPrivateKey;

    public KeypadDecrypt(String privateKey) throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        System.out.println(privateKey);
        System.out.println(Charset.defaultCharset());
        PEMParser pemReader = new PEMParser((Reader)new StringReader(privateKey));
        PEMKeyPair obj = (PEMKeyPair)pemReader.readObject();
        pemReader.close();
        JcaPEMKeyConverter CONVERTER = new JcaPEMKeyConverter().setProvider("BC");
        KeyPair keyPair = CONVERTER.getKeyPair(obj);
        this.mPrivateKey = keyPair.getPrivate();
    }

    public DecryptResult decrypt(String input) throws Exception {
        if (input.startsWith("sm2_")) {
            String base64content = input.substring(4);
            byte[] decodedBytes = Base64.getDecoder().decode(base64content);
            byte[] resultBytes = this.sm2decrypt(decodedBytes);
            return this.getPassword(resultBytes);
        }
        if (input.startsWith("rsa_")) {
            String base64content = input.substring(4);
            byte[] decodedBytes = Base64.getDecoder().decode(base64content);
            byte[] resultBytes = this.rsaDecrypt(decodedBytes);
            return this.getPassword(resultBytes);
        }
        throw new Exception("invalid input");
    }

    private DecryptResult getPassword(byte[] resultBytes) throws Exception {
        if (resultBytes == null) {
            throw new Exception("decrypt failed");
        }
        String result = new String(resultBytes);
        String[] results = result.split("\\\\0");
        if ("V1".equals(results[0]) && results.length == 5) {
            return new DecryptResult(0, "", results[1], results[3], results[2]);
        }
        return null;
    }

    private byte[] sm2decrypt(byte[] message) {
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        X9ECParameters X_9_EC_PARAMETERS = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters EC_DOMAIN_PARAMETERS = new ECDomainParameters(X_9_EC_PARAMETERS.getCurve(), X_9_EC_PARAMETERS.getG(), X_9_EC_PARAMETERS.getN());
        BCECPrivateKey localECPrivateKey = (BCECPrivateKey)this.mPrivateKey;
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(localECPrivateKey.getD(), EC_DOMAIN_PARAMETERS);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        try {
            return sm2Engine.processBlock(message, 0, message.length);
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] rsaDecrypt(byte[] message) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, this.mPrivateKey);
            return cipher.doFinal(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class DecryptResult {
        int status_code;
        String error_msg;
        String password;
        String nonce;
        long timestamp;

        public DecryptResult(int status_code, String error_msg, String password, String nonce, String timestamp) {
            this.status_code = status_code;
            this.error_msg = error_msg;
            this.password = password;
            this.nonce = nonce;
            this.timestamp = Long.parseLong(timestamp);
        }

        public String toString() {
            return "DecryptResult{status_code=" + this.status_code + ", error_msg='" + this.error_msg + '\'' + ", password='" + this.password + '\'' + ", nonce='" + this.nonce + '\'' + ", timestamp=" + this.timestamp + '}';
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("status_code", this.status_code);
            map.put("error_msg", this.error_msg);
            map.put("password", this.password);
            map.put("nonce", Long.parseLong(this.nonce));
            map.put("timestamp", this.timestamp);
            return map;
        }
    }
}

