/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.graphics.Matrix;
import android.os.Build;
import android.view.InputDevice;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import io.flutter.embedding.android.MotionEventTracker;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class AndroidTouchProcessor {
    private static final int POINTER_DATA_FIELD_COUNT = 29;
    private static final int BYTES_PER_FIELD = 8;
    private static final int POINTER_DATA_FLAG_BATCHED = 1;
    @NonNull
    private final FlutterRenderer renderer;
    @NonNull
    private final MotionEventTracker motionEventTracker;
    private static final int _POINTER_BUTTON_PRIMARY = 1;
    private static final Matrix IDENTITY_TRANSFORM = new Matrix();
    private final boolean trackMotionEvents;
    private List<Integer> deviceList = new ArrayList<Integer>();

    public AndroidTouchProcessor(@NonNull FlutterRenderer renderer, boolean trackMotionEvents) {
        this.renderer = renderer;
        this.motionEventTracker = MotionEventTracker.getInstance();
        this.trackMotionEvents = trackMotionEvents;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.onTouchEvent(event, IDENTITY_TRANSFORM);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event, Matrix transformMatrix) {
        boolean updateForMultiplePointers;
        int pointerCount = event.getPointerCount();
        boolean needsAccelRend = false;
        ByteBuffer packet = ByteBuffer.allocateDirect(pointerCount * 29 * 8);
        packet.order(ByteOrder.LITTLE_ENDIAN);
        int maskedAction = event.getActionMasked();
        int pointerChange = this.getPointerChangeForAction(event.getActionMasked());
        boolean updateForSinglePointer = maskedAction == 0 || maskedAction == 5;
        boolean bl = updateForMultiplePointers = !updateForSinglePointer && (maskedAction == 1 || maskedAction == 6);
        if (updateForSinglePointer) {
            this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, transformMatrix, packet);
            this.deviceList.add(event.getPointerId(event.getActionIndex()));
        } else if (updateForMultiplePointers) {
            for (int p = 0; p < pointerCount; ++p) {
                if (p == event.getActionIndex() || event.getToolType(p) != 1) continue;
                this.addPointerForIndex(event, p, 5, 1, transformMatrix, packet);
            }
            this.deviceList.remove((Object)event.getPointerId(event.getActionIndex()));
            this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, transformMatrix, packet);
        } else if (maskedAction == 3) {
            for (int p = 0; p < pointerCount; ++p) {
                int device = event.getPointerId(p);
                if (!this.deviceList.contains(device)) continue;
                this.deviceList.remove((Object)device);
                this.addPointerForIndex(event, p, pointerChange, 0, transformMatrix, packet);
            }
        } else {
            for (int p = 0; p < pointerCount; ++p) {
                this.addPointerForIndex(event, p, pointerChange, 0, transformMatrix, packet);
            }
        }
        if (packet.position() % 232 != 0) {
            throw new AssertionError((Object)"Packet position is not on field boundary");
        }
        this.renderer.dispatchPointerDataPacket(packet, packet.position());
        if (needsAccelRend) {
            this.renderer.scheduleFrameNow();
        }
        return true;
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        boolean isMovementEvent;
        boolean isPointerEvent = Build.VERSION.SDK_INT >= 18 && event.isFromSource(2);
        boolean bl = isMovementEvent = event.getActionMasked() == 7 || event.getActionMasked() == 8;
        if (!isPointerEvent || !isMovementEvent) {
            return false;
        }
        int pointerChange = this.getPointerChangeForAction(event.getActionMasked());
        ByteBuffer packet = ByteBuffer.allocateDirect(event.getPointerCount() * 29 * 8);
        packet.order(ByteOrder.LITTLE_ENDIAN);
        this.addPointerForIndex(event, event.getActionIndex(), pointerChange, 0, IDENTITY_TRANSFORM, packet);
        if (packet.position() % 232 != 0) {
            throw new AssertionError((Object)"Packet position is not on field boundary.");
        }
        this.renderer.dispatchPointerDataPacket(packet, packet.position());
        return true;
    }

    private void addPointerForIndex(MotionEvent event, int pointerIndex, int pointerChange, int pointerData, Matrix transformMatrix, ByteBuffer packet) {
        InputDevice.MotionRange pressureRange;
        long buttons;
        if (pointerChange == -1) {
            return;
        }
        long motionEventId = 0L;
        if (this.trackMotionEvents) {
            MotionEventTracker.MotionEventId trackedEvent = this.motionEventTracker.track(event);
            motionEventId = trackedEvent.getId();
        }
        int pointerKind = this.getPointerDeviceTypeForToolType(event.getToolType(pointerIndex));
        int signalKind = event.getActionMasked() == 8 ? 1 : 0;
        long timeStamp = event.getEventTime() * 1000L;
        packet.putLong(motionEventId);
        packet.putLong(timeStamp);
        packet.putLong(pointerChange);
        packet.putLong(pointerKind);
        packet.putLong(signalKind);
        packet.putLong(event.getPointerId(pointerIndex));
        packet.putLong(0L);
        float[] viewToScreenCoords = new float[]{event.getX(pointerIndex), event.getY(pointerIndex)};
        transformMatrix.mapPoints(viewToScreenCoords);
        packet.putDouble(viewToScreenCoords[0]);
        packet.putDouble(viewToScreenCoords[1]);
        packet.putDouble(0.0);
        packet.putDouble(0.0);
        if (pointerKind == 1) {
            buttons = event.getButtonState() & 0x1F;
            if (buttons == 0L && event.getSource() == 8194 && (pointerChange == 4 || pointerChange == 5)) {
                buttons = 1L;
            }
        } else {
            buttons = pointerKind == 2 ? (long)(event.getButtonState() >> 4 & 0xF) : 0L;
        }
        packet.putLong(buttons);
        packet.putLong(0L);
        packet.putLong(0L);
        packet.putDouble(event.getPressure(pointerIndex));
        double pressureMin = 0.0;
        double pressureMax = 1.0;
        if (event.getDevice() != null && (pressureRange = event.getDevice().getMotionRange(2)) != null) {
            pressureMin = pressureRange.getMin();
            pressureMax = pressureRange.getMax();
        }
        packet.putDouble(pressureMin);
        packet.putDouble(pressureMax);
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(24, pointerIndex));
            packet.putDouble(0.0);
        } else {
            packet.putDouble(0.0);
            packet.putDouble(0.0);
        }
        packet.putDouble(event.getSize(pointerIndex));
        packet.putDouble(event.getToolMajor(pointerIndex));
        packet.putDouble(event.getToolMinor(pointerIndex));
        packet.putDouble(0.0);
        packet.putDouble(0.0);
        packet.putDouble(event.getAxisValue(8, pointerIndex));
        if (pointerKind == 2) {
            packet.putDouble(event.getAxisValue(25, pointerIndex));
        } else {
            packet.putDouble(0.0);
        }
        packet.putLong(pointerData);
        if (signalKind == 1) {
            packet.putDouble(-event.getAxisValue(10));
            packet.putDouble(-event.getAxisValue(9));
        } else {
            packet.putDouble(0.0);
            packet.putDouble(0.0);
        }
    }

    @PointerChange
    private int getPointerChangeForAction(int maskedAction) {
        if (maskedAction == 0) {
            return 4;
        }
        if (maskedAction == 1) {
            return 6;
        }
        if (maskedAction == 5) {
            return 4;
        }
        if (maskedAction == 6) {
            return 6;
        }
        if (maskedAction == 2) {
            return 5;
        }
        if (maskedAction == 7) {
            return 3;
        }
        if (maskedAction == 3) {
            return 0;
        }
        if (maskedAction == 8) {
            return 3;
        }
        return -1;
    }

    @PointerDeviceKind
    private int getPointerDeviceTypeForToolType(int toolType) {
        switch (toolType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    private static @interface PointerSignalKind {
        public static final int NONE = 0;
        public static final int SCROLL = 1;
        public static final int UNKNOWN = 2;
    }

    private static @interface PointerDeviceKind {
        public static final int TOUCH = 0;
        public static final int MOUSE = 1;
        public static final int STYLUS = 2;
        public static final int INVERTED_STYLUS = 3;
        public static final int UNKNOWN = 4;
    }

    private static @interface PointerChange {
        public static final int CANCEL = 0;
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        public static final int HOVER = 3;
        public static final int DOWN = 4;
        public static final int MOVE = 5;
        public static final int UP = 6;
    }
}

