/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.content.res.AssetManager;
import android.os.Build;
import android.text.TextUtils;
import io.flutter.Log;
import io.flutter.embedding.engine.ReflectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class AssetUtil {
    private static final String TAG = "ReflectUtils";

    private AssetUtil() {
    }

    public static AssetManager updateAssetManager(AssetManager newAssetManager, AssetManager originAssetManager) {
        if (Build.VERSION.SDK_INT < 21) {
            return originAssetManager;
        }
        List<String> newPathList = AssetUtil.getAssetPaths(newAssetManager);
        List<String> oldPathList = AssetUtil.getAssetPaths(originAssetManager);
        for (String oldPath : oldPathList) {
            if (newPathList.contains(oldPath)) continue;
            AssetUtil.updateAssetManager(newAssetManager, oldPath);
        }
        return newAssetManager;
    }

    public static AssetManager updateAssetManager(AssetManager originAssetManager, String sourceDir) {
        AssetManager newAssetManager = null;
        if (Build.VERSION.SDK_INT >= 21) {
            if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 25) {
                newAssetManager = AssetUtil.appendAssetPathSafely(originAssetManager, sourceDir);
                if (!AssetUtil.containsPath(newAssetManager, sourceDir)) {
                    newAssetManager = AssetUtil.appendAssetPath(originAssetManager, sourceDir);
                }
            } else {
                newAssetManager = AssetUtil.appendAssetPath(originAssetManager, sourceDir);
            }
        }
        Log.e(TAG, " updateAssetManager, newAssetManager=" + newAssetManager);
        return newAssetManager;
    }

    public static Object readField(Object target, String fieldName) throws IllegalAccessException {
        try {
            Class<?> clazz = target.getClass();
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void writeField(Object target, String fieldName, Object value) throws IllegalAccessException {
        try {
            Class<?> clazz = target.getClass();
            Field field = clazz.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(target, value);
        }
        catch (Exception e) {
            Log.e(TAG, "writeField failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AssetManager appendAssetPathSafely(AssetManager assetManager, String sourceDir) {
        int tryCount = 3;
        while (tryCount-- >= 0) {
            String errorMsg = null;
            try {
                AssetManager assetManager2 = assetManager;
                synchronized (assetManager2) {
                    int cookie = 0;
                    for (int i = 0; i < 3; ++i) {
                        if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 23) {
                            cookie = (Integer)ReflectUtils.invokeMethod(assetManager.getClass(), "addAssetPathNative", new Object[]{sourceDir}, new Class[]{String.class}, assetManager);
                        } else if (Build.VERSION.SDK_INT >= 24 && Build.VERSION.SDK_INT <= 25) {
                            cookie = (Integer)ReflectUtils.invokeMethod(assetManager.getClass(), "addAssetPathNative", new Object[]{sourceDir, false}, new Class[]{String.class, Boolean.TYPE}, assetManager);
                        }
                        if (cookie != 0) break;
                    }
                    if (cookie == 0) {
                        errorMsg = "cookie == 0";
                        break;
                    }
                    Object seed = AssetUtil.readField(assetManager, "mStringBlocks");
                    int seedNum = seed != null ? Array.getLength(seed) : 0;
                    int num = (Integer)ReflectUtils.invokeMethod(assetManager.getClass(), "getStringBlockCount", assetManager);
                    Object newStringBlocks = Array.newInstance(seed.getClass().getComponentType(), num);
                    for (int i = 0; i < num; ++i) {
                        if (i < seedNum) {
                            Array.set(newStringBlocks, i, Array.get(seed, i));
                            continue;
                        }
                        long nativeStringBlockObj = (Long)ReflectUtils.invokeMethod(assetManager.getClass(), "getNativeStringBlock", new Object[]{i}, new Class[]{Integer.TYPE}, assetManager);
                        Object stri = ReflectUtils.invokeConstructor(seed.getClass().getComponentType(), new Object[]{nativeStringBlockObj, true}, new Class[]{Long.TYPE, Boolean.TYPE});
                        Array.set(newStringBlocks, i, stri);
                    }
                    AssetUtil.writeField(assetManager, "mStringBlocks", newStringBlocks);
                }
                Log.w(TAG, "ReflectUtils appendAssetPathSafely success, sourceDir = " + sourceDir);
                break;
            }
            catch (Exception e) {
                Log.e(TAG, "ReflectUtils appendAssetPathSafely failed, sourceDir = " + sourceDir, e);
            }
        }
        return assetManager;
    }

    private static AssetManager appendAssetPath(AssetManager assetManager, String path) {
        Method addAssetPathMethod = ReflectUtils.getMethod(AssetManager.class, "addAssetPath", new Class[]{String.class});
        if (null != addAssetPathMethod) {
            int tryCount = 3;
            int cookie = 0;
            while (tryCount-- >= 0) {
                try {
                    cookie = (Integer)addAssetPathMethod.invoke((Object)assetManager, path);
                    if (cookie != 0) {
                        Log.i(TAG, "ReflectUtils invoke AssetManager.addAssetPath() success, cookie = " + cookie + ", path = " + path);
                        break;
                    }
                    Log.e(TAG, "ReflectUtils invoke AssetManager.addAssetPath() failed, cookie = " + cookie);
                }
                catch (Exception e) {
                    Log.e(TAG, "ReflectUtils invoke AssetManager.addAssetPath() failed.");
                }
            }
        } else {
            Log.e(TAG, "ReflectUtils reflect AssetManager.addAssetPath() failed.");
        }
        return assetManager;
    }

    public static boolean containsPath(AssetManager assetManager, String path) {
        try {
            if (Build.VERSION.SDK_INT >= 28 || Build.VERSION.SDK_INT == 27 && Build.VERSION.PREVIEW_SDK_INT > 0) {
                Object[] assets = (Object[])ReflectUtils.invokeMethod(assetManager.getClass(), "getApkAssets", assetManager);
                if (assets != null && assets.length > 0) {
                    for (Object asset : assets) {
                        String assetPath = (String)ReflectUtils.invokeMethod(asset.getClass(), "getAssetPath", asset);
                        if (!TextUtils.equals((CharSequence)assetPath, (CharSequence)path)) continue;
                        return true;
                    }
                }
            } else {
                int assetsCount = (Integer)ReflectUtils.invokeMethod(assetManager.getClass(), "getStringBlockCount", assetManager);
                for (int i = 0; i < assetsCount; ++i) {
                    String assetPath = (String)ReflectUtils.invokeMethod(assetManager.getClass(), "getCookieName", i + 1, assetManager);
                    if (!TextUtils.equals((CharSequence)assetPath, (CharSequence)path)) continue;
                    return true;
                }
            }
        }
        catch (Throwable e) {
            Log.e(TAG, "containsPath error. ", e);
        }
        return false;
    }

    public static List<String> getAssetPaths(AssetManager assetManager) {
        ArrayList<String> assetPaths = new ArrayList<String>();
        if (null == assetManager) {
            return assetPaths;
        }
        try {
            String assetPath = null;
            if (Build.VERSION.SDK_INT >= 28 || Build.VERSION.SDK_INT == 27 && Build.VERSION.PREVIEW_SDK_INT > 0) {
                Object[] assets = (Object[])ReflectUtils.invokeMethod(assetManager.getClass(), "getApkAssets", assetManager);
                if (null != assets && assets.length > 0) {
                    for (Object asset : assets) {
                        assetPaths.add((String)ReflectUtils.invokeMethod(asset.getClass(), "getAssetPath", asset));
                    }
                }
            } else {
                int assetsCount = (Integer)ReflectUtils.invokeMethod(assetManager.getClass(), "getStringBlockCount", assetManager);
                for (int i = 0; i < assetsCount; ++i) {
                    assetPath = (String)ReflectUtils.invokeMethod(assetManager.getClass(), "getCookieName", new Class[]{Integer.TYPE}, new Object[]{i + 1}, new Object[]{assetManager});
                    if (TextUtils.isEmpty((CharSequence)assetPath)) continue;
                    assetPaths.add(assetPath);
                }
            }
        }
        catch (Throwable e) {
            Log.e(TAG, "GetAssetsPaths error. ", e);
            e.printStackTrace();
        }
        return assetPaths;
    }
}

