/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.AssetUtil;
import io.flutter.embedding.engine.FlutterEngineConnectionRegistry;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.embedding.engine.plugins.PluginRegistry;
import io.flutter.embedding.engine.plugins.activity.ActivityControlSurface;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverControlSurface;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderControlSurface;
import io.flutter.embedding.engine.plugins.service.ServiceControlSurface;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.AccessibilityChannel;
import io.flutter.embedding.engine.systemchannels.DeferredComponentChannel;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.embedding.engine.systemchannels.LifecycleChannel;
import io.flutter.embedding.engine.systemchannels.LocalizationChannel;
import io.flutter.embedding.engine.systemchannels.MouseCursorChannel;
import io.flutter.embedding.engine.systemchannels.NavigationChannel;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.embedding.engine.systemchannels.RestorationChannel;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.embedding.engine.systemchannels.SystemChannel;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.localization.LocalizationPlugin;
import io.flutter.plugin.platform.PlatformViewsController;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class FlutterEngine {
    private static final String TAG = "FlutterEngine";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final FlutterRenderer renderer;
    @NonNull
    private final DartExecutor dartExecutor;
    @NonNull
    private final FlutterEngineConnectionRegistry pluginRegistry;
    @NonNull
    private final LocalizationPlugin localizationPlugin;
    private AccessibilityChannel accessibilityChannel;
    @NonNull
    private final DeferredComponentChannel deferredComponentChannel;
    @NonNull
    private final KeyEventChannel keyEventChannel;
    @NonNull
    private final LifecycleChannel lifecycleChannel;
    @NonNull
    private final LocalizationChannel localizationChannel;
    @NonNull
    private final MouseCursorChannel mouseCursorChannel;
    @NonNull
    private final NavigationChannel navigationChannel;
    @NonNull
    private final RestorationChannel restorationChannel;
    @NonNull
    private final PlatformChannel platformChannel;
    @NonNull
    private final SettingsChannel settingsChannel;
    @NonNull
    private final SystemChannel systemChannel;
    @NonNull
    private final TextInputChannel textInputChannel;
    @NonNull
    private final PlatformViewsController platformViewsController;
    static final int FLAG_ENGINE_PRELOAD = 1;
    static final int FLAG_ENGINE_DISABLE_ACCESSIBILITY = 2;
    static final int FLAG_ENGINE_MULTI_CHANNEL = 4;
    @NonNull
    private final Set<EngineLifecycleListener> engineLifecycleListeners = new HashSet<EngineLifecycleListener>();
    @NonNull
    private final EngineLifecycleListener engineLifecycleListener = new EngineLifecycleListener(){

        @Override
        public void onPreEngineRestart() {
            Log.v(FlutterEngine.TAG, "onPreEngineRestart()");
            for (EngineLifecycleListener lifecycleListener : FlutterEngine.this.engineLifecycleListeners) {
                lifecycleListener.onPreEngineRestart();
            }
            FlutterEngine.this.platformViewsController.onPreEngineRestart();
            FlutterEngine.this.restorationChannel.clearData();
        }

        @Override
        public void onEngineWillDestroy() {
        }
    };

    public FlutterEngine(@NonNull Context context) {
        this(context, null);
    }

    public FlutterEngine(@NonNull Context context, @Nullable String[] dartVmArgs) {
        this(context, null, new FlutterJNI(), dartVmArgs, true);
    }

    public FlutterEngine(@NonNull Context context, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins) {
        this(context, null, new FlutterJNI(), dartVmArgs, automaticallyRegisterPlugins);
    }

    public FlutterEngine(@NonNull Context context, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins, boolean waitForRestorationData) {
        this(context, null, new FlutterJNI(), new PlatformViewsController(), dartVmArgs, automaticallyRegisterPlugins, waitForRestorationData, false, false);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI) {
        this(context, flutterLoader, flutterJNI, null, true);
    }

    public FlutterEngine(@NonNull Context context, @NonNull FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, boolean isPreload, boolean disableAccessibility) {
        this(context, flutterLoader, flutterJNI, new PlatformViewsController(), null, false, false, isPreload, disableAccessibility);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins) {
        this(context, flutterLoader, flutterJNI, new PlatformViewsController(), dartVmArgs, automaticallyRegisterPlugins);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @NonNull PlatformViewsController platformViewsController, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins) {
        this(context, flutterLoader, flutterJNI, platformViewsController, dartVmArgs, automaticallyRegisterPlugins, false, false, false);
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @NonNull PlatformViewsController platformViewsController, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins, boolean waitForRestorationData, boolean isPreload, boolean disableAccessibility) {
        this(context, flutterLoader, flutterJNI, platformViewsController, dartVmArgs, automaticallyRegisterPlugins, waitForRestorationData, (isPreload ? 1 : 0) | (disableAccessibility ? 2 : 0));
    }

    public FlutterEngine(@NonNull Context context, @Nullable FlutterLoader flutterLoader, @NonNull FlutterJNI flutterJNI, @NonNull PlatformViewsController platformViewsController, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins, boolean waitForRestorationData, int flag) {
        AssetManager assetManager;
        try {
            assetManager = context.createPackageContext(context.getPackageName(), 0).getAssets();
        }
        catch (PackageManager.NameNotFoundException e) {
            assetManager = context.getAssets();
        }
        AssetManager miraAssetManager = context.getAssets();
        if (assetManager != null && assetManager != miraAssetManager) {
            assetManager = AssetUtil.updateAssetManager(assetManager, miraAssetManager);
        }
        this.dartExecutor = new DartExecutor(flutterJNI, assetManager);
        this.dartExecutor.onAttachedToJNI();
        DeferredComponentManager deferredComponentManager = FlutterInjector.instance().deferredComponentManager();
        if ((flag & 2) == 0) {
            this.accessibilityChannel = new AccessibilityChannel(this.dartExecutor, flutterJNI);
        }
        this.deferredComponentChannel = new DeferredComponentChannel(this.dartExecutor);
        this.keyEventChannel = new KeyEventChannel(this.dartExecutor);
        this.lifecycleChannel = new LifecycleChannel(this.dartExecutor);
        this.localizationChannel = new LocalizationChannel(this.dartExecutor);
        this.mouseCursorChannel = new MouseCursorChannel(this.dartExecutor);
        this.navigationChannel = new NavigationChannel(this.dartExecutor);
        this.platformChannel = new PlatformChannel(this.dartExecutor);
        this.restorationChannel = new RestorationChannel(this.dartExecutor, waitForRestorationData);
        this.settingsChannel = new SettingsChannel(this.dartExecutor);
        this.systemChannel = new SystemChannel(this.dartExecutor);
        this.textInputChannel = new TextInputChannel(this.dartExecutor);
        if (deferredComponentManager != null) {
            deferredComponentManager.setDeferredComponentChannel(this.deferredComponentChannel);
        }
        this.localizationPlugin = new LocalizationPlugin(context, this.localizationChannel);
        this.flutterJNI = flutterJNI;
        if (flutterLoader == null) {
            flutterLoader = FlutterInjector.instance().flutterLoader();
        }
        if (!flutterJNI.isAttached()) {
            flutterLoader.startInitialization(context.getApplicationContext());
            flutterLoader.ensureInitializationComplete(context, dartVmArgs);
        }
        flutterJNI.addEngineLifecycleListener(this.engineLifecycleListener);
        flutterJNI.setPlatformViewsController(platformViewsController);
        flutterJNI.setLocalizationPlugin(this.localizationPlugin);
        flutterJNI.setDeferredComponentManager(FlutterInjector.instance().deferredComponentManager());
        if ((flag & 4) != 0) {
            flutterJNI.setEnsureHandleChannelOnMainThread(false);
        }
        if (!flutterJNI.isAttached()) {
            this.attachToJni(flag);
        }
        this.renderer = new FlutterRenderer(flutterJNI);
        this.platformViewsController = platformViewsController;
        this.platformViewsController.onAttachedToJNI();
        this.pluginRegistry = new FlutterEngineConnectionRegistry(context.getApplicationContext(), this, flutterLoader, flutterJNI);
        if (automaticallyRegisterPlugins) {
            this.registerPlugins();
        }
    }

    private void attachToJni(int flag) {
        Log.v(TAG, "Attaching to JNI.");
        this.flutterJNI.attachToNative(false, flag);
        if (!this.isAttachedToJni()) {
            throw new RuntimeException("FlutterEngine failed to attach to its native Object reference.");
        }
    }

    private boolean isAttachedToJni() {
        return this.flutterJNI.isAttached();
    }

    @NonNull
    public FlutterEngine spawn(@NonNull Context context, @NonNull DartExecutor.DartEntrypoint dartEntrypoint, @Nullable String initialRoute) {
        if (!this.isAttachedToJni()) {
            throw new IllegalStateException("Spawn can only be called on a fully constructed FlutterEngine");
        }
        FlutterJNI newFlutterJNI = this.flutterJNI.spawn(dartEntrypoint.dartEntrypointFunctionName, dartEntrypoint.dartEntrypointLibrary, initialRoute);
        return new FlutterEngine(context, null, newFlutterJNI);
    }

    @NonNull
    public FlutterEngine spawn(@NonNull Context context, @NonNull DartExecutor.DartEntrypoint dartEntrypoint, @Nullable FlutterLoader flutterLoader, @Nullable String initialRoute, @Nullable String[] dartVmArgs, boolean automaticallyRegisterPlugins) {
        if (!this.isAttachedToJni()) {
            throw new IllegalStateException("Spawn can only be called on a fully constructed FlutterEngine");
        }
        FlutterJNI newFlutterJNI = this.flutterJNI.spawn(dartEntrypoint.dartEntrypointFunctionName, dartEntrypoint.dartEntrypointLibrary, initialRoute);
        return new FlutterEngine(context, flutterLoader, newFlutterJNI, dartVmArgs, automaticallyRegisterPlugins);
    }

    private void registerPlugins() {
        try {
            Class<?> generatedPluginRegistrant = Class.forName("io.flutter.plugins.GeneratedPluginRegistrant");
            Method registrationMethod = generatedPluginRegistrant.getDeclaredMethod("registerWith", FlutterEngine.class);
            registrationMethod.invoke(null, this);
        }
        catch (Exception e) {
            Log.w(TAG, "Tried to automatically register plugins with FlutterEngine (" + this + ") but could not find and invoke the GeneratedPluginRegistrant.");
        }
    }

    public void destroy() {
        Log.v(TAG, "Destroying.");
        for (EngineLifecycleListener listener : this.engineLifecycleListeners) {
            listener.onEngineWillDestroy();
        }
        this.pluginRegistry.destroy();
        this.platformViewsController.onDetachedFromJNI();
        this.dartExecutor.onDetachedFromJNI();
        this.flutterJNI.removeEngineLifecycleListener(this.engineLifecycleListener);
        this.flutterJNI.setDeferredComponentManager(null);
        this.flutterJNI.detachFromNativeAndReleaseResources();
        if (FlutterInjector.instance().deferredComponentManager() != null) {
            FlutterInjector.instance().deferredComponentManager().destroy();
            this.deferredComponentChannel.setDeferredComponentManager(null);
        }
    }

    public void addEngineLifecycleListener(@NonNull EngineLifecycleListener listener) {
        this.engineLifecycleListeners.add(listener);
    }

    public void removeEngineLifecycleListener(@NonNull EngineLifecycleListener listener) {
        this.engineLifecycleListeners.remove(listener);
    }

    @NonNull
    public DartExecutor getDartExecutor() {
        return this.dartExecutor;
    }

    @NonNull
    public FlutterRenderer getRenderer() {
        return this.renderer;
    }

    public AccessibilityChannel getAccessibilityChannel() {
        return this.accessibilityChannel;
    }

    @NonNull
    public KeyEventChannel getKeyEventChannel() {
        return this.keyEventChannel;
    }

    @NonNull
    public LifecycleChannel getLifecycleChannel() {
        return this.lifecycleChannel;
    }

    @NonNull
    public LocalizationChannel getLocalizationChannel() {
        return this.localizationChannel;
    }

    @NonNull
    public NavigationChannel getNavigationChannel() {
        return this.navigationChannel;
    }

    @NonNull
    public PlatformChannel getPlatformChannel() {
        return this.platformChannel;
    }

    @NonNull
    public RestorationChannel getRestorationChannel() {
        return this.restorationChannel;
    }

    @NonNull
    public SettingsChannel getSettingsChannel() {
        return this.settingsChannel;
    }

    @NonNull
    public DeferredComponentChannel getDeferredComponentChannel() {
        return this.deferredComponentChannel;
    }

    @NonNull
    public SystemChannel getSystemChannel() {
        return this.systemChannel;
    }

    @NonNull
    public MouseCursorChannel getMouseCursorChannel() {
        return this.mouseCursorChannel;
    }

    @NonNull
    public TextInputChannel getTextInputChannel() {
        return this.textInputChannel;
    }

    @NonNull
    public PluginRegistry getPlugins() {
        return this.pluginRegistry;
    }

    @NonNull
    public LocalizationPlugin getLocalizationPlugin() {
        return this.localizationPlugin;
    }

    @NonNull
    public PlatformViewsController getPlatformViewsController() {
        return this.platformViewsController;
    }

    @NonNull
    public ActivityControlSurface getActivityControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public ServiceControlSurface getServiceControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public BroadcastReceiverControlSurface getBroadcastReceiverControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public ContentProviderControlSurface getContentProviderControlSurface() {
        return this.pluginRegistry;
    }

    public static interface EngineLifecycleListener {
        public void onPreEngineRestart();

        public void onEngineWillDestroy();
    }
}

