/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import io.flutter.Log;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;

public class IoUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_MAP = new HashMap();

    private IoUtil() {
    }

    public static void safeClose(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void safeClose(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean mkdir(String path) {
        File dir = new File(path);
        return dir.mkdirs();
    }

    public static <T> T callStaticMethodOrThrow(String className, String methodName, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        Method method = IoUtil.getDeclaredMethod(clazz, methodName, IoUtil.getParameterTypes(args));
        Object result = method.invoke(null, IoUtil.getParameters(args));
        return (T)result;
    }

    public static <T> T callStaticMethodOrThrow(Class<?> clazz, String methodName, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = IoUtil.getDeclaredMethod(clazz, methodName, IoUtil.getParameterTypes(args));
        Object result = method.invoke(null, IoUtil.getParameters(args));
        return (T)result;
    }

    public static <T> T callStaticMethod(String className, String methodName, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            return IoUtil.callStaticMethodOrThrow(clazz, methodName, args);
        }
        catch (Exception e) {
            Log.w("Flutter.io", "Meet exception when call Method '" + methodName + "' in " + className, e);
            return null;
        }
    }

    private static Class<?>[] getParameterTypes(Object ... args) {
        Class[] parameterTypes = null;
        if (args != null && args.length > 0) {
            parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object param = args[i];
                parameterTypes[i] = param != null && param instanceof JavaParam ? ((JavaParam)param).clazz : (param == null ? null : param.getClass());
            }
        }
        return parameterTypes;
    }

    private static Object[] getParameters(Object ... args) {
        Object[] parameters = null;
        if (args != null && args.length > 0) {
            parameters = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object param = args[i];
                parameters[i] = param != null && param instanceof JavaParam ? ((JavaParam)param).obj : param;
            }
        }
        return parameters;
    }

    private static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method[] methods = clazz.getDeclaredMethods();
        Method method = IoUtil.findMethodByName(methods, name, parameterTypes);
        if (method == null) {
            if (clazz.getSuperclass() != null) {
                return IoUtil.getDeclaredMethod(clazz.getSuperclass(), name, parameterTypes);
            }
            throw new NoSuchMethodException();
        }
        method.setAccessible(true);
        return method;
    }

    private static Method findMethodByName(Method[] list, String name, Class<?>[] parameterTypes) {
        if (name == null) {
            throw new NullPointerException("Method name must not be null.");
        }
        for (Method method : list) {
            if (!method.getName().equals(name) || !IoUtil.compareClassLists(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        return null;
    }

    private static boolean compareClassLists(Class<?>[] a, Class<?>[] b) {
        if (a == null) {
            return b == null || b.length == 0;
        }
        if (b == null) {
            return a.length == 0;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].isAssignableFrom(b[i]) || PRIMITIVE_MAP.containsKey(a[i]) && PRIMITIVE_MAP.get(a[i]).equals(PRIMITIVE_MAP.get(b[i]))) continue;
            return false;
        }
        return true;
    }

    public static void setPermissions(String path, int permissions) {
        IoUtil.callStaticMethod("android.os.FileUtils", "setPermissions", path, permissions, -1, -1);
    }

    static {
        PRIMITIVE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_MAP.put(Short.class, Short.TYPE);
        PRIMITIVE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_MAP.put(Boolean.TYPE, Boolean.TYPE);
        PRIMITIVE_MAP.put(Byte.TYPE, Byte.TYPE);
        PRIMITIVE_MAP.put(Character.TYPE, Character.TYPE);
        PRIMITIVE_MAP.put(Short.TYPE, Short.TYPE);
        PRIMITIVE_MAP.put(Integer.TYPE, Integer.TYPE);
        PRIMITIVE_MAP.put(Float.TYPE, Float.TYPE);
        PRIMITIVE_MAP.put(Long.TYPE, Long.TYPE);
        PRIMITIVE_MAP.put(Double.TYPE, Double.TYPE);
    }

    public static class JavaParam<T> {
        public final Class<? extends T> clazz;
        public final T obj;

        public JavaParam(Class<? extends T> clazz, T obj) {
            this.clazz = clazz;
            this.obj = obj;
        }
    }
}

