/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import io.flutter.Log;
import io.flutter.embedding.engine.IoUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SafelyLibraryLoader {
    private static final String LIB_DIR = "libso";
    private static List<String> sLoadedLibs = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    public static synchronized String loadLibrary(Context context, String library) {
        if (sLoadedLibs.contains(library)) {
            return "";
        }
        try {
            System.loadLibrary(library);
            sLoadedLibs.add(library);
        }
        catch (UnsatisfiedLinkError e) {
            String error;
            File output = SafelyLibraryLoader.getLibraryFile(context, library);
            if (output == null) {
                return "";
            }
            if (output.exists()) {
                output.delete();
            }
            if ((error = SafelyLibraryLoader.unpackLibrary(context, library, output)) != null) {
                Log.e("loadLibrary", e.getMessage() + "[" + error + "]");
                return null;
            }
            try {
                Log.e("loadLibrary", "output.getAbsolutePath:" + output.getAbsolutePath());
                System.load(output.getAbsolutePath());
                sLoadedLibs.add(library);
            }
            catch (Throwable t) {
                Log.e("loadLibrary", "Throwable: " + t.getMessage());
            }
            finally {
                return output.getAbsolutePath();
            }
        }
        catch (Throwable t) {
            return null;
        }
        return null;
    }

    private static File getLibraryFolder(Context context) {
        if (context == null || context.getFilesDir() == null) {
            return null;
        }
        File file = new File(context.getFilesDir(), LIB_DIR);
        if (!file.exists()) {
            IoUtil.mkdir(file.getAbsolutePath());
        }
        return file;
    }

    private static File getLibraryFile(Context context, String library) {
        String libName = System.mapLibraryName(library);
        File libraryFolder = SafelyLibraryLoader.getLibraryFolder(context);
        if (libraryFolder != null) {
            return new File(libraryFolder, libName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unpackLibrary(Context context, String library, File output) {
        String string;
        ZipEntry entry;
        FileOutputStream os;
        InputStream is;
        ZipFile file;
        block7: {
            file = null;
            is = null;
            os = null;
            ApplicationInfo appInfo = context.getApplicationInfo();
            file = new ZipFile(new File(appInfo.sourceDir), 1);
            String jniNameInApk = "lib/" + Build.CPU_ABI + "/" + System.mapLibraryName(library);
            entry = file.getEntry(jniNameInApk);
            if (entry != null) break block7;
            int lineCharIndex = Build.CPU_ABI.indexOf(45);
            jniNameInApk = "lib/" + Build.CPU_ABI.substring(0, lineCharIndex > 0 ? lineCharIndex : Build.CPU_ABI.length()) + "/" + System.mapLibraryName(library);
            entry = file.getEntry(jniNameInApk);
            if (entry != null) break block7;
            String string2 = "Library entry not found:" + jniNameInApk;
            IoUtil.safeClose(os);
            IoUtil.safeClose(is);
            IoUtil.safeClose(file);
            return string2;
        }
        try {
            int count;
            output.createNewFile();
            is = file.getInputStream(entry);
            os = new FileOutputStream(output);
            byte[] buffer = new byte[4096];
            while ((count = is.read(buffer)) > 0) {
                os.write(buffer, 0, count);
            }
            IoUtil.setPermissions(output.getAbsolutePath(), 493);
            string = null;
        }
        catch (Throwable th) {
            try {
                String string3 = th.getMessage();
                return string3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IoUtil.safeClose(os);
                IoUtil.safeClose(is);
                IoUtil.safeClose(file);
            }
        }
        IoUtil.safeClose(os);
        IoUtil.safeClose(is);
        IoUtil.safeClose(file);
        return string;
    }
}

