/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.BDFlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.SafelyLibraryLoader;
import io.flutter.embedding.engine.loader.ApplicationInfoLoader;
import io.flutter.embedding.engine.loader.FlutterApplicationInfo;
import io.flutter.embedding.engine.loader.ResourceExtractor;
import io.flutter.util.PathUtils;
import io.flutter.view.VsyncWaiter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.JSONObject;

public class FlutterLoader {
    private static final String TAG = "FlutterLoader";
    private static final String OLD_GEN_HEAP_SIZE_META_DATA_KEY = "io.flutter.embedding.android.OldGenHeapSize";
    private static final String ENABLE_SKPARAGRAPH_META_DATA_KEY = "io.flutter.embedding.android.EnableSkParagraph";
    static final String AOT_SHARED_LIBRARY_NAME = "aot-shared-library-name";
    static final String SNAPSHOT_ASSET_PATH_KEY = "snapshot-asset-path";
    static final String VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    static final String ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    private static final String DEFAULT_LIBRARY = "libflutter.so";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static final String DEBUG_FLUTTER_LIBS_DIR = "flutter_libs";
    private static final String DEBUG_FLUTTER_ASSET_DIR = "flutter_assets";
    private static final String DEFAULT_HOST_MANIFEST_JSON = "host_manifest.json";
    private static final String DEFAULT_OPTI_PROPS = "optimize.properties";
    private static final String DEFAULT_FLUTTER_ASSETS_DIR = "flutter_assets";
    private String flutterAssetsDir = "flutter_assets";
    private static final String ENABLE_TRIM_IN_VM = "io.flutter.embedding.android.EnableTrimVM";
    protected JSONObject mExtraDartParams;
    private static FlutterLoader instance;
    private boolean initialized = false;
    @Nullable
    private Settings settings;
    private long initStartTimestampMillis;
    private long startInitializationCostMillis;
    private FlutterApplicationInfo flutterApplicationInfo;
    private FlutterJNI flutterJNI;
    @Nullable
    Future<InitResult> initResultFuture;
    private onBundleRunListener onBundleRunListener;

    @Deprecated
    @NonNull
    public static FlutterLoader getInstance() {
        if (instance == null) {
            instance = new FlutterLoader();
        }
        return instance;
    }

    public FlutterLoader() {
        this(new FlutterJNI());
    }

    public void setExtraDartParams(JSONObject object) {
        this.mExtraDartParams = object;
    }

    public JSONObject getExtraDartParams() {
        return this.mExtraDartParams;
    }

    public FlutterLoader(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
    }

    public void startInitialization(@NonNull Context applicationContext) {
        this.startInitialization(applicationContext, new Settings());
    }

    public void startInitialization(@NonNull Context applicationContext, final @NonNull Settings settings) {
        if (this.settings != null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        final Context appContext = applicationContext.getApplicationContext();
        this.settings = settings;
        this.initStartTimestampMillis = SystemClock.uptimeMillis();
        this.flutterApplicationInfo = ApplicationInfoLoader.load(appContext);
        VsyncWaiter.getInstance((WindowManager)appContext.getSystemService("window")).init();
        Callable<InitResult> initTask = new Callable<InitResult>(){

            @Override
            public InitResult call() {
                ResourceExtractor resourceExtractor = FlutterLoader.this.initResources(appContext);
                long initTaskStartTimestamp = System.currentTimeMillis() * 1000L;
                if (settings != null && settings.isDebugModeEnable()) {
                    FlutterLoader.this.copyDebugFiles(appContext);
                    File libsDir = appContext.getDir(FlutterLoader.DEBUG_FLUTTER_LIBS_DIR, 0);
                    String soPath = libsDir.getAbsolutePath() + File.separator + FlutterLoader.DEFAULT_LIBRARY;
                    System.load(soPath);
                    Log.i(FlutterLoader.TAG, "DebugMode: use copied libflutter.so");
                } else if (settings != null && settings.getSoLoader() != null) {
                    settings.getSoLoader().loadLibrary(appContext, "flutter");
                } else {
                    FlutterLoader.this.flutterJNI.loadLibrary();
                }
                if (settings != null && settings.isSafeLoadAppSO()) {
                    settings.setApplicationLibraryPath(SafelyLibraryLoader.loadLibrary(appContext, "app"));
                    Log.d(FlutterLoader.TAG, "SafeLoad app path: " + settings.getApplicationLibraryPath());
                }
                if (BDFlutterInjector.instance().shouldLoadNative()) {
                    FlutterJNI.nativeTraceEngineInitApmStartAndEnd("init_task", initTaskStartTimestamp);
                }
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        FlutterLoader.this.flutterJNI.prefetchDefaultFontManager();
                    }
                });
                if (resourceExtractor != null) {
                    resourceExtractor.waitForCompletion();
                    if (settings != null && settings.monitorCallback != null) {
                        settings.monitorCallback.onMonitor("resourceExtractor.waitForCompletion", SystemClock.uptimeMillis() - FlutterLoader.this.initStartTimestampMillis);
                    }
                }
                return new InitResult(PathUtils.getFilesDir(appContext), PathUtils.getCacheDirectory(appContext), PathUtils.getDataDirectory(appContext));
            }
        };
        this.initResultFuture = Executors.newSingleThreadExecutor().submit(initTask);
        this.startInitializationCostMillis = SystemClock.uptimeMillis() - this.initStartTimestampMillis;
    }

    public void ensureInitializationComplete(@NonNull Context applicationContext, @Nullable String[] args) {
        if (this.initialized) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        try {
            boolean enableTrim;
            String hostManifestJson;
            if (this.initResultFuture.isDone()) {
                this.initStartTimestampMillis = SystemClock.uptimeMillis() - this.startInitializationCostMillis;
            }
            InitResult result = this.initResultFuture.get();
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-symbol-prefix=_binary_icudtl_dat");
            String nativeLibraryDir = this.settings.getNativeLibraryDir();
            if (nativeLibraryDir == null) {
                nativeLibraryDir = this.flutterApplicationInfo.nativeLibraryDir;
            }
            String applicationLibraryPath = this.settings.getApplicationLibraryPath();
            if (!this.settings.isDebugModeEnable()) {
                shellArgs.add("--icu-native-lib-path=" + nativeLibraryDir + File.separator + DEFAULT_LIBRARY);
            }
            if (args != null) {
                Collections.addAll(shellArgs, args);
            }
            String kernelPath = null;
            if (this.settings.isDebugModeEnable()) {
                File debugLibDir = applicationContext.getDir(DEBUG_FLUTTER_LIBS_DIR, 0);
                shellArgs.add("--icu-native-lib-path=" + debugLibDir.getAbsolutePath() + File.separator + DEFAULT_LIBRARY);
                String[] files = debugLibDir.list();
                boolean hasAppSo = false;
                for (String file : files) {
                    if (TextUtils.equals((CharSequence)file, (CharSequence)this.flutterApplicationInfo.aotSharedLibraryName)) {
                        hasAppSo = true;
                        break;
                    }
                    if (!TextUtils.equals((CharSequence)file, (CharSequence)"flutter_assets")) continue;
                    shellArgs.add("--extra-asset-dir=" + debugLibDir.getAbsolutePath() + File.separator + "flutter_assets");
                    Log.i(TAG, "DebugMode: use copied flutter_assets");
                }
                if (hasAppSo) {
                    shellArgs.add("--aot-shared-library-name=" + debugLibDir.getAbsolutePath() + File.separator + this.flutterApplicationInfo.aotSharedLibraryName);
                    Log.i(TAG, "DebugMode: use copied " + this.flutterApplicationInfo.aotSharedLibraryName);
                } else {
                    String snapshotAssetPath = debugLibDir.getAbsolutePath();
                    kernelPath = snapshotAssetPath + File.separator + DEFAULT_KERNEL_BLOB;
                    Log.i(TAG, "DebugMode: use copied kernel_blob.bin");
                    shellArgs.add("--snapshot-asset-path=" + snapshotAssetPath);
                    shellArgs.add("--vm-snapshot-data=" + this.flutterApplicationInfo.vmSnapshotData);
                    shellArgs.add("--isolate-snapshot-data=" + this.flutterApplicationInfo.isolateSnapshotData);
                }
            } else {
                shellArgs.add("--aot-shared-library-name=" + this.flutterApplicationInfo.aotSharedLibraryName);
                shellArgs.add("--aot-shared-library-name=" + nativeLibraryDir + File.separator + this.flutterApplicationInfo.aotSharedLibraryName);
            }
            if (applicationLibraryPath != null) {
                shellArgs.add("--application_library_path=" + applicationLibraryPath);
            }
            if (new File(hostManifestJson = PathUtils.getDataDirectory(applicationContext) + File.separator + this.flutterAssetsDir + File.separator + DEFAULT_HOST_MANIFEST_JSON).exists()) {
                shellArgs.add("--dnc-host");
            }
            shellArgs.add("--cache-dir-path=" + result.engineCachesPath);
            if (!this.flutterApplicationInfo.clearTextPermitted) {
                shellArgs.add("--disallow-insecure-connections");
            }
            if (this.flutterApplicationInfo.domainNetworkPolicy != null) {
                shellArgs.add("--domain-network-policy=" + this.flutterApplicationInfo.domainNetworkPolicy);
            }
            if (this.settings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + this.settings.getLogTag());
            }
            if (this.settings.isDisableLeakVM()) {
                shellArgs.add("--disable-leak-vm");
            }
            ApplicationInfo applicationInfo = applicationContext.getPackageManager().getApplicationInfo(applicationContext.getPackageName(), 128);
            Bundle metaData = applicationInfo.metaData;
            if (metaData != null && metaData.getBoolean(ENABLE_SKPARAGRAPH_META_DATA_KEY)) {
                shellArgs.add("--enable-skparagraph");
            }
            boolean bl = enableTrim = metaData != null ? metaData.getBoolean(ENABLE_TRIM_IN_VM, false) : false;
            if (enableTrim) {
                shellArgs.add("--enable-trim-vm");
            }
            if (ResourceExtractor.isX86Device() && !shellArgs.contains("--enable-software-rendering")) {
                shellArgs.add("--enable-software-rendering");
            }
            long nativeInitStartTimestamp = System.currentTimeMillis() * 1000L;
            long initTimeMillis = SystemClock.uptimeMillis() - this.initStartTimestampMillis;
            this.flutterJNI.init(applicationContext, shellArgs.toArray(new String[0]), kernelPath, result.appStoragePath, result.engineCachesPath, initTimeMillis, this.mExtraDartParams);
            this.initialized = true;
            if (this.settings.monitorCallback != null) {
                this.settings.monitorCallback.onMonitor("EnsureInitialized", SystemClock.uptimeMillis() - this.initStartTimestampMillis);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Flutter initialization failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void ensureInitializationCompleteAsync(final @NonNull Context applicationContext, final @Nullable String[] args, final @NonNull Handler callbackHandler, final @NonNull Runnable callback) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (this.initialized) {
            callbackHandler.post(callback);
            return;
        }
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InitResult result = FlutterLoader.this.initResultFuture.get();
                }
                catch (Exception e) {
                    Log.e(FlutterLoader.TAG, "Flutter initialization failed.", e);
                    throw new RuntimeException(e);
                }
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        FlutterLoader.this.ensureInitializationComplete(applicationContext.getApplicationContext(), args);
                        callbackHandler.post(callback);
                    }
                });
            }
        });
    }

    public boolean initialized() {
        return this.initialized;
    }

    private ResourceExtractor initResources(@NonNull Context applicationContext) {
        ResourceExtractor resourceExtractor = null;
        return resourceExtractor;
    }

    @NonNull
    public String findAppBundlePath() {
        return this.flutterApplicationInfo.flutterAssetsDir;
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset) {
        return this.fullAssetPathFrom(asset);
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset, @NonNull String packageName) {
        return this.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    @NonNull
    private String fullAssetPathFrom(@NonNull String filePath) {
        return this.flutterApplicationInfo.flutterAssetsDir + File.separator + filePath;
    }

    @NonNull
    private String fullAssetPathFrom2(@NonNull String filePath) {
        return filePath;
    }

    private void copyDebugFiles(@NonNull Context applicationContext) {
        Log.i(TAG, "DebugMode: start copy files..");
        File sourceDir = new File(applicationContext.getExternalFilesDir(null).getAbsolutePath() + File.separator + "flutter_debug");
        if (!sourceDir.exists()) {
            sourceDir.mkdirs();
            Log.i(TAG, "DebugMode: " + sourceDir.getAbsolutePath() + " not exists");
            return;
        }
        File[] sourceFiles = sourceDir.listFiles();
        if (sourceFiles == null || sourceFiles.length == 0) {
            Log.i(TAG, "DebugMode: " + sourceDir.getAbsolutePath() + " has no content");
            return;
        }
        File destDir = applicationContext.getDir(DEBUG_FLUTTER_LIBS_DIR, 0);
        if (destDir.exists()) {
            File[] filesIndest = destDir.listFiles();
            if (filesIndest != null && filesIndest.length > 0) {
                File[] fileArray = filesIndest;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file = fileArray[i];
                    boolean success = PathUtils.delete(file);
                    Log.i(TAG, "DebugMode: delete old " + file.getName() + " " + success);
                }
            }
        } else {
            destDir.mkdirs();
        }
        for (File file : sourceFiles) {
            boolean success = false;
            if (file.isDirectory()) {
                success = PathUtils.copyFolder(file, new File(destDir.getAbsolutePath() + File.separator + "flutter_assets" + File.separator + file.getName()));
                PathUtils.delete(file);
            } else {
                success = PathUtils.copyFile(file.getAbsolutePath(), destDir.getAbsolutePath() + File.separator + file.getName(), true);
            }
            if (!success) {
                throw new RuntimeException("Copy debug files Failed");
            }
            Log.i(TAG, "DebugMode: copy " + file.getName() + " success");
        }
    }

    public void onBundleRun() {
        if (this.onBundleRunListener != null) {
            this.onBundleRunListener.onBundleRun(FlutterJNI.nativeGetEngineInitInfo());
        }
    }

    public void setOnBundleRunListener(onBundleRunListener onBundleRunListener2) {
        this.onBundleRunListener = onBundleRunListener2;
    }

    public static interface onBundleRunListener {
        public void onBundleRun(long[] var1);
    }

    public static class Settings {
        private String logTag;
        private String nativeLibraryDir;
        private SoLoader soLoader;
        private MonitorCallback monitorCallback;
        private boolean disableLeakVM = false;
        private Runnable onInitResources;
        private InitExceptionCallback initExceptionCallback;
        private boolean enableDebugMode = false;
        private String applicationLibraryPath;
        private boolean enableSafeLoadAppSO = true;

        public boolean isDisableLeakVM() {
            return this.disableLeakVM;
        }

        public void disableLeakVM() {
            this.disableLeakVM = true;
        }

        public Runnable getOnInitResourcesCallback() {
            return this.onInitResources;
        }

        public void setOnInitResourcesCallback(Runnable callback) {
            this.onInitResources = callback;
        }

        public InitExceptionCallback getInitExceptionCallback() {
            return this.initExceptionCallback;
        }

        public void setInitExceptionCallback(InitExceptionCallback iec) {
            this.initExceptionCallback = iec;
        }

        public String getNativeLibraryDir() {
            return this.nativeLibraryDir;
        }

        public String getApplicationLibraryPath() {
            return this.applicationLibraryPath;
        }

        public SoLoader getSoLoader() {
            return this.soLoader;
        }

        public void setNativeLibraryDir(String dir) {
            this.nativeLibraryDir = dir;
        }

        public void setApplicationLibraryPath(String path) {
            this.applicationLibraryPath = path;
        }

        public void setSoLoader(SoLoader loader) {
            this.soLoader = loader;
        }

        public void setMonitorCallback(MonitorCallback monitorCallback) {
            this.monitorCallback = monitorCallback;
        }

        public boolean isDebugModeEnable() {
            return this.enableDebugMode;
        }

        public void setEnableDebugMode(boolean enableDebugMode) {
            this.enableDebugMode = enableDebugMode;
        }

        public boolean isSafeLoadAppSO() {
            return this.enableSafeLoadAppSO;
        }

        public void setEnableSafeLoadAppSO(boolean enableSafeLoadAppSO) {
            this.enableSafeLoadAppSO = enableSafeLoadAppSO;
        }

        @Nullable
        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }

    public static interface InitExceptionCallback {
        public void onRetryException(Throwable var1);

        public void onInitException(Throwable var1);
    }

    private static class InitResult {
        final String appStoragePath;
        final String engineCachesPath;
        final String dataDirPath;

        private InitResult(String appStoragePath, String engineCachesPath, String dataDirPath) {
            this.appStoragePath = appStoragePath;
            this.engineCachesPath = engineCachesPath;
            this.dataDirPath = dataDirPath;
        }
    }

    public static interface MonitorCallback {
        public void onMonitor(String var1, long var2);
    }

    public static interface SoLoader {
        public void loadLibrary(Context var1, String var2);
    }
}

