/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import io.flutter.Log;
import io.flutter.embedding.engine.loader.FlutterLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

class ResourceExtractor {
    private static final String TAG = "ResourceExtractor";
    private static final String TIMESTAMP_PREFIX = "res_timestamp-";
    private static final String[] SUPPORTED_ABIS = ResourceExtractor.getSupportedAbis();
    private static final int MAX_COPY_RETRY_COUNT = 1;
    @NonNull
    private final String mDataDirPath;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final PackageManager mPackageManager;
    @NonNull
    private final AssetManager mAssetManager;
    @NonNull
    private final HashSet<String> mResources;
    private ExtractTask mExtractTask;
    private FlutterLoader.Settings mSettings;

    static long getVersionCode(@NonNull PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return packageInfo.getLongVersionCode();
        }
        return packageInfo.versionCode;
    }

    static boolean isX86Device() {
        boolean isX86Device = false;
        if (SUPPORTED_ABIS != null && SUPPORTED_ABIS.length > 0) {
            for (String abi : SUPPORTED_ABIS) {
                if (abi == null || !abi.contains("86")) continue;
                isX86Device = true;
                break;
            }
        }
        return isX86Device;
    }

    ResourceExtractor(@NonNull String dataDirPath, @NonNull String packageName, @NonNull PackageManager packageManager, @NonNull AssetManager assetManager, FlutterLoader.Settings settings) {
        this.mDataDirPath = dataDirPath;
        this.mPackageName = packageName;
        this.mPackageManager = packageManager;
        this.mAssetManager = assetManager;
        this.mResources = new HashSet();
    }

    ResourceExtractor addResource(@NonNull String resource) {
        this.mResources.add(resource);
        return this;
    }

    ResourceExtractor addResources(@NonNull Collection<String> resources) {
        this.mResources.addAll(resources);
        return this;
    }

    ResourceExtractor start() {
        this.mExtractTask = new ExtractTask(this.mDataDirPath, this.mResources, this.mPackageName, this.mPackageManager, this.mAssetManager, this.mSettings);
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return this;
    }

    void waitForCompletion() {
        if (this.mExtractTask == null) {
            return;
        }
        try {
            this.mExtractTask.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            ResourceExtractor.deleteFiles(this.mDataDirPath, this.mResources);
        }
    }

    private static String[] getExistingTimestamps(File dataDir) {
        return dataDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(ResourceExtractor.TIMESTAMP_PREFIX);
            }
        });
    }

    private static void deleteFiles(@NonNull String dataDirPath, @NonNull HashSet<String> resources) {
        File dataDir = new File(dataDirPath);
        for (String resource : resources) {
            File file = new File(dataDir, resource);
            if (!file.exists()) continue;
            file.delete();
        }
        String[] existingTimestamps = ResourceExtractor.getExistingTimestamps(dataDir);
        if (existingTimestamps == null) {
            return;
        }
        for (String timestamp : existingTimestamps) {
            new File(dataDir, timestamp).delete();
        }
    }

    private static String checkTimestamp(@NonNull File dataDir, @NonNull PackageManager packageManager, @NonNull String packageName) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return TIMESTAMP_PREFIX;
        }
        if (packageInfo == null) {
            return TIMESTAMP_PREFIX;
        }
        String expectedTimestamp = TIMESTAMP_PREFIX + ResourceExtractor.getVersionCode(packageInfo) + "-" + packageInfo.lastUpdateTime;
        String[] existingTimestamps = ResourceExtractor.getExistingTimestamps(dataDir);
        if (existingTimestamps == null) {
            return expectedTimestamp;
        }
        if (existingTimestamps.length == 1) {
            // empty if block
        }
        if (existingTimestamps.length != 1 || !expectedTimestamp.equals(existingTimestamps[0])) {
            return expectedTimestamp;
        }
        return null;
    }

    private static void copy(@NonNull InputStream in, @NonNull OutputStream out) throws IOException {
        int i;
        byte[] buf = new byte[16384];
        while ((i = in.read(buf)) >= 0) {
            out.write(buf, 0, i);
        }
    }

    private static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        ArrayList<String> cpuAbis = new ArrayList<String>(Arrays.asList(Build.CPU_ABI, Build.CPU_ABI2));
        cpuAbis.removeAll(Arrays.asList(null, ""));
        return cpuAbis.toArray(new String[0]);
    }

    private static class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        @NonNull
        private final String mDataDirPath;
        @NonNull
        private final HashSet<String> mResources;
        @NonNull
        private final AssetManager mAssetManager;
        @NonNull
        private final String mPackageName;
        @NonNull
        private final PackageManager mPackageManager;
        private FlutterLoader.Settings mSettings;

        ExtractTask(@NonNull String dataDirPath, @NonNull HashSet<String> resources, @NonNull String packageName, @NonNull PackageManager packageManager, @NonNull AssetManager assetManager, FlutterLoader.Settings settings) {
            this.mDataDirPath = dataDirPath;
            this.mResources = resources;
            this.mAssetManager = assetManager;
            this.mPackageName = packageName;
            this.mPackageManager = packageManager;
            this.mSettings = settings;
        }

        protected Void doInBackground(Void ... unused) {
            File dataDir = new File(this.mDataDirPath);
            String timestamp = ResourceExtractor.checkTimestamp(dataDir, this.mPackageManager, this.mPackageName);
            if (timestamp == null) {
                return null;
            }
            ResourceExtractor.deleteFiles(this.mDataDirPath, this.mResources);
            if (!this.extractAPK(dataDir)) {
                return null;
            }
            if (timestamp != null) {
                try {
                    new File(dataDir, timestamp).createNewFile();
                }
                catch (IOException e) {
                    Log.w(ResourceExtractor.TAG, "Failed to write resource timestamp");
                }
            }
            if (this.mSettings != null && this.mSettings.getOnInitResourcesCallback() != null) {
                this.mSettings.getOnInitResourcesCallback().run();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private boolean extractAPK(@NonNull File dataDir) {
            for (String asset : this.mResources) {
                try {
                    String resource = "assets/" + asset;
                    File output = new File(dataDir, asset);
                    if (output.exists()) continue;
                    if (output.getParentFile() != null) {
                        output.getParentFile().mkdirs();
                    }
                    int copyRetryCount = 0;
                    boolean error = true;
                    do {
                        InputStream is = null;
                        OutputStream os = null;
                        try {
                            is = this.mAssetManager.open(asset);
                            os = new FileOutputStream(output);
                            ResourceExtractor.copy(is, os);
                            error = false;
                        }
                        catch (FileNotFoundException fnfe) {
                            throw fnfe;
                        }
                        catch (IOException ioe) {
                            error = true;
                            if (copyRetryCount == 1) {
                                throw ioe;
                            }
                            ++copyRetryCount;
                            Log.w(ResourceExtractor.TAG, "copy retry1:" + resource);
                            if (this.mSettings.getInitExceptionCallback() == null) continue;
                            this.mSettings.getInitExceptionCallback().onRetryException(ioe);
                        }
                        finally {
                            block22: {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    if (os != null) {
                                        os.close();
                                    }
                                }
                                catch (IOException ioe) {
                                    error = true;
                                    if (copyRetryCount == 1) {
                                        throw ioe;
                                    }
                                    ++copyRetryCount;
                                    Log.w(ResourceExtractor.TAG, "copy retry2:" + resource);
                                    if (this.mSettings.getInitExceptionCallback() == null) break block22;
                                    this.mSettings.getInitExceptionCallback().onRetryException(ioe);
                                }
                            }
                        }
                    } while (error);
                }
                catch (FileNotFoundException fnfe) {
                }
                catch (IOException ioe) {
                    Log.w(ResourceExtractor.TAG, "Exception unpacking resources: " + ioe.getMessage());
                    ResourceExtractor.deleteFiles(this.mDataDirPath, this.mResources);
                    return false;
                }
            }
            return true;
        }
    }
}

