/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.plugins;

import android.content.Context;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.view.ImageLoaderRegistry;
import io.flutter.view.ImageLoaderRegistryImpl;
import io.flutter.view.TextureRegistry;

public interface FlutterPlugin {
    public void onAttachedToEngine(@NonNull FlutterPluginBinding var1);

    public void onDetachedFromEngine(@NonNull FlutterPluginBinding var1);

    public static interface FlutterAssets {
        public String getAssetFilePathByName(@NonNull String var1);

        public String getAssetFilePathByName(@NonNull String var1, @NonNull String var2);

        public String getAssetFilePathBySubpath(@NonNull String var1);

        public String getAssetFilePathBySubpath(@NonNull String var1, @NonNull String var2);
    }

    public static class FlutterPluginBinding {
        private final Context applicationContext;
        private final FlutterEngine flutterEngine;
        private final BinaryMessenger binaryMessenger;
        private final TextureRegistry textureRegistry;
        private final PlatformViewRegistry platformViewRegistry;
        private final FlutterAssets flutterAssets;
        private final ImageLoaderRegistry imageLoaderRegistry;

        public FlutterPluginBinding(@NonNull Context applicationContext, @NonNull FlutterEngine flutterEngine, @NonNull BinaryMessenger binaryMessenger, @NonNull TextureRegistry textureRegistry, @NonNull PlatformViewRegistry platformViewRegistry, @NonNull FlutterAssets flutterAssets, @NonNull FlutterJNI flutterJNI) {
            this.applicationContext = applicationContext;
            this.flutterEngine = flutterEngine;
            this.binaryMessenger = binaryMessenger;
            this.textureRegistry = textureRegistry;
            this.platformViewRegistry = platformViewRegistry;
            this.flutterAssets = flutterAssets;
            this.imageLoaderRegistry = new ImageLoaderRegistryImpl(flutterJNI);
        }

        @NonNull
        public Context getApplicationContext() {
            return this.applicationContext;
        }

        @Deprecated
        @NonNull
        public FlutterEngine getFlutterEngine() {
            return this.flutterEngine;
        }

        @NonNull
        public BinaryMessenger getBinaryMessenger() {
            return this.binaryMessenger;
        }

        @NonNull
        public TextureRegistry getTextureRegistry() {
            return this.textureRegistry;
        }

        @NonNull
        public PlatformViewRegistry getPlatformViewRegistry() {
            return this.platformViewRegistry;
        }

        @NonNull
        public FlutterAssets getFlutterAssets() {
            return this.flutterAssets;
        }

        @NonNull
        public ImageLoaderRegistry getImageLoaderRegistry() {
            return this.imageLoaderRegistry;
        }
    }
}

