/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Insets;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.util.List;

@VisibleForTesting
@TargetApi(value=30)
@RequiresApi(value=30)
@SuppressLint(value={"NewApi", "Override"})
@Keep
class ImeSyncDeferringInsetsCallback {
    private int overlayInsetTypes;
    private int deferredInsetTypes;
    private View view;
    private WindowInsets lastWindowInsets;
    private AnimationCallback animationCallback;
    private InsetsListener insetsListener;
    private boolean animating = false;
    private boolean needsSave = false;

    ImeSyncDeferringInsetsCallback(@NonNull View view, int overlayInsetTypes, int deferredInsetTypes) {
        this.overlayInsetTypes = overlayInsetTypes;
        this.deferredInsetTypes = deferredInsetTypes;
        this.view = view;
        this.animationCallback = new AnimationCallback();
        this.insetsListener = new InsetsListener();
    }

    void install() {
        this.view.setWindowInsetsAnimationCallback((WindowInsetsAnimation.Callback)this.animationCallback);
        this.view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)this.insetsListener);
    }

    void remove() {
        this.view.setWindowInsetsAnimationCallback(null);
        this.view.setOnApplyWindowInsetsListener(null);
    }

    @VisibleForTesting
    View.OnApplyWindowInsetsListener getInsetsListener() {
        return this.insetsListener;
    }

    @VisibleForTesting
    WindowInsetsAnimation.Callback getAnimationCallback() {
        return this.animationCallback;
    }

    private class InsetsListener
    implements View.OnApplyWindowInsetsListener {
        private InsetsListener() {
        }

        public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
            ImeSyncDeferringInsetsCallback.this.view = view;
            if (ImeSyncDeferringInsetsCallback.this.needsSave) {
                ImeSyncDeferringInsetsCallback.this.lastWindowInsets = windowInsets;
                ImeSyncDeferringInsetsCallback.this.needsSave = false;
            }
            if (ImeSyncDeferringInsetsCallback.this.animating) {
                return WindowInsets.CONSUMED;
            }
            return view.onApplyWindowInsets(windowInsets);
        }
    }

    @Keep
    private class AnimationCallback
    extends WindowInsetsAnimation.Callback {
        AnimationCallback() {
            super(1);
        }

        public void onPrepare(WindowInsetsAnimation animation) {
            if ((animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) != 0) {
                ImeSyncDeferringInsetsCallback.this.animating = true;
                ImeSyncDeferringInsetsCallback.this.needsSave = true;
            }
        }

        public WindowInsets onProgress(WindowInsets insets, List<WindowInsetsAnimation> runningAnimations) {
            if (!ImeSyncDeferringInsetsCallback.this.animating || ImeSyncDeferringInsetsCallback.this.needsSave) {
                return insets;
            }
            boolean matching = false;
            for (WindowInsetsAnimation animation : runningAnimations) {
                if ((animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) == 0) continue;
                matching = true;
            }
            if (!matching) {
                return insets;
            }
            WindowInsets.Builder builder = new WindowInsets.Builder(ImeSyncDeferringInsetsCallback.this.lastWindowInsets);
            Insets newImeInsets = Insets.of((int)0, (int)0, (int)0, (int)Math.max(insets.getInsets((int)((ImeSyncDeferringInsetsCallback)ImeSyncDeferringInsetsCallback.this).deferredInsetTypes).bottom - insets.getInsets((int)((ImeSyncDeferringInsetsCallback)ImeSyncDeferringInsetsCallback.this).overlayInsetTypes).bottom, 0));
            builder.setInsets(ImeSyncDeferringInsetsCallback.this.deferredInsetTypes, newImeInsets);
            ImeSyncDeferringInsetsCallback.this.view.onApplyWindowInsets(builder.build());
            return insets;
        }

        public void onEnd(WindowInsetsAnimation animation) {
            if (ImeSyncDeferringInsetsCallback.this.animating && (animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) != 0) {
                ImeSyncDeferringInsetsCallback.this.animating = false;
                if (ImeSyncDeferringInsetsCallback.this.lastWindowInsets != null && ImeSyncDeferringInsetsCallback.this.view != null) {
                    ImeSyncDeferringInsetsCallback.this.view.dispatchApplyWindowInsets(ImeSyncDeferringInsetsCallback.this.lastWindowInsets);
                }
            }
        }
    }
}

