/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import android.content.Context;
import android.os.Build;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PathUtils {
    public static String getFilesDir(Context applicationContext) {
        return applicationContext.getFilesDir().getPath();
    }

    public static String getDataDirectory(Context applicationContext) {
        return applicationContext.getDir("flutter", 0).getPath();
    }

    public static String getCacheDirectory(Context applicationContext) {
        if (Build.VERSION.SDK_INT >= 21 && applicationContext.getCodeCacheDir() != null) {
            return applicationContext.getCodeCacheDir().getPath();
        }
        return applicationContext.getCacheDir().getPath();
    }

    public static boolean copyFile(String origFilePath, String destFilePath, boolean deleteOriginFile) {
        boolean copyIsFinish = false;
        try {
            File destDir = new File(destFilePath.substring(0, destFilePath.lastIndexOf("/")));
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            File origFile = new File(origFilePath);
            FileInputStream is = new FileInputStream(origFile);
            File destFile = new File(destFilePath);
            if (destFile.exists()) {
                destFile.delete();
            }
            destFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(destFile);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = is.read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            is.close();
            if (deleteOriginFile) {
                origFile.delete();
            }
            copyIsFinish = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return copyIsFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFolder(File src, File dest) {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                if (PathUtils.copyFolder(srcFile, destFile)) continue;
                return false;
            }
            return true;
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int length;
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean delete(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                return file.delete();
            }
            for (int i = 0; i < childFiles.length; ++i) {
                if (PathUtils.delete(childFiles[i])) continue;
                return false;
            }
            return file.delete();
        }
        return false;
    }
}

