/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.view.AndroidImageLoader;
import io.flutter.view.FlutterNativeView;
import io.flutter.view.ImageLoaderRegistry;

public class ImageLoaderRegistryImpl
implements ImageLoaderRegistry {
    private AndroidImageLoader mAndroidImageLoader;
    private FlutterNativeView mNativeView;
    private FlutterJNI mFlutterJNI;

    public ImageLoaderRegistryImpl(FlutterJNI flutterJNI) {
        this.mFlutterJNI = flutterJNI;
    }

    public ImageLoaderRegistryImpl(FlutterNativeView nativeView) {
        this.mNativeView = nativeView;
    }

    @Override
    public void registerImageLoader(AndroidImageLoader.RealImageLoader realImageLoader) {
        this.ensureAndroidImageLoaderAttached();
        this.mAndroidImageLoader.registerImageLoader(realImageLoader);
    }

    @Override
    public void unRegisterImageLoader() {
        this.mAndroidImageLoader.unRegisterImageLoader();
    }

    private void ensureAndroidImageLoaderAttached() {
        if (this.mAndroidImageLoader != null) {
            return;
        }
        this.mAndroidImageLoader = new AndroidImageLoader();
        this.registerAndroidImageLoader(this.mAndroidImageLoader);
    }

    private void registerAndroidImageLoader(AndroidImageLoader androidImageLoader) {
        if (this.mFlutterJNI == null) {
            this.mNativeView.getFlutterJNI().registerAndroidImageLoader(androidImageLoader);
        } else {
            this.mFlutterJNI.registerAndroidImageLoader(androidImageLoader);
        }
    }

    private void unRegisterAndroidImageLoader() {
        if (this.mFlutterJNI == null) {
            this.mNativeView.getFlutterJNI().unRegisterAndroidImageLoader();
        } else {
            this.mFlutterJNI.unRegisterAndroidImageLoader();
        }
    }
}

