/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.view.Choreographer;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.FlutterJNI;

public class VsyncWaiter {
    private static VsyncWaiter instance;
    @NonNull
    private final WindowManager windowManager;
    private final FlutterJNI.AsyncWaitForVsyncDelegate asyncWaitForVsyncDelegate = new FlutterJNI.AsyncWaitForVsyncDelegate(){

        @Override
        public void asyncWaitForVsync(final long cookie) {
            Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    float fps = 60.0f;
                    Display display = VsyncWaiter.this.windowManager.getDefaultDisplay();
                    if (display != null) {
                        fps = VsyncWaiter.this.windowManager.getDefaultDisplay().getRefreshRate();
                    }
                    long refreshPeriodNanos = (long)(1.0E9 / (double)fps);
                    FlutterJNI.nativeOnVsync(frameTimeNanos, frameTimeNanos + refreshPeriodNanos, cookie);
                }
            });
        }
    };

    @NonNull
    public static VsyncWaiter getInstance(@NonNull WindowManager windowManager) {
        if (instance == null) {
            instance = new VsyncWaiter(windowManager);
        }
        return instance;
    }

    private VsyncWaiter(@NonNull WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public void init() {
        FlutterJNI.setAsyncWaitForVsyncDelegate(this.asyncWaitForVsyncDelegate);
        float fps = this.windowManager.getDefaultDisplay().getRefreshRate();
        FlutterJNI.setRefreshRateFPS(fps);
    }
}

