/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.clickhouse;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;

public final class ClickHouseConstants$ {
    public static ClickHouseConstants$ MODULE$;
    private final Tuple2<String, String> DescribeTableResultField;
    private final int Date32Min;
    private final int Date32Max;
    private final long DateTime64MinEpochSeconds;
    private final long DateTime64MaxEpochSeconds;
    private final Instant DateTime64MinInstant;
    private final Instant DateTime64MaxInstant;
    private final Timestamp DateTime64MinTimestamp;
    private final Timestamp DateTime64MaxTimestamp;

    static {
        new ClickHouseConstants$();
    }

    public final int ClickHouseHttpPort() {
        return 8123;
    }

    public final String ClickHouseJdbcScheme() {
        return "clickhouse";
    }

    public final String SystemDatabase() {
        return "system";
    }

    public final String TablesTable() {
        return "tables";
    }

    public final String ClustersTable() {
        return "clusters";
    }

    public final String PartitionTable() {
        return "parts";
    }

    public final String CnchTableInfo() {
        return "cnch_table_info";
    }

    public final String CnchBinlogs() {
        return "cnch_binlogs";
    }

    public final String BinlogTableSuffix() {
        return "$binlog";
    }

    public final String CnchMaxBsn() {
        return "max_bsn";
    }

    public final String CnchMinBsn() {
        return "min_bsn";
    }

    public final String CnchBsn() {
        return "bsn";
    }

    public final String CnchBinlogEventType() {
        return "binlog_event_type";
    }

    public final String CnchBinlogBsn() {
        return "_binlog_bsn";
    }

    public final String CnchBinlogRowNum() {
        return "rows_count";
    }

    public final String CnchBinlogBsnRowNum() {
        return "_part_row_number";
    }

    public final String CnchBinlogShardId() {
        return "binlog_shard_id";
    }

    public final String CnchShardStats() {
        return "shard_stats";
    }

    public final String CnchBinlogCommitTime() {
        return "commit_time";
    }

    public final String ClusterIdField() {
        return "cluster";
    }

    public final String ShardNumberField() {
        return "shard_num";
    }

    public final String ShardCountField() {
        return "shard_count";
    }

    public final String ShardIpField() {
        return "ip";
    }

    public final String ShardIpv4Field() {
        return "ipv4";
    }

    public final String ShardIpv6Field() {
        return "ipv6";
    }

    public final String ShardPortField() {
        return "port";
    }

    public final String HostAddressField() {
        return "host_address";
    }

    public final String EniIp() {
        return "eni_ip";
    }

    public final String TablePartitionIdField() {
        return "_partition_id";
    }

    public final String ColumnsTable() {
        return "columns";
    }

    public final String PositionField() {
        return "position";
    }

    public final String CommonTableLocalType() {
        return "common_table_type=LOCAL";
    }

    public final String ShowDatabasesResultField() {
        return "name";
    }

    public final String DeleteFlagField() {
        return "_delete_flag_";
    }

    public final String UpdateColumnsField() {
        return "_update_columns_";
    }

    public final String ShowTablesResultField() {
        return "name";
    }

    public final Tuple2<String, String> DescribeTableResultField() {
        return this.DescribeTableResultField;
    }

    public final String ShowCreateTableResultField() {
        return "statement";
    }

    public final String MoveBucketPhaseField() {
        return "phase";
    }

    public final String TableIsReadOnlyKey() {
        return "table_is_read_only";
    }

    public final int Date32Min() {
        return this.Date32Min;
    }

    public final int Date32Max() {
        return this.Date32Max;
    }

    public final long DateTime64MinEpochSeconds() {
        return this.DateTime64MinEpochSeconds;
    }

    public final long DateTime64MaxEpochSeconds() {
        return this.DateTime64MaxEpochSeconds;
    }

    public final Instant DateTime64MinInstant() {
        return this.DateTime64MinInstant;
    }

    public final Instant DateTime64MaxInstant() {
        return this.DateTime64MaxInstant;
    }

    public final Timestamp DateTime64MinTimestamp() {
        return this.DateTime64MinTimestamp;
    }

    public final Timestamp DateTime64MaxTimestamp() {
        return this.DateTime64MaxTimestamp;
    }

    private ClickHouseConstants$() {
        MODULE$ = this;
        this.DescribeTableResultField = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"type");
        this.Date32Min = (int)LocalDate.of(1925, 1, 1).toEpochDay();
        this.Date32Max = (int)LocalDate.of(2283, 11, 11).toEpochDay();
        this.DateTime64MinEpochSeconds = LocalDateTime.of(LocalDate.of(1925, 1, 1), LocalTime.MIN).toEpochSecond(ZoneOffset.UTC);
        this.DateTime64MaxEpochSeconds = LocalDateTime.of(LocalDate.of(2283, 11, 11), LocalTime.MAX).toEpochSecond(ZoneOffset.UTC);
        this.DateTime64MinInstant = Instant.ofEpochSecond(this.DateTime64MinEpochSeconds());
        this.DateTime64MaxInstant = Instant.ofEpochSecond(this.DateTime64MaxEpochSeconds());
        this.DateTime64MinTimestamp = Timestamp.from(this.DateTime64MinInstant());
        this.DateTime64MaxTimestamp = Timestamp.from(this.DateTime64MaxInstant());
    }
}

