/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.clickhouse;

import com.bytedance.bytehouse.commons.ChainingOps$;
import com.bytedance.bytehouse.commons.package$;
import com.bytedance.bytehouse.commons.package$StringOps$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ClickHouseExprUtils$ {
    public static ClickHouseExprUtils$ MODULE$;
    private final String regexContainsPayload;
    private final String regexCommaSplitBetweenRawNames;
    private final String regexCommaSplitBetweenBackQuotedNames;
    private final String regexPlusFunctionSplitBetweenRawNames;
    private final String regexPlusFunctionSplitBetweenBackquotedNames;
    private final String regexRawName;
    private final String regexBackQuotedName;
    private final String regexFunctionWithRawNames;
    private final String regexFunctionWithBackQuotedNames;
    private final String regexPlusFunctionWithRawNames;
    private final String regexPlusFunctionWithBackquotedNames;
    private final String regexFunctionWithRawOrBackQuotedNames;

    static {
        new ClickHouseExprUtils$();
    }

    public Option<String> getFunctionName(String expr) {
        String string = expr.trim();
        if (string.matches(this.regexRawName())) {
            return None$.MODULE$;
        }
        if (string.matches(this.regexBackQuotedName())) {
            return None$.MODULE$;
        }
        if (string.matches(this.regexFunctionWithRawNames())) {
            return new Some((Object)this.extractFuncName(string));
        }
        if (string.matches(this.regexFunctionWithBackQuotedNames())) {
            return new Some((Object)this.extractFuncName(string));
        }
        if (string.matches(this.regexFunctionWithRawOrBackQuotedNames())) {
            return new Some((Object)this.extractFuncName(string));
        }
        throw new IllegalArgumentException(new StringBuilder(20).append("Illegal expression: ").append(string).toString());
    }

    public String[] getOperands(String expr) {
        String string = expr.trim();
        if (string.matches(this.regexRawName())) {
            return (String[])((Object[])new String[]{string});
        }
        if (string.matches(this.regexPlusFunctionWithRawNames())) {
            return string.split(this.regexPlusFunctionSplitBetweenRawNames());
        }
        if (string.matches(this.regexPlusFunctionWithBackquotedNames())) {
            return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split(this.regexPlusFunctionSplitBetweenBackquotedNames()))).map((Function1 & java.io.Serializable & Serializable)x -> MODULE$.removeBackQuote((String)x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        if (string.matches(this.regexBackQuotedName())) {
            return (String[])((Object[])new String[]{this.removeBackQuote(string)});
        }
        if (string.matches(this.regexFunctionWithRawNames())) {
            return this.getFunctionPayload(string).split(this.regexCommaSplitBetweenRawNames());
        }
        if (string.matches(this.regexFunctionWithBackQuotedNames())) {
            return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getFunctionPayload(string).split(this.regexCommaSplitBetweenBackQuotedNames()))).map((Function1 & java.io.Serializable & Serializable)x -> MODULE$.removeBackQuote((String)x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        throw new IllegalArgumentException(new StringBuilder(20).append("Illegal expression: ").append(string).toString());
    }

    public String backQuoteOperands(String expr) {
        String string = expr.trim();
        if (string.matches(this.regexRawName())) {
            return package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps(string));
        }
        if (string.matches(this.regexBackQuotedName())) {
            return string;
        }
        if (string.matches(this.regexFunctionWithRawNames())) {
            return this.modifyFunctionExpr(string, this.regexCommaSplitBetweenRawNames(), (Function1<String, String>)(Function1 & java.io.Serializable & Serializable)x$1 -> package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps((String)x$1)));
        }
        if (string.matches(this.regexFunctionWithBackQuotedNames())) {
            return this.modifyFunctionExpr(string, this.regexCommaSplitBetweenBackQuotedNames(), (Function1<String, String>)(Function1 & java.io.Serializable & Serializable)x$2 -> Predef$.MODULE$.wrapString(x$2).self());
        }
        if (string.matches(this.regexPlusFunctionWithRawNames())) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split(this.regexPlusFunctionSplitBetweenRawNames()))).map((Function1 & java.io.Serializable & Serializable)x$3 -> package$StringOps$.MODULE$.backQuoted$extension(package$.MODULE$.StringOps((String)x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("", " + ", "");
        }
        throw new IllegalArgumentException(new StringBuilder(20).append("Illegal expression: ").append(string).toString());
    }

    public boolean containsPayload(String expr) {
        return BoxesRunTime.unboxToBoolean(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(package$StringOps$.MODULE$.trimExtraWhitespace$extension(package$.MODULE$.StringOps(expr))), (Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClickHouseExprUtils$.$anonfun$containsPayload$1(x0$1))));
    }

    public String getFunctionPayload(String expr) {
        return StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(expr), expr.indexOf("(") + 1, expr.lastIndexOf(")")).trim();
    }

    private String modifyFunctionExpr(String x, String regexSplit, Function1<String, String> f) {
        Tuple2<String, String> tuple2 = this.unapplyFunctionString(x);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fName = (String)tuple2._1();
        String fPayload = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fName, (Object)fPayload);
        String fName2 = (String)tuple22._1();
        String fPayload2 = (String)tuple22._2();
        return (String)ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fPayload2.split(regexSplit))).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")), (Function1 & java.io.Serializable & Serializable)quotedPayload -> new StringBuilder(2).append(fName2).append("(").append((String)quotedPayload).append(")").toString());
    }

    private String regexContainsPayload() {
        return this.regexContainsPayload;
    }

    private String regexCommaSplitBetweenRawNames() {
        return this.regexCommaSplitBetweenRawNames;
    }

    private String regexCommaSplitBetweenBackQuotedNames() {
        return this.regexCommaSplitBetweenBackQuotedNames;
    }

    private String regexPlusFunctionSplitBetweenRawNames() {
        return this.regexPlusFunctionSplitBetweenRawNames;
    }

    private String regexPlusFunctionSplitBetweenBackquotedNames() {
        return this.regexPlusFunctionSplitBetweenBackquotedNames;
    }

    private String regexRawName() {
        return this.regexRawName;
    }

    private String regexBackQuotedName() {
        return this.regexBackQuotedName;
    }

    private String regexFunctionWithRawNames() {
        return this.regexFunctionWithRawNames;
    }

    private String regexFunctionWithBackQuotedNames() {
        return this.regexFunctionWithBackQuotedNames;
    }

    private String regexPlusFunctionWithRawNames() {
        return this.regexPlusFunctionWithRawNames;
    }

    private String regexPlusFunctionWithBackquotedNames() {
        return this.regexPlusFunctionWithBackquotedNames;
    }

    private String regexFunctionWithRawOrBackQuotedNames() {
        return this.regexFunctionWithRawOrBackQuotedNames;
    }

    private Tuple2<String, String> unapplyFunctionString(String expr) {
        int idxLeftParenthesis = expr.indexOf("(");
        int idxRightParenthesis = expr.lastIndexOf(")");
        return new Tuple2((Object)StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(expr), 0, idxLeftParenthesis).trim(), (Object)StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(expr), idxLeftParenthesis + 1, idxRightParenthesis).trim());
    }

    private String extractFuncName(String expr) {
        return StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(expr), 0, expr.indexOf("(")).trim();
    }

    private String removeBackQuote(String x) {
        return StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(x), 1, x.length() - 1);
    }

    public static final /* synthetic */ boolean $anonfun$containsPayload$1(String x0$1) {
        String string = x0$1;
        return string.matches(MODULE$.regexContainsPayload());
    }

    private ClickHouseExprUtils$() {
        MODULE$ = this;
        this.regexContainsPayload = "^\\(.+\\)$";
        this.regexCommaSplitBetweenRawNames = "\\b\\s*,\\s*\\b";
        this.regexCommaSplitBetweenBackQuotedNames = "(?<=`)\\s*,\\s*(?=`)";
        this.regexPlusFunctionSplitBetweenRawNames = "\\b\\s*\\+\\s*\\b";
        this.regexPlusFunctionSplitBetweenBackquotedNames = "(?<=`)\\s*\\+\\s*(?=`)";
        this.regexRawName = "^[a-zA-Z_][\\w_]*$";
        this.regexBackQuotedName = "^`.+`$";
        this.regexFunctionWithRawNames = "^[a-zA-Z_]\\w*\\([a-zA-Z_][\\w_]*(\\s*,\\s*[a-zA-Z_][\\w_]*)*\\)$";
        this.regexFunctionWithBackQuotedNames = "^[a-zA-Z_]\\w*\\(`.+`(\\s*,\\s*`.+`)*\\)$";
        this.regexPlusFunctionWithRawNames = "^\\w*(?:\\s*[+]\\s*\\w*)+$";
        this.regexPlusFunctionWithBackquotedNames = "^`\\w*`(?:\\s*[+]\\s*`\\w*`)+$";
        this.regexFunctionWithRawOrBackQuotedNames = "^[a-zA-Z_]\\w*\\(([a-zA-Z_][\\w_]*|`.+`)(\\s*,\\s*([a-zA-Z_][\\w_]*|`.+`))*\\)$";
    }
}

