/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.clickhouse.functions;

import java.math.BigInteger;

public class DoradoCityHashImpl {
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final long k3 = -3942382747735136937L;
    private static final BigInteger TWO_64 = BigInteger.ONE.shiftLeft(64);
    private static final long kMul = -7070675565921424023L;

    public static String asUnsignedDecimalString(long l) {
        BigInteger bigInteger = BigInteger.valueOf(l);
        if (bigInteger.signum() < 0) {
            bigInteger = bigInteger.add(TWO_64);
        }
        return bigInteger.toString();
    }

    private static long toLongLE(byte[] byArray, int n) {
        return ((long)byArray[n + 7] << 56) + ((long)(byArray[n + 6] & 0xFF) << 48) + ((long)(byArray[n + 5] & 0xFF) << 40) + ((long)(byArray[n + 4] & 0xFF) << 32) + ((long)(byArray[n + 3] & 0xFF) << 24) + (long)((byArray[n + 2] & 0xFF) << 16) + (long)((byArray[n + 1] & 0xFF) << 8) + (long)((byArray[n + 0] & 0xFF) << 0);
    }

    private static int toIntLE(byte[] byArray, int n) {
        return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 0] & 0xFF) << 0);
    }

    private static long fetch64(byte[] byArray, int n) {
        return DoradoCityHashImpl.toLongLE(byArray, n);
    }

    public static long bswap64(long l) {
        return l << 56 & 0xFF00000000000000L | l << 40 & 0xFF000000000000L | l << 24 & 0xFF0000000000L | l << 8 & 0xFF00000000L | l >>> 8 & 0xFF000000L | l >>> 24 & 0xFF0000L | l >>> 40 & 0xFF00L | l >>> 56 & 0xFFL;
    }

    public static long bswap64_OS(long l) {
        return (l & 0xFF00000000000000L) >>> 56 | (l & 0xFF000000000000L) >>> 40 | (l & 0xFF0000000000L) >>> 24 | (l & 0xFF00000000L) << 8 | (l & 0xFF000000L) << 8 | (l & 0xFF0000L) << 24 | (l & 0xFF00L) << 40 | (l & 0xFFL) << 56;
    }

    private static int fetch32(byte[] byArray, int n) {
        return DoradoCityHashImpl.toIntLE(byArray, n);
    }

    private static long rotate(long l, int n) {
        return n == 0 ? l : l >>> n | l << 64 - n;
    }

    private static long rotateByAtLeast1(long l, int n) {
        return l >>> n | l << 64 - n;
    }

    private static long shiftMix(long l) {
        return l ^ l >>> 47;
    }

    private static long hash128to64(long l, long l2) {
        long l3 = (l ^ l2) * -7070675565921424023L;
        l3 ^= l3 >>> 47;
        long l4 = (l2 ^ l3) * -7070675565921424023L;
        l4 ^= l4 >>> 47;
        return l4 *= -7070675565921424023L;
    }

    public static long combine(long l, long l2) {
        return DoradoCityHashImpl.hashLen16(l, l2);
    }

    private static long hashLen16(long l, long l2) {
        return DoradoCityHashImpl.hash128to64(l, l2);
    }

    private static long hashLen16(long l, long l2, long l3) {
        long l4 = (l ^ l2) * l3;
        l4 ^= l4 >>> 47;
        long l5 = (l2 ^ l4) * l3;
        l5 ^= l5 >>> 47;
        return l5 *= l3;
    }

    private static long hashLen0to16(byte[] byArray, int n, int n2) {
        if (n2 >= 8) {
            long l = -7286425919675154353L + (long)(n2 * 2);
            long l2 = DoradoCityHashImpl.fetch64(byArray, n + 0) + -7286425919675154353L;
            long l3 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 8);
            long l4 = DoradoCityHashImpl.rotate(l3, 37) * l + l2;
            long l5 = (DoradoCityHashImpl.rotate(l2, 25) + l3) * l;
            return DoradoCityHashImpl.hashLen16(l4, l5, l);
        }
        if (n2 >= 4) {
            long l = -7286425919675154353L + (long)(n2 * 2);
            long l6 = 0xFFFFFFFFL & (long)DoradoCityHashImpl.fetch32(byArray, n + 0);
            return DoradoCityHashImpl.hashLen16((l6 << 3) + (long)n2, 0xFFFFFFFFL & (long)DoradoCityHashImpl.fetch32(byArray, n + n2 - 4), l);
        }
        if (n2 > 0) {
            int n3 = byArray[n + 0] & 0xFF;
            int n4 = byArray[n + (n2 >>> 1)] & 0xFF;
            int n5 = byArray[n + n2 - 1] & 0xFF;
            int n6 = n3 + (n4 << 8);
            int n7 = n2 + (n5 << 2);
            return DoradoCityHashImpl.shiftMix((long)n6 * -7286425919675154353L ^ (long)n7 * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLen17to32(byte[] byArray, int n, int n2) {
        long l = -7286425919675154353L + (long)(n2 * 2);
        long l2 = DoradoCityHashImpl.fetch64(byArray, n + 0) * -5435081209227447693L;
        long l3 = DoradoCityHashImpl.fetch64(byArray, n + 8);
        long l4 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 8) * l;
        long l5 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 16) * -7286425919675154353L;
        return DoradoCityHashImpl.hashLen16(DoradoCityHashImpl.rotate(l2 + l3, 43) + DoradoCityHashImpl.rotate(l4, 30) + l5, l2 + DoradoCityHashImpl.rotate(l3 + -7286425919675154353L, 18) + l4, l);
    }

    private static long[] weakHashLen32WithSeeds(long l, long l2, long l3, long l4, long l5, long l6) {
        l6 = DoradoCityHashImpl.rotate(l6 + (l5 += l) + l4, 21);
        long l7 = l5;
        l5 += l2;
        return new long[]{l5 + l4, (l6 += DoradoCityHashImpl.rotate(l5 += l3, 44)) + l7};
    }

    private static long[] weakHashLen32WithSeeds(byte[] byArray, int n, long l, long l2) {
        return DoradoCityHashImpl.weakHashLen32WithSeeds(DoradoCityHashImpl.fetch64(byArray, n + 0), DoradoCityHashImpl.fetch64(byArray, n + 8), DoradoCityHashImpl.fetch64(byArray, n + 16), DoradoCityHashImpl.fetch64(byArray, n + 24), l, l2);
    }

    private static long hashLen33to64(byte[] byArray, int n, int n2) {
        long l = -7286425919675154353L + (long)(n2 * 2);
        long l2 = DoradoCityHashImpl.fetch64(byArray, n + 0) * -7286425919675154353L;
        long l3 = DoradoCityHashImpl.fetch64(byArray, n + 8);
        long l4 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 24);
        long l5 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 32);
        long l6 = DoradoCityHashImpl.fetch64(byArray, n + 16) * -7286425919675154353L;
        long l7 = DoradoCityHashImpl.fetch64(byArray, n + 24) * 9L;
        long l8 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 8);
        long l9 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 16) * l;
        long l10 = DoradoCityHashImpl.rotate(l2 + l8, 43) + (DoradoCityHashImpl.rotate(l3, 30) + l4) * 9L;
        long l11 = (l2 + l8 ^ l5) + l7 + 1L;
        long l12 = DoradoCityHashImpl.bswap64((l10 + l11) * l) + l9;
        long l13 = DoradoCityHashImpl.rotate(l6 + l7, 42) + l4;
        long l14 = (DoradoCityHashImpl.bswap64((l11 + l12) * l) + l8) * l;
        long l15 = l6 + l7 + l4;
        l2 = DoradoCityHashImpl.bswap64((l13 + l15) * l + l14) + l3;
        l3 = DoradoCityHashImpl.shiftMix((l15 + l2) * l + l5 + l9) * l;
        return l3 + l13;
    }

    public static long cityHash64(byte[] byArray, int n, int n2) {
        if (n2 <= 32) {
            if (n2 <= 16) {
                return DoradoCityHashImpl.hashLen0to16(byArray, n, n2);
            }
            return DoradoCityHashImpl.hashLen17to32(byArray, n, n2);
        }
        if (n2 <= 64) {
            return DoradoCityHashImpl.hashLen33to64(byArray, n, n2);
        }
        long l = DoradoCityHashImpl.fetch64(byArray, n + n2 - 40);
        long l2 = DoradoCityHashImpl.fetch64(byArray, n + n2 - 16) + DoradoCityHashImpl.fetch64(byArray, n + n2 - 56);
        long l3 = DoradoCityHashImpl.hashLen16(DoradoCityHashImpl.fetch64(byArray, n + n2 - 48) + (long)n2, DoradoCityHashImpl.fetch64(byArray, n + n2 - 24));
        long[] lArray = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + n2 - 64, n2, l3);
        long[] lArray2 = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + n2 - 32, l2 + -5435081209227447693L, l);
        l = l * -5435081209227447693L + DoradoCityHashImpl.fetch64(byArray, n + 0);
        n2 = n2 - 1 & 0xFFFFFFC0;
        do {
            l = DoradoCityHashImpl.rotate(l + l2 + lArray[0] + DoradoCityHashImpl.fetch64(byArray, n + 8), 37) * -5435081209227447693L;
            l2 = DoradoCityHashImpl.rotate(l2 + lArray[1] + DoradoCityHashImpl.fetch64(byArray, n + 48), 42) * -5435081209227447693L;
            l3 = DoradoCityHashImpl.rotate(l3 + lArray2[0], 33) * -5435081209227447693L;
            lArray = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + 0, lArray[1] * -5435081209227447693L, (l ^= lArray2[1]) + lArray2[0]);
            lArray2 = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + 32, l3 + lArray2[1], (l2 += lArray[0] + DoradoCityHashImpl.fetch64(byArray, n + 40)) + DoradoCityHashImpl.fetch64(byArray, n + 16));
            long l4 = l3;
            l3 = l;
            l = l4;
            n += 64;
        } while ((n2 -= 64) != 0);
        return DoradoCityHashImpl.hashLen16(DoradoCityHashImpl.hashLen16(lArray[0], lArray2[0]) + DoradoCityHashImpl.shiftMix(l2) * -5435081209227447693L + l3, DoradoCityHashImpl.hashLen16(lArray[1], lArray2[1]) + l);
    }

    public static BigInteger long2UnsignedBigInteger(long l) {
        String string = DoradoCityHashImpl.asUnsignedDecimalString(l);
        return new BigInteger(string);
    }

    public static long cityHash64WithSeed(byte[] byArray, int n, int n2, long l) {
        return DoradoCityHashImpl.cityHash64WithSeeds(byArray, n, n2, -7286425919675154353L, l);
    }

    public static long cityHash64WithSeeds(byte[] byArray, int n, int n2, long l, long l2) {
        return DoradoCityHashImpl.hashLen16(DoradoCityHashImpl.cityHash64(byArray, n, n2) - l, l2);
    }

    public static long[] cityMurmur(byte[] byArray, int n, int n2, long l, long l2) {
        long l3 = l;
        long l4 = l2;
        long l5 = 0L;
        long l6 = 0L;
        int n3 = n2 - 16;
        if (n3 <= 0) {
            l3 = DoradoCityHashImpl.shiftMix(l3 * -5435081209227447693L) * -5435081209227447693L;
            l5 = l4 * -5435081209227447693L + DoradoCityHashImpl.hashLen0to16(byArray, n, n2);
            l6 = DoradoCityHashImpl.shiftMix(l3 + (n2 >= 8 ? DoradoCityHashImpl.fetch64(byArray, n + 0) : l5));
        } else {
            l5 = DoradoCityHashImpl.hashLen16(DoradoCityHashImpl.fetch64(byArray, n + n2 - 8) + -5435081209227447693L, l3);
            l6 = DoradoCityHashImpl.hashLen16(l4 + (long)n2, l5 + DoradoCityHashImpl.fetch64(byArray, n + n2 - 16));
            l3 += l6;
            do {
                l3 ^= DoradoCityHashImpl.shiftMix(DoradoCityHashImpl.fetch64(byArray, n + 0) * -5435081209227447693L) * -5435081209227447693L;
                l4 ^= (l3 *= -5435081209227447693L);
                l5 ^= DoradoCityHashImpl.shiftMix(DoradoCityHashImpl.fetch64(byArray, n + 8) * -5435081209227447693L) * -5435081209227447693L;
                l6 ^= (l5 *= -5435081209227447693L);
                n += 16;
            } while ((n3 -= 16) > 0);
        }
        l3 = DoradoCityHashImpl.hashLen16(l3, l5);
        l4 = DoradoCityHashImpl.hashLen16(l6, l4);
        return new long[]{l3 ^ l4, DoradoCityHashImpl.hashLen16(l4, l3)};
    }

    public static long[] cityHash128WithSeed(byte[] byArray, int n, int n2, long l, long l2) {
        if (n2 < 128) {
            return DoradoCityHashImpl.cityMurmur(byArray, n, n2, l, l2);
        }
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        long l3 = l;
        long l4 = l2;
        long l5 = -5435081209227447693L * (long)n2;
        lArray[0] = DoradoCityHashImpl.rotate(l4 ^ 0xB492B66FBE98F273L, 49) * -5435081209227447693L + DoradoCityHashImpl.fetch64(byArray, n);
        lArray[1] = DoradoCityHashImpl.rotate(lArray[0], 42) * -5435081209227447693L + DoradoCityHashImpl.fetch64(byArray, n + 8);
        lArray2[0] = DoradoCityHashImpl.rotate(l4 + l5, 35) * -5435081209227447693L + l3;
        lArray2[1] = DoradoCityHashImpl.rotate(l3 + DoradoCityHashImpl.fetch64(byArray, n + 88), 53) * -5435081209227447693L;
        do {
            l3 = DoradoCityHashImpl.rotate(l3 + l4 + lArray[0] + DoradoCityHashImpl.fetch64(byArray, n + 8), 37) * -5435081209227447693L;
            l4 = DoradoCityHashImpl.rotate(l4 + lArray[1] + DoradoCityHashImpl.fetch64(byArray, n + 48), 42) * -5435081209227447693L;
            l4 += lArray[0] + DoradoCityHashImpl.fetch64(byArray, n + 40);
            l5 = DoradoCityHashImpl.rotate(l5 + lArray2[0], 33) * -5435081209227447693L;
            lArray = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + 0, lArray[1] * -5435081209227447693L, (l3 ^= lArray2[1]) + lArray2[0]);
            lArray2 = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + 32, l5 + lArray2[1], l4 + DoradoCityHashImpl.fetch64(byArray, n + 16));
            long l6 = l5;
            l5 = l3;
            l3 = l6;
            l3 = DoradoCityHashImpl.rotate(l3 + l4 + lArray[0] + DoradoCityHashImpl.fetch64(byArray, (n += 64) + 8), 37) * -5435081209227447693L;
            l4 = DoradoCityHashImpl.rotate(l4 + lArray[1] + DoradoCityHashImpl.fetch64(byArray, n + 48), 42) * -5435081209227447693L;
            l4 += lArray[0] + DoradoCityHashImpl.fetch64(byArray, n + 40);
            l5 = DoradoCityHashImpl.rotate(l5 + lArray2[0], 33) * -5435081209227447693L;
            lArray = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n, lArray[1] * -5435081209227447693L, (l3 ^= lArray2[1]) + lArray2[0]);
            lArray2 = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + 32, l5 + lArray2[1], l4 + DoradoCityHashImpl.fetch64(byArray, n + 16));
            l6 = l5;
            l5 = l3;
            l3 = l6;
            n += 64;
        } while ((n2 -= 128) >= 128);
        l3 += DoradoCityHashImpl.rotate(lArray[0] + l5, 49) * -4348849565147123417L;
        l5 += DoradoCityHashImpl.rotate(lArray2[0], 37) * -4348849565147123417L;
        int n3 = 0;
        while (n3 < n2) {
            l4 = DoradoCityHashImpl.rotate(l3 + l4, 42) * -4348849565147123417L + lArray[1];
            lArray2[0] = lArray2[0] + DoradoCityHashImpl.fetch64(byArray, n + n2 - (n3 += 32) + 16);
            l3 = l3 * -4348849565147123417L + lArray2[0];
            lArray2[1] = lArray2[1] + lArray[0];
            lArray = DoradoCityHashImpl.weakHashLen32WithSeeds(byArray, n + n2 - n3, lArray[0] + (l5 += lArray2[1] + DoradoCityHashImpl.fetch64(byArray, n + n2 - n3)), lArray[1]);
        }
        l3 = DoradoCityHashImpl.hashLen16(l3, lArray[0]);
        l4 = DoradoCityHashImpl.hashLen16(l4 + l5, lArray2[0]);
        return new long[]{DoradoCityHashImpl.hashLen16(l3 + lArray[1], lArray2[1]) + l4, DoradoCityHashImpl.hashLen16(l3 + lArray2[1], l4 + lArray[1])};
    }

    public static long[] cityHash128(byte[] byArray, int n, int n2) {
        if (n2 >= 16) {
            return DoradoCityHashImpl.cityHash128WithSeed(byArray, n + 16, n2 - 16, DoradoCityHashImpl.fetch64(byArray, n + 0) ^ 0xC949D7C7509E6557L, DoradoCityHashImpl.fetch64(byArray, n + 8));
        }
        if (n2 >= 8) {
            return DoradoCityHashImpl.cityHash128WithSeed(new byte[0], 0, 0, DoradoCityHashImpl.fetch64(byArray, n + 0) ^ (long)n2 * -4348849565147123417L, DoradoCityHashImpl.fetch64(byArray, n + n2 - 8) ^ 0xB492B66FBE98F273L);
        }
        return DoradoCityHashImpl.cityHash128WithSeed(byArray, n, n2, -4348849565147123417L, -5435081209227447693L);
    }

    public static BigInteger numHash64(BigInteger bigInteger) {
        bigInteger = bigInteger.xor(bigInteger.shiftRight(33));
        bigInteger = bigInteger.multiply(new BigInteger("18397679294719823053"));
        bigInteger = bigInteger.xor(bigInteger.shiftRight(33));
        bigInteger = bigInteger.multiply(new BigInteger("14181476777654086739"));
        bigInteger = bigInteger.xor(bigInteger.shiftRight(33));
        return bigInteger;
    }
}

