/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons;

import com.bytedance.bytehouse.commons.ChainingOps$;
import com.bytedance.bytehouse.commons.ConnectionUtils;
import com.bytedance.bytehouse.commons.RetryUtils;
import com.bytedance.bytehouse.commons.RetryUtils$Timeout$;
import com.bytedance.bytehouse.commons.SystemUtils$;
import com.bytedance.bytehouse.commons.Using$;
import com.bytedance.bytehouse.commons.Using$Releasable$AutoCloseableIsReleasable$;
import com.bytedance.bytehouse.commons.net.NetAddress$;
import com.bytedance.bytehouse.commons.net.NetAddressLike;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Try$;

public final class ConnectionUtils$ {
    public static ConnectionUtils$ MODULE$;
    private transient Logger com$bytedance$bytehouse$commons$ConnectionUtils$$log;
    private Function1<Object, String> setPingCount;
    private Function1<RetryUtils.Timeout, String> setPingTimeout;
    private final Seq<Object> DefaultConnectionTestPorts;
    private final RetryUtils.FiniteAttempt com$bytedance$bytehouse$commons$ConnectionUtils$$defaultAttemptQuota;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    static {
        new ConnectionUtils$();
    }

    private Logger log$lzycompute() {
        ConnectionUtils$ connectionUtils$ = this;
        synchronized (connectionUtils$) {
            if (!this.bitmap$trans$0) {
                this.com$bytedance$bytehouse$commons$ConnectionUtils$$log = LogManager.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.com$bytedance$bytehouse$commons$ConnectionUtils$$log;
    }

    public Logger com$bytedance$bytehouse$commons$ConnectionUtils$$log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.com$bytedance$bytehouse$commons$ConnectionUtils$$log;
    }

    public final Seq<Object> DefaultConnectionTestPorts() {
        return this.DefaultConnectionTestPorts;
    }

    public boolean isPingableByCommand(String host, Duration timeout) {
        return BoxesRunTime.unboxToBoolean(ChainingOps$.MODULE$.pipe$extension(ChainingOps$.MODULE$.scalaUtilChainingOps((Object[])new String[]{this.pingCommandFor(host), (String)this.setPingCount().apply((Object)BoxesRunTime.boxToInteger((int)1)), (String)this.setPingTimeout().apply((Object)new RetryUtils.Timeout(timeout)), host}), (Function1 & Serializable & scala.Serializable)cmdArray -> BoxesRunTime.boxToBoolean((boolean)ConnectionUtils$.$anonfun$isPingableByCommand$1(cmdArray))));
    }

    private String pingCommandFor(String host) {
        if (NetAddress$.MODULE$.isValidIpv6(host)) {
            return "ping6";
        }
        return "ping";
    }

    private Function1<Object, String> setPingCount$lzycompute() {
        ConnectionUtils$ connectionUtils$ = this;
        synchronized (connectionUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                if (SystemUtils$.MODULE$.isLinux() || SystemUtils$.MODULE$.isMac()) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$3 -> ConnectionUtils$.$anonfun$setPingCount$1(BoxesRunTime.unboxToInt((Object)x$3));
                } else if (SystemUtils$.MODULE$.isWindows()) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$4 -> ConnectionUtils$.$anonfun$setPingCount$2(BoxesRunTime.unboxToInt((Object)x$4));
                } else {
                    throw new IllegalStateException(new StringBuilder(21).append("Unsupported OS type: ").append(SystemUtils$.MODULE$.osName()).toString());
                }
                this.setPingCount = intersect;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.setPingCount;
    }

    private Function1<Object, String> setPingCount() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.setPingCount$lzycompute();
        }
        return this.setPingCount;
    }

    private Function1<RetryUtils.Timeout, String> setPingTimeout$lzycompute() {
        ConnectionUtils$ connectionUtils$ = this;
        synchronized (connectionUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                if (SystemUtils$.MODULE$.isLinux()) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$5 -> ConnectionUtils$.$anonfun$setPingTimeout$1(((RetryUtils.Timeout)x$5).value());
                } else if (SystemUtils$.MODULE$.isMac()) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$6 -> ConnectionUtils$.$anonfun$setPingTimeout$2(((RetryUtils.Timeout)x$6).value());
                } else if (SystemUtils$.MODULE$.isWindows()) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$7 -> ConnectionUtils$.$anonfun$setPingTimeout$3(((RetryUtils.Timeout)x$7).value());
                } else {
                    throw new IllegalStateException(new StringBuilder(21).append("Unsupported OS type: ").append(SystemUtils$.MODULE$.osName()).toString());
                }
                this.setPingTimeout = intersect;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.setPingTimeout;
    }

    private Function1<RetryUtils.Timeout, String> setPingTimeout() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.setPingTimeout$lzycompute();
        }
        return this.setPingTimeout;
    }

    public boolean isPingableByTcp(String host, int port, Duration timeout) {
        return this.isPingableByTcp(host, port < 0 ? this.DefaultConnectionTestPorts() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{port})), timeout);
    }

    public boolean isPingableByTcp(String host, Seq<Object> portCandidates, Duration timeout) {
        return BoxesRunTime.unboxToBoolean(Using$.MODULE$.resource(new Socket(), (Function1 & Serializable & scala.Serializable)socket -> BoxesRunTime.boxToBoolean((boolean)this.attempt$1(portCandidates, ConnectionUtils$.attempt$default$2$1(), socket, host, timeout)), Using$Releasable$AutoCloseableIsReleasable$.MODULE$));
    }

    public boolean isPingable(String host, Duration timeout) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> InetAddress.getByName(host).isReachable(RetryUtils$Timeout$.MODULE$.toMillisInt$extension(timeout))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public ConnectionUtils.UriOps UriOps(URI uri) {
        return new ConnectionUtils.UriOps(uri);
    }

    public ConnectionUtils.UrlOps UrlOps(URL url) {
        return new ConnectionUtils.UrlOps(url);
    }

    public ConnectionUtils.NetAddressOps NetAddressOps(NetAddressLike addr) {
        return new ConnectionUtils.NetAddressOps(addr);
    }

    public RetryUtils.FiniteAttempt com$bytedance$bytehouse$commons$ConnectionUtils$$defaultAttemptQuota() {
        return this.com$bytedance$bytehouse$commons$ConnectionUtils$$defaultAttemptQuota;
    }

    public static final /* synthetic */ boolean $anonfun$isPingableByCommand$1(String[] cmdArray) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.runtime().exec(cmdArray)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.waitFor())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == 0).isSuccess();
    }

    public static final /* synthetic */ String $anonfun$setPingCount$1(int x$3) {
        return new StringBuilder(3).append("-c ").append(x$3).toString();
    }

    public static final /* synthetic */ String $anonfun$setPingCount$2(int x$4) {
        return new StringBuilder(3).append("-n ").append(x$4).toString();
    }

    public static final /* synthetic */ String $anonfun$setPingTimeout$1(Duration x$5) {
        return new StringBuilder(3).append("-W ").append(RetryUtils$Timeout$.MODULE$.ceilToSecondsInt$extension(x$5)).toString();
    }

    public static final /* synthetic */ String $anonfun$setPingTimeout$2(Duration x$6) {
        return new StringBuilder(2).append("-t").append(RetryUtils$Timeout$.MODULE$.ceilToSecondsInt$extension(x$6)).toString();
    }

    public static final /* synthetic */ String $anonfun$setPingTimeout$3(Duration x$7) {
        return new StringBuilder(3).append("-w ").append(RetryUtils$Timeout$.MODULE$.toMillis$extension(x$7)).toString();
    }

    private final boolean attempt$1(Seq ports, boolean lastResult, Socket socket$1, String host$1, Duration timeout$1) {
        while (!lastResult && !ports.isEmpty()) {
            boolean currentResult;
            lastResult = currentResult = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> socket$1.connect(new InetSocketAddress(host$1, BoxesRunTime.unboxToInt((Object)ports.head())), RetryUtils$Timeout$.MODULE$.toMillisInt$extension(timeout$1))).isSuccess();
            ports = (Seq)ports.tail();
        }
        return lastResult;
    }

    private static final boolean attempt$default$2$1() {
        return false;
    }

    private ConnectionUtils$() {
        MODULE$ = this;
        this.DefaultConnectionTestPorts = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{23, 443, 80}));
        this.com$bytedance$bytehouse$commons$ConnectionUtils$$defaultAttemptQuota = new RetryUtils.FiniteAttempt(3);
    }
}

