/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons;

import com.bytedance.bytehouse.commons.ExecutionTimeProfiler$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import shaded.bytehouse.com.google.common.base.Stopwatch;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0010!\u0005&B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\t\r\u0002\u0011\t\u0012)A\u0005q!)q\t\u0001C\u0001\u0011\"9A\n\u0001b\u0001\n\u0013i\u0005B\u00020\u0001A\u0003%a\nC\u0004`\u0001\t\u0007I\u0011\u00021\t\r-\u0004\u0001\u0015!\u0003b\u0011!a\u0007\u0001#b\u0001\n\u0013i\u0007\"B:\u0001\t\u0003!\b\"B-\u0001\t\u0003A\bbBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011%\t9\u0003AA\u0001\n\u0003\tI\u0003C\u0005\u0002.\u0001\t\n\u0011\"\u0001\u00020!A\u0011Q\t\u0001\u0002\u0002\u0013\u0005S\u000eC\u0005\u0002H\u0001\t\t\u0011\"\u0001\u0002J!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00033\u0002\u0011\u0011!C!\u00037B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u000f%\tY\bIA\u0001\u0012\u0003\tiH\u0002\u0005 A\u0005\u0005\t\u0012AA@\u0011\u00199u\u0003\"\u0001\u0002\u000e\"I\u00111D\f\u0002\u0002\u0013\u0015\u0013q\u0012\u0005\n\u0003#;\u0012\u0011!CA\u0003'C\u0011\"a&\u0018#\u0003%\t!a\f\t\u0013\u0005eu#!A\u0005\u0002\u0006m\u0005\"CAR/E\u0005I\u0011AA\u0018\u0011%\t)kFA\u0001\n\u0013\t9KA\u000bFq\u0016\u001cW\u000f^5p]RKW.\u001a)s_\u001aLG.\u001a:\u000b\u0005\u0005\u0012\u0013aB2p[6|gn\u001d\u0006\u0003G\u0011\n\u0011BY=uK\"|Wo]3\u000b\u0005\u00152\u0013!\u00032zi\u0016$\u0017M\\2f\u0015\u00059\u0013aA2p[\u000e\u00011\u0003\u0002\u0001+aM\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00162\u0013\t\u0011DFA\u0004Qe>$Wo\u0019;\u0011\u0005-\"\u0014BA\u001b-\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!!\u0018\u000e\u001e7f\u001fB$X#\u0001\u001d\u0011\u0007-J4(\u0003\u0002;Y\t1q\n\u001d;j_:\u0004\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 -\u001b\u0005y$B\u0001!)\u0003\u0019a$o\\8u}%\u0011!\tL\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002CY\u0005IA/\u001b;mK>\u0003H\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%[\u0005C\u0001&\u0001\u001b\u0005\u0001\u0003b\u0002\u001c\u0004!\u0003\u0005\r\u0001O\u0001\t[\u0016\f7/\u001e:fgV\ta\n\u0005\u0003P)n2V\"\u0001)\u000b\u0005E\u0013\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003'2\n!bY8mY\u0016\u001cG/[8o\u0013\t)\u0006KA\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bA\u0001^5nK*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005!!UO]1uS>t\u0017!C7fCN,(/Z:!\u0003%\u0019Ho\u001c9xCR\u001c\u0007.F\u0001b!\t\u0011\u0017.D\u0001d\u0015\r!\u0017\u0011X\u0001\u0005E\u0006\u001cXMC\u0002g\u0003\u0003\faaY8n[>t'b\u00015\u0002H\u00061qm\\8hY\u0016L!A[2\u0003\u0013M#x\u000e]<bi\u000eD\u0017AC:u_B<\u0018\r^2iA\u0005)A/\u001b;mKV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002r5\u0006!A.\u00198h\u0013\t!\u0005/A\tu_R\fG\u000eV5nS:<W*\u001b7mSN,\u0012!\u001e\t\u0003WYL!a\u001e\u0017\u0003\t1{gnZ\u000b\u0003sv$2A_A\f)\rY\u0018Q\u0002\t\u0003yvd\u0001\u0001B\u0003\u007f\u0015\t\u0007qPA\u0001U#\u0011\t\t!a\u0002\u0011\u0007-\n\u0019!C\u0002\u0002\u00061\u0012qAT8uQ&tw\rE\u0002,\u0003\u0013I1!a\u0003-\u0005\r\te.\u001f\u0005\t\u0003\u001fQA\u00111\u0001\u0002\u0012\u0005\u0011q\u000e\u001d\t\u0005W\u0005M10C\u0002\u0002\u00161\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0007\u00033Q\u0001\u0019A\u001e\u0002\u0011Q,7\u000f\u001e(b[\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002w\u0005AQ.\u001b7mSN|e\r\u0006\u0003\u0002$\u0005\u0015\u0002cA\u0016:k\"1\u0011\u0011\u0004\u0007A\u0002m\nAaY8qsR\u0019\u0011*a\u000b\t\u000fYj\u0001\u0013!a\u0001q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0019U\rA\u00141G\u0016\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0005v]\u000eDWmY6fI*\u0019\u0011q\b\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005e\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0013\u0011\u0007-\ni%C\u0002\u0002P1\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0002\u0002V!I\u0011qK\t\u0002\u0002\u0003\u0007\u00111J\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0003CBA0\u0003C\n9!D\u0001S\u0013\r\t\u0019G\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002j\u0005=\u0004cA\u0016\u0002l%\u0019\u0011Q\u000e\u0017\u0003\u000f\t{w\u000e\\3b]\"I\u0011qK\n\u0002\u0002\u0003\u0007\u0011qA\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111J\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u0014\u0011\u0010\u0005\n\u0003/*\u0012\u0011!a\u0001\u0003\u000f\tQ#\u0012=fGV$\u0018n\u001c8US6,\u0007K]8gS2,'\u000f\u0005\u0002K/M!q#!!4!\u0019\t\u0019)!#9\u00136\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fc\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\u000b)IA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!! \u0015\u00039\fQ!\u00199qYf$2!SAK\u0011\u001d1$\u0004%AA\u0002a\nq\"\u00199qYf$C-\u001a4bk2$H%M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti*a(\u0011\u0007-J\u0004\b\u0003\u0005\u0002\"r\t\t\u00111\u0001J\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003S\u00032a\\AV\u0013\r\ti\u000b\u001d\u0002\u0007\u001f\nTWm\u0019;\u0002\rMD\u0017\rZ3e\u0015\t\tyKC\u0002$\u0003cS1aJAZ\u0015\rA\u0017Q\u0017\u0006\u0004M\u0006]&BAAX\u0015\r\u0019\u00131\u0018\u0006\u0004O\u0005u&b\u00015\u0002@*\u0011\u0011q\u0016\u0006\u0004G\u0005\r'bA\u0014\u0002F\u0002")
public final class ExecutionTimeProfiler
implements Product,
scala.Serializable {
    private String title;
    private final Option<String> titleOpt;
    private final LinkedHashMap<String, Duration> measures;
    private final Stopwatch stopwatch;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$1() {
        return ExecutionTimeProfiler$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<String>> unapply(ExecutionTimeProfiler executionTimeProfiler) {
        return ExecutionTimeProfiler$.MODULE$.unapply(executionTimeProfiler);
    }

    public static Option<String> apply$default$1() {
        return ExecutionTimeProfiler$.MODULE$.apply$default$1();
    }

    public static ExecutionTimeProfiler apply(Option<String> option) {
        return ExecutionTimeProfiler$.MODULE$.apply(option);
    }

    public static <A> Function1<Option<String>, A> andThen(Function1<ExecutionTimeProfiler, A> function1) {
        return ExecutionTimeProfiler$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ExecutionTimeProfiler> compose(Function1<A, Option<String>> function1) {
        return ExecutionTimeProfiler$.MODULE$.compose(function1);
    }

    public Option<String> titleOpt() {
        return this.titleOpt;
    }

    private LinkedHashMap<String, Duration> measures() {
        return this.measures;
    }

    private Stopwatch stopwatch() {
        return this.stopwatch;
    }

    private String title$lzycompute() {
        ExecutionTimeProfiler executionTimeProfiler = this;
        synchronized (executionTimeProfiler) {
            if (!this.bitmap$0) {
                this.title = (String)this.titleOpt().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(2).append((String)x$1).append(": ").toString());
                this.bitmap$0 = true;
            }
        }
        return this.title;
    }

    private String title() {
        if (!this.bitmap$0) {
            return this.title$lzycompute();
        }
        return this.title;
    }

    public long totalTimingMillis() {
        long l;
        LinkedHashMap<String, Duration> linkedHashMap = this.measures();
        synchronized (linkedHashMap) {
            l = ((Duration)this.measures().values().reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.plus((Duration)x$3))).toMillis();
        }
        return l;
    }

    public <T> T time(String testName, Function0<T> op2) {
        Object object;
        LinkedHashMap<String, Duration> linkedHashMap = this.measures();
        synchronized (linkedHashMap) {
            this.stopwatch().reset();
            this.stopwatch().start();
            Object result = op2.apply();
            this.stopwatch().stop();
            this.measures().put((Object)testName, (Object)this.stopwatch().elapsed());
            object = result;
        }
        return (T)object;
    }

    public String toString() {
        String string;
        LinkedHashMap<String, Duration> linkedHashMap = this.measures();
        synchronized (linkedHashMap) {
            long totalMillis = Math.max(1L, this.totalTimingMillis());
            Iterable details = (Iterable)this.measures().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Duration duration = (Duration)tuple2._2();
                    long durationMillis = duration.toMillis();
                    double percent = (double)durationMillis / (double)totalMillis * (double)100;
                    String arg$macro$1 = name;
                    Long arg$macro$2 = BoxesRunTime.boxToLong((long)durationMillis);
                    double arg$macro$3 = percent;
                    return new StringOps("[%s] %s ms (%.2f%%)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToDouble((double)arg$macro$3)}));
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom());
            this.measures().clear();
            string = new StringBuilder(5).append(this.title()).append(totalMillis).append(" ms, ").append(details.mkString(", ")).toString();
        }
        return string;
    }

    public Option<Object> millisOf(String testName) {
        return this.measures().get((Object)testName).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.toMillis()));
    }

    public ExecutionTimeProfiler copy(Option<String> titleOpt) {
        return new ExecutionTimeProfiler(titleOpt);
    }

    public Option<String> copy$default$1() {
        return this.titleOpt();
    }

    public String productPrefix() {
        return "ExecutionTimeProfiler";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.titleOpt();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ExecutionTimeProfiler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ExecutionTimeProfiler)) return false;
        boolean bl = true;
        if (!bl) return false;
        ExecutionTimeProfiler executionTimeProfiler = (ExecutionTimeProfiler)x$1;
        Option<String> option = this.titleOpt();
        Option<String> option2 = executionTimeProfiler.titleOpt();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public ExecutionTimeProfiler(Option<String> titleOpt) {
        this.titleOpt = titleOpt;
        Product.$init$((Product)this);
        this.measures = new LinkedHashMap();
        this.stopwatch = Stopwatch.createUnstarted();
    }
}

