/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class TemporalUtils$ {
    public static TemporalUtils$ MODULE$;
    private final Seq<DateTimeFormatter> dateFormatters;
    private final Seq<DateTimeFormatter> timeFormatters;
    private final Seq<DateTimeFormatter> datetimeFormatters;

    static {
        new TemporalUtils$();
    }

    public LocalDate parseDate(CharSequence s2) {
        return (LocalDate)this.parseTemporalString(s2, (Traversable<DateTimeFormatter>)this.dateFormatters(), (Function2)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> LocalDate.parse(x$1, x$2));
    }

    private Seq<DateTimeFormatter> dateFormatters() {
        return this.dateFormatters;
    }

    public LocalTime parseTime(CharSequence s2) {
        return (LocalTime)this.parseTemporalString(s2, (Traversable<DateTimeFormatter>)this.timeFormatters(), (Function2)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> LocalTime.parse(x$1, x$2));
    }

    private Seq<DateTimeFormatter> timeFormatters() {
        return this.timeFormatters;
    }

    public LocalDateTime parseDateTime(CharSequence s2) {
        return (LocalDateTime)this.parseTemporalString(s2, (Traversable<DateTimeFormatter>)this.datetimeFormatters(), (Function2)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> LocalDateTime.parse(x$1, x$2));
    }

    private Seq<DateTimeFormatter> datetimeFormatters() {
        return this.datetimeFormatters;
    }

    private <T extends Temporal> T parseTemporalString(CharSequence s2, Traversable<DateTimeFormatter> formatters, Function2<CharSequence, DateTimeFormatter, T> f) {
        Predef$.MODULE$.require(formatters.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "At least one temporal formatter should be provided");
        Iterator it = formatters.toIterator();
        return (T)this.attempt$1(it, f, s2);
    }

    private final Temporal attempt$1(Iterator it$1, Function2 f$1, CharSequence s$1) {
        while (it$1.hasNext()) {
            Temporal temporal;
            try {
                temporal = (Temporal)f$1.apply((Object)s$1, it$1.next());
            }
            catch (DateTimeParseException dateTimeParseException) {
                continue;
            }
            return temporal;
        }
        throw new DateTimeParseException(new StringBuilder(33).append("Failed to parse temporal string: ").append(s$1).toString(), s$1, 0);
    }

    private TemporalUtils$() {
        MODULE$ = this;
        this.dateFormatters = (Seq)((TraversableLike)new .colon.colon((Object)DateTimeFormatter.ISO_DATE, (List)new .colon.colon((Object)DateTimeFormatter.BASIC_ISO_DATE, (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)((TraversableLike)new .colon.colon((Object)"dd/MM/yyyy", (List)new .colon.colon((Object)"dd-MM-yyyy", (List)new .colon.colon((Object)"MMM dd, yyyy", (List)new .colon.colon((Object)"MMMM dd, yyyy", (List)new .colon.colon((Object)"dd MMM, yyyy", (List)new .colon.colon((Object)"dd MMMM, yyyy", (List)Nil$.MODULE$))))))).map((Function1 & Serializable & scala.Serializable)x$1 -> DateTimeFormatter.ofPattern(x$1), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.timeFormatters = (Seq)((TraversableLike)new .colon.colon((Object)DateTimeFormatter.ISO_TIME, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)((TraversableLike)new .colon.colon((Object)"HH:mm", (List)new .colon.colon((Object)"h:mm a", (List)new .colon.colon((Object)"h:mm:ss a", (List)new .colon.colon((Object)"HHmm", (List)new .colon.colon((Object)"HHmmss", (List)new .colon.colon((Object)"HH:mm:ss.SSS", (List)new .colon.colon((Object)"h:mm:ss.SSS a", (List)Nil$.MODULE$)))))))).map((Function1 & Serializable & scala.Serializable)x$1 -> DateTimeFormatter.ofPattern(x$1), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.datetimeFormatters = (Seq)new .colon.colon((Object)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), (List)new .colon.colon((Object)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"), (List)new .colon.colon((Object)DateTimeFormatter.ISO_DATE_TIME, (List)new .colon.colon((Object)DateTimeFormatter.ISO_INSTANT, (List)new .colon.colon((Object)DateTimeFormatter.RFC_1123_DATE_TIME, (List)Nil$.MODULE$)))));
    }
}

