/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.commons.net;

import com.bytedance.bytehouse.commons.net.NetAddress;
import java.net.URI;
import java.net.URL;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class NetAddress$
implements Serializable {
    public static NetAddress$ MODULE$;
    private Regex UrlPattern;
    private Regex HostnamePattern;
    private Regex HostnameWithPortPattern;
    private Regex Ipv4LikePattern;
    private Regex Ipv4Pattern;
    private Regex Ipv4WithPortPattern;
    private Regex Ipv6Pattern;
    private final Regex Ipv6WithPortPattern;
    private volatile byte bitmap$0;

    static {
        new NetAddress$();
    }

    public NetAddress apply(String host, String port) {
        return new NetAddress(host, new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
    }

    public NetAddress fromUri(URI uri) {
        return new NetAddress(uri.getHost(), uri.getPort());
    }

    public NetAddress fromUrl(URL url) {
        return new NetAddress(url.getHost(), url.getPort());
    }

    public Function1<String, NetAddress> fromString() {
        return (Function1 & java.io.Serializable & Serializable)x0$1 -> {
            String string = x0$1;
            Option option = MODULE$.UrlPattern().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String url = (String)((LinearSeqOptimized)option.get()).apply(0);
                return MODULE$.fromUrl(new URL(url));
            }
            Option option2 = MODULE$.Ipv4WithPortPattern().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String host = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String port = (String)((LinearSeqOptimized)option2.get()).apply(1);
                return MODULE$.apply(host, port);
            }
            Option option3 = MODULE$.Ipv6WithPortPattern().unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                String host = (String)((LinearSeqOptimized)option3.get()).apply(0);
                String port = (String)((LinearSeqOptimized)option3.get()).apply(1);
                return MODULE$.apply(host, port);
            }
            Option option4 = MODULE$.HostnameWithPortPattern().unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(2) == 0) {
                String host = (String)((LinearSeqOptimized)option4.get()).apply(0);
                String port = (String)((LinearSeqOptimized)option4.get()).apply(1);
                String string2 = host;
                Option option5 = MODULE$.Ipv4LikePattern().unapplySeq((CharSequence)string2);
                if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0) {
                    String ipv4Like;
                    String string3 = ipv4Like = (String)((LinearSeqOptimized)option5.get()).apply(0);
                    Option option6 = MODULE$.Ipv4Pattern().unapplySeq((CharSequence)string3);
                    if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0) {
                        String ipv4 = (String)((LinearSeqOptimized)option6.get()).apply(0);
                        return MODULE$.apply(ipv4, port);
                    }
                    throw new IllegalArgumentException(new StringBuilder(22).append("Invalid IPv4 address: ").append(string3).toString());
                }
                return MODULE$.apply(string2, port);
            }
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid net address string: ").append(string).toString());
        };
    }

    public boolean isValidIpv6(CharSequence x) {
        return this.Ipv6Pattern().pattern().matcher(x).matches();
    }

    private Regex UrlPattern$lzycompute() {
        NetAddress$ netAddress$ = this;
        synchronized (netAddress$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.UrlPattern = new StringOps(Predef$.MODULE$.augmentString("((?i)(?:https?|ftp)://\\S+)")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.UrlPattern;
    }

    public final Regex UrlPattern() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.UrlPattern$lzycompute();
        }
        return this.UrlPattern;
    }

    private Regex HostnamePattern$lzycompute() {
        NetAddress$ netAddress$ = this;
        synchronized (netAddress$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.HostnamePattern = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z0-9.-]+)")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.HostnamePattern;
    }

    public final Regex HostnamePattern() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.HostnamePattern$lzycompute();
        }
        return this.HostnamePattern;
    }

    private Regex HostnameWithPortPattern$lzycompute() {
        NetAddress$ netAddress$ = this;
        synchronized (netAddress$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.HostnameWithPortPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(6).append(this.HostnamePattern().regex()).append(":(\\d+)").toString())).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.HostnameWithPortPattern;
    }

    public final Regex HostnameWithPortPattern() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.HostnameWithPortPattern$lzycompute();
        }
        return this.HostnameWithPortPattern;
    }

    private Regex Ipv4LikePattern$lzycompute() {
        NetAddress$ netAddress$ = this;
        synchronized (netAddress$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.Ipv4LikePattern = this.ipv4Pattern("\\d+");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.Ipv4LikePattern;
    }

    public final Regex Ipv4LikePattern() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.Ipv4LikePattern$lzycompute();
        }
        return this.Ipv4LikePattern;
    }

    private Regex Ipv4Pattern$lzycompute() {
        NetAddress$ netAddress$ = this;
        synchronized (netAddress$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.Ipv4Pattern = this.ipv4Pattern("(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.Ipv4Pattern;
    }

    public final Regex Ipv4Pattern() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.Ipv4Pattern$lzycompute();
        }
        return this.Ipv4Pattern;
    }

    private Regex Ipv4WithPortPattern$lzycompute() {
        NetAddress$ netAddress$ = this;
        synchronized (netAddress$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.Ipv4WithPortPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(6).append(this.Ipv4Pattern().regex()).append(":(\\d+)").toString())).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.Ipv4WithPortPattern;
    }

    public final Regex Ipv4WithPortPattern() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.Ipv4WithPortPattern$lzycompute();
        }
        return this.Ipv4WithPortPattern;
    }

    private Regex ipv4Pattern(String segmentRegex) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(11).append("(").append(segmentRegex).append("(?:\\.").append(segmentRegex).append("){3})").toString())).r();
    }

    private Regex Ipv6Pattern$lzycompute() {
        NetAddress$ netAddress$ = this;
        synchronized (netAddress$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                String v6Field = "[0-9A-Fa-f]{1,4}";
                String v4Address = this.Ipv4Pattern().regex().replaceFirst("\\(", "(?:");
                this.Ipv6Pattern = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(408).append("(\n       |(?:(?:").append(v6Field).append(":){7}(?:").append(v6Field).append("|:))|\n       |(?:(?:").append(v6Field).append(":){6}(?::").append(v6Field).append("|").append(v4Address).append("|:))|\n       |(?:(?:").append(v6Field).append(":){5}(?:(?:(?::").append(v6Field).append("){1,2})|:").append(v4Address).append("|:))|\n       |(?:(?:").append(v6Field).append(":){4}(?:(?:(?::").append(v6Field).append("){1,3})|(?:(?::").append(v6Field).append(")?:").append(v4Address).append(")|:))|\n       |(?:(?:").append(v6Field).append(":){3}(?:(?:(?::").append(v6Field).append("){1,4})|(?:(?::").append(v6Field).append("){0,2}:").append(v4Address).append(")|:))|\n       |(?:(?:").append(v6Field).append(":){2}(?:(?:(?::").append(v6Field).append("){1,5})|(?:(?::").append(v6Field).append("){0,3}:").append(v4Address).append(")|:))|\n       |(?:(?:").append(v6Field).append(":){1}(?:(?:(?::").append(v6Field).append("){1,6})|(?:(?::").append(v6Field).append("){0,4}:").append(v4Address).append(")|:))|\n       |(?::(?:(?:(?::").append(v6Field).append("){1,7})|(?:(?::").append(v6Field).append("){0,5}:").append(v4Address).append(")|:))\n       |)(?:%.+)?\n       |").toString())).stripMargin().replaceAll("\\n", ""))).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.Ipv6Pattern;
    }

    public final Regex Ipv6Pattern() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.Ipv6Pattern$lzycompute();
        }
        return this.Ipv6Pattern;
    }

    public final Regex Ipv6WithPortPattern() {
        return this.Ipv6WithPortPattern;
    }

    public NetAddress apply(String host, int port) {
        return new NetAddress(host, port);
    }

    public Option<Tuple2<String, Object>> unapply(NetAddress x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NetAddress$() {
        MODULE$ = this;
        this.Ipv6WithPortPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(10).append("\\[").append(this.Ipv6Pattern().regex()).append("\\]:(\\d+)").toString())).r();
    }
}

