/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.examples;

import com.bytedance.bytehouse.CityHash;
import com.bytedance.bytehouse.DtsPartition;
import com.bytedance.bytehouse.IntHash;
import com.bytedance.bytehouse.PythonPartition;
import com.bytedance.bytehouse.SparkPartition;
import com.bytedance.bytehouse.XxHash;

public class Main {
    public static void testCityHash64(String[] args) {
        long hash2 = CityHash.cityHash64(args[0], Long.parseLong(args[1]));
        System.out.println("CityHash64: 0x" + Long.toHexString(hash2));
    }

    public static void testIntHash64(String[] args) {
        long hash2 = IntHash.intHash64(args[0]);
        System.out.println("IntHash64: 0x" + Long.toHexString(hash2));
    }

    public static void testSparkPartition() {
        System.out.println("-- Test sparkpartition");
        System.out.println("-- 0-4");
        System.out.println(SparkPartition.sparkpartition("abc", 400L));
        System.out.println(SparkPartition.sparkpartition("111", 400L));
        System.out.println(SparkPartition.sparkpartition("-111", 400L));
        System.out.println("-- 5-7");
        System.out.println(SparkPartition.sparkpartition("abcabc", 400L));
        System.out.println("-- 8-16");
        System.out.println(SparkPartition.sparkpartition("abcabcabc", 400L));
        System.out.println(SparkPartition.sparkpartition("e43970221139c", 400L));
        System.out.println("-- 17-32");
        System.out.println(SparkPartition.sparkpartition("abcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- 33-64");
        System.out.println(SparkPartition.sparkpartition("abcabcabcabcabcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- 64+");
        System.out.println(SparkPartition.sparkpartition("abcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- CN");
        System.out.println(SparkPartition.sparkpartition("\u4e2d\u56fd\u4eba", 400L));
        System.out.println(SparkPartition.sparkpartition("\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba", 400L));
        System.out.println("-- Int");
        System.out.println(SparkPartition.sparkpartition(111L, 400L));
        System.out.println(SparkPartition.sparkpartition(-111L, 400L));
        System.out.println(SparkPartition.sparkpartition(0x100000001L, 400L));
        System.out.println(SparkPartition.sparkpartition(-4294967297L, 400L));
        System.out.println("-- BigInt");
        System.out.println(SparkPartition.sparkpartition("340282366920938463463374607431768211457", 400L));
        System.out.println(SparkPartition.sparkpartition("-340282366920938463463374607431768211457", 400L));
    }

    public static void testDtsPartition() {
        System.out.println("-- Test dtspartition");
        System.out.println("-- 0-4");
        System.out.println(DtsPartition.dtspartition("abc", 400L));
        System.out.println(DtsPartition.dtspartition("111", 400L));
        System.out.println(DtsPartition.dtspartition("-111", 400L));
        System.out.println("-- 5-7");
        System.out.println(DtsPartition.dtspartition("abcabc", 400L));
        System.out.println("-- 8-16");
        System.out.println(DtsPartition.dtspartition("abcabcabc", 400L));
        System.out.println(DtsPartition.dtspartition("e43970221139c", 400L));
        System.out.println("-- 17-32");
        System.out.println(DtsPartition.dtspartition("abcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- 33-64");
        System.out.println(DtsPartition.dtspartition("abcabcabcabcabcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- 64+");
        System.out.println(DtsPartition.dtspartition("abcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- CN");
        System.out.println(DtsPartition.dtspartition("\u4e2d\u56fd\u4eba", 400L));
        System.out.println(DtsPartition.dtspartition("\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba", 400L));
        System.out.println("-- Int");
        System.out.println(DtsPartition.dtspartition(111L, 400L));
        System.out.println(DtsPartition.dtspartition(-111L, 400L));
        System.out.println(DtsPartition.dtspartition(0x100000001L, 400L));
        System.out.println(DtsPartition.dtspartition(-4294967297L, 400L));
        System.out.println("-- BigInt");
        System.out.println(DtsPartition.dtspartition("340282366920938463463374607431768211457", 400L));
        System.out.println(DtsPartition.dtspartition("-340282366920938463463374607431768211457", 400L));
    }

    public static void testPythonPartition() {
        System.out.println("-- Test pythonpartition");
        System.out.println("-- 0-4");
        System.out.println(PythonPartition.pythonpartition("", 400L));
        System.out.println(PythonPartition.pythonpartition("abc", 400L));
        System.out.println(PythonPartition.pythonpartition("111", 400L));
        System.out.println(PythonPartition.pythonpartition("+111", 400L));
        System.out.println(PythonPartition.pythonpartition("-111", 400L));
        System.out.println("-- 5-7");
        System.out.println(PythonPartition.pythonpartition("abcabc", 400L));
        System.out.println("-- 8-16");
        System.out.println(PythonPartition.pythonpartition("abcabcabc", 400L));
        System.out.println(PythonPartition.pythonpartition("e43970221139c", 400L));
        System.out.println("-- 17-32");
        System.out.println(PythonPartition.pythonpartition("abcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- 33-64");
        System.out.println(PythonPartition.pythonpartition("abcabcabcabcabcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- 64+");
        System.out.println(PythonPartition.pythonpartition("abcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabcabc", 400L));
        System.out.println("-- CN");
        System.out.println(PythonPartition.pythonpartition("\u4e2d\u56fd\u4eba", 400L));
        System.out.println(PythonPartition.pythonpartition("\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba\u4e2d\u56fd\u4eba", 400L));
        System.out.println("-- Int");
        System.out.println(PythonPartition.pythonpartition(111L, 400L));
        System.out.println(PythonPartition.pythonpartition(-111L, 400L));
        System.out.println(PythonPartition.pythonpartition(0x100000001L, 400L));
        System.out.println(PythonPartition.pythonpartition(-4294967297L, 400L));
        System.out.println("-- BigInt");
        System.out.println(PythonPartition.pythonpartition("340282366920938463463374607431768211457", 400L));
        System.out.println(PythonPartition.pythonpartition("-340282366920938463463374607431768211457", 400L));
        System.out.println("-- Zhucheng");
        System.out.println(PythonPartition.pythonpartition("63434e277e7e7bf2d36478a096d4e9223c4217cf", 400L));
        System.out.println(PythonPartition.pythonpartition("136342249", 400L));
        System.out.println(PythonPartition.pythonpartition("2911897336", 400L));
    }

    public static void testXxHash64(String[] args) {
        long hash2 = XxHash.xxHash64(args[0], Long.parseLong(args[1]));
        System.out.println("xxHash64: 0x" + Long.toHexString(hash2));
        hash2 = XxHash.xxHash64V2(args[0], Long.parseLong(args[1]));
        System.out.println("xxHash64V2: 0x" + Long.toHexString(hash2));
        hash2 = XxHash.xxHash64(args[0], null);
        System.out.println("xxHash64 tail null: 0x" + Long.toHexString(hash2));
        hash2 = XxHash.xxHash64V2(args[0], null);
        System.out.println("xxHash64V2 tail null: 0x" + Long.toHexString(hash2));
        hash2 = XxHash.xxHash64(null, args[0]);
        System.out.println("xxHash64 first null: 0x" + Long.toHexString(hash2));
        hash2 = XxHash.xxHash64V2(null, args[0]);
        System.out.println("xxHash64V2 first null: 0x" + Long.toHexString(hash2));
    }

    public static void main(String[] args) {
        Main.testCityHash64(args);
        Main.testSparkPartition();
        Main.testDtsPartition();
        Main.testPythonPartition();
    }
}

