/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.flink.table.catalog;

import com.bytedance.bytehouse.ce.CeTableDdlInfo;
import com.bytedance.bytehouse.commons.PropsUtils;
import com.bytedance.bytehouse.flink.connector.clickhouse.ByteHouseCeClient;
import com.bytedance.bytehouse.flink.connector.clickhouse.ClickHouseConfig;
import com.bytedance.bytehouse.flink.connector.clickhouse.selection.ClickHouseShardingStrategy$HashSharding$;
import com.bytedance.bytehouse.flink.table.catalog.ClickHouseToFlinkTableDataTypeAdapter;
import com.bytedance.bytehouse.flink.table.catalog.factories.ClickhouseCatalogFactoryOptions;
import com.esotericsoftware.minlog.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.ListMap;

public class ClickhouseCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(ClickhouseCatalog.class);
    public static final String DEFAULT_DB = "default";
    private final ClickHouseConfig clickHouseConfig;
    private ByteHouseCeClient client;

    public ClickhouseCatalog(String string, String string2, ClickHouseConfig clickHouseConfig) {
        super(string, string2 == null ? DEFAULT_DB : string2);
        this.clickHouseConfig = clickHouseConfig;
    }

    public void open() throws CatalogException {
        if (this.client == null) {
            this.client = new ByteHouseCeClient(this.clickHouseConfig);
            LOG.info("Connected to clickhouse metastore, clickHouseConfig is {}", (Object)this.clickHouseConfig);
        }
    }

    public void close() throws CatalogException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            LOG.info("Close connection to clickhouse metastore");
        }
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            return (List)this.client.getAllDatabases();
        }
        catch (Exception exception) {
            throw new CatalogException(String.format("Failed to list all databases in %s", this.getName()), (Throwable)exception);
        }
    }

    public CatalogDatabase getDatabase(String string) throws DatabaseNotExistException, CatalogException {
        return this.getClickhouseDatabase(string);
    }

    public CatalogDatabase getClickhouseDatabase(String string) throws DatabaseNotExistException {
        Preconditions.checkState((!StringUtils.isNullOrWhitespaceOnly((String)string) ? 1 : 0) != 0, (Object)"Database name must not be blank.");
        if (this.listDatabases().contains(string)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), string);
    }

    public boolean databaseExists(String string) throws CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)string) ? 1 : 0) != 0);
        return this.listDatabases().contains(string);
    }

    public void createDatabase(String string, CatalogDatabase catalogDatabase, boolean bl) throws DatabaseAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(String string, boolean bl, boolean bl2) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String string, CatalogDatabase catalogDatabase, boolean bl) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listTables(String string) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkState((boolean)shaded.bytehouse.org.apache.commons.lang3.StringUtils.isNotBlank(string), (Object)"Database name must not be blank.");
        if (!this.databaseExists(string)) {
            throw new DatabaseNotExistException(this.getName(), string);
        }
        try {
            return (List)this.client.retrieveTableNames(string);
        }
        catch (Exception exception) {
            throw new CatalogException(String.format("Failed to list tables in database %s", string), (Throwable)exception);
        }
    }

    public List<String> listViews(String string) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogBaseTable getTable(ObjectPath objectPath) throws TableNotExistException, CatalogException {
        DataType dataType;
        Object object;
        String[] stringArray2;
        if (!this.tableExists(objectPath)) {
            throw new TableNotExistException(this.getName(), objectPath);
        }
        String string = objectPath.getDatabaseName();
        String string2 = objectPath.getObjectName();
        CeTableDdlInfo ceTableDdlInfo = this.client.getCachedTableDdlInfo(string, string2);
        List list = (List)this.client.retrieveUniqueKey(string, string2);
        ListMap<String, String> listMap = this.client.retrieveTableSchema(string, this.getSchemaTableName(objectPath));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<DataType> arrayList2 = new ArrayList<DataType>();
        for (String[] stringArray2 : listMap) {
            arrayList.add(stringArray2._1);
            object = (String)stringArray2._2;
            dataType = ClickHouseToFlinkTableDataTypeAdapter.adapt((String)object);
            if (list.contains(stringArray2._1)) {
                dataType = (DataType)dataType.notNull();
            }
            arrayList2.add(dataType);
            LOG.info("{} -> {}", stringArray2._1, stringArray2._2);
        }
        stringArray2 = arrayList.toArray(new String[0]);
        object = arrayList2.toArray(new DataType[0]);
        dataType = Schema.newBuilder().fromFields(stringArray2, (AbstractDataType[])object);
        if (!list.isEmpty()) {
            dataType.primaryKey(new String[]{String.join((CharSequence)",", list)});
        }
        Schema schema = dataType.build();
        Map<String, String> map = this.buildTableSinkProperties(string, objectPath, ceTableDdlInfo);
        LOG.info("table sink properties: {}, ddlInfo distributed is {}, local is {}", map.keySet(), ceTableDdlInfo.distributedDdl(), ceTableDdlInfo.localDdl());
        return CatalogTable.of((Schema)schema, (String)"", Collections.emptyList(), map);
    }

    private Map<String, String> buildTableSinkProperties(String string, ObjectPath objectPath, CeTableDdlInfo ceTableDdlInfo) {
        Optional<String> optional;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FactoryUtil.CONNECTOR.key(), "bytehouse-ce");
        hashMap.put(ClickhouseCatalogFactoryOptions.CLUSTER_NAME.key(), this.clickHouseConfig.clusterName());
        hashMap.put(ClickhouseCatalogFactoryOptions.DATABASE.key(), string);
        hashMap.put(ClickhouseCatalogFactoryOptions.TABLE_NAME.key(), this.getSchemaTableName(objectPath));
        hashMap.put(ClickhouseCatalogFactoryOptions.DISCOVERY_KIND.key(), this.clickHouseConfig.shardDiscoveryKind());
        PropsUtils.putIfPresent(hashMap, ClickhouseCatalogFactoryOptions.GATEWAY_HOST.key(), this.clickHouseConfig.gatewayHost());
        PropsUtils.putIfPresent(hashMap, ClickhouseCatalogFactoryOptions.USERNAME.key(), this.clickHouseConfig.username());
        PropsUtils.putIfPresent(hashMap, ClickhouseCatalogFactoryOptions.PASSWORD.key(), this.clickHouseConfig.password());
        PropsUtils.putIfPresent(hashMap, ClickhouseCatalogFactoryOptions.ACCESS_TOKEN.key(), this.clickHouseConfig.accessToken());
        PropsUtils.putIfPresent(hashMap, ClickhouseCatalogFactoryOptions.API_USER_ID.key(), this.clickHouseConfig.apiUserId());
        PropsUtils.putIfPresent(hashMap, ClickhouseCatalogFactoryOptions.API_ACCOUNT_ID.key(), this.clickHouseConfig.apiAccountId());
        PropsUtils.putIfPresent(hashMap, ClickhouseCatalogFactoryOptions.GATEWAY_PORT.key(), this.clickHouseConfig.gatewayPort().map(Object::toString));
        if (!this.clickHouseConfig.shardDiscoveryServiceHost().isEmpty() && !this.clickHouseConfig.shardDiscoveryServiceHost().contains("127.0.0.1")) {
            PropsUtils.putIfNonBlank(hashMap, ClickhouseCatalogFactoryOptions.SHARD_DISCOVERY_SERVICE_HOST.key(), this.clickHouseConfig.shardDiscoveryServiceHost());
            PropsUtils.putIfNonBlank(hashMap, ClickhouseCatalogFactoryOptions.SHARD_DISCOVERY_SERVICE_PORT.key(), this.clickHouseConfig.shardDiscoveryServicePort());
        }
        PropsUtils.putIfNonBlank(hashMap, ClickhouseCatalogFactoryOptions.AUTH_API.key(), this.clickHouseConfig.authApi());
        PropsUtils.putIfNonBlank(hashMap, ClickhouseCatalogFactoryOptions.LOCAL_TABLE_SUFFIX.key(), this.clickHouseConfig.localTableSuffix());
        PropsUtils.putIfNonBlank(hashMap, ClickhouseCatalogFactoryOptions.API_CONSUL_INFO.key(), this.clickHouseConfig.apiGetConsulInfo());
        PropsUtils.putIfNonBlank(hashMap, ClickhouseCatalogFactoryOptions.API_SHARD_INFO.key(), this.clickHouseConfig.apiGetShardInfo());
        Optional<String> optional2 = ceTableDdlInfo.optionalShardingExpr();
        if (optional2 != null && optional2.isPresent()) {
            hashMap.put(ClickhouseCatalogFactoryOptions.GROUP_BY_KEY.key(), ceTableDdlInfo.optionalColNamesSharding().get());
            hashMap.put(ClickhouseCatalogFactoryOptions.SHARDING_KEY.key(), ceTableDdlInfo.optionalColNamesSharding().get());
            hashMap.put(ClickhouseCatalogFactoryOptions.SHARDING_STRATEGY.key(), ClickHouseShardingStrategy$HashSharding$.MODULE$.name());
        }
        if ((optional = ceTableDdlInfo.optionalShardingExpr()) != null && optional.isPresent()) {
            hashMap.put(ClickhouseCatalogFactoryOptions.GROUP_BY_EXPRESSION.key(), optional.get());
            hashMap.put(ClickhouseCatalogFactoryOptions.SHARDING_EXPRESSION.key(), optional.get());
        }
        String string2 = this.client.retrieveShardsNum(this.clickHouseConfig.clusterName()) + "";
        hashMap.put(ClickhouseCatalogFactoryOptions.GROUP_BY_NUMBER.key(), string2);
        if (this.clickHouseConfig.flushParallelism().isDefined()) {
            hashMap.put(ClickhouseCatalogFactoryOptions.FLUSH_PARALLELISM.key(), this.clickHouseConfig.flushParallelism().get().toString());
        }
        return hashMap;
    }

    public boolean tableExists(ObjectPath objectPath) throws CatalogException {
        try {
            return this.databaseExists(objectPath.getDatabaseName()) && this.listTables(objectPath.getDatabaseName()).contains(objectPath.getObjectName());
        }
        catch (DatabaseNotExistException databaseNotExistException) {
            return false;
        }
    }

    public void dropTable(ObjectPath objectPath, boolean bl) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void renameTable(ObjectPath objectPath, String string, boolean bl) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable, boolean bl) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable, boolean bl) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath objectPath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Preconditions.checkNotNull((Object)objectPath, (String)"Table path cannot be null");
        LOG.debug("listPartitions for {}", (Object)objectPath);
        Collection<HashMap<String, Object>> collection = this.client.retrievePartitions(objectPath.getDatabaseName(), this.getSchemaTableName(objectPath));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (HashMap<String, Object> hashMap2 : collection) {
            hashMap.put(hashMap2.get("partition").toString(), hashMap2.get("name").toString());
        }
        return Collections.singletonList(new CatalogPartitionSpec(hashMap));
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        LOG.debug("listPartitions for {}, CatalogPartitionSpec is {}", (Object)objectPath, (Object)catalogPartitionSpec);
        Preconditions.checkNotNull((Object)objectPath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)catalogPartitionSpec, (String)"Partition spec cannot be null");
        Map map = catalogPartitionSpec.getPartitionSpec();
        String string = (String)map.get("partition");
        String string2 = (String)map.get("name");
        Collection<HashMap<String, Object>> collection = this.client.retrievePartitionByPartitionName(objectPath.getDatabaseName(), this.getSchemaTableName(objectPath), string, string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (HashMap<String, Object> hashMap2 : collection) {
            hashMap.put(hashMap2.get("partition").toString(), hashMap2.get("name").toString());
        }
        return Collections.singletonList(new CatalogPartitionSpec(hashMap));
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath objectPath, List<Expression> list) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException("Failed to list partition by filter from HMS, filter expressions: " + list);
    }

    private void ensurePartitionedTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable) throws TableNotPartitionedException {
        if (!ClickhouseCatalog.isTablePartitioned(catalogBaseTable)) {
            throw new TableNotPartitionedException(this.getName(), objectPath);
        }
    }

    private static boolean isTablePartitioned(CatalogBaseTable catalogBaseTable) {
        return Integer.valueOf(catalogBaseTable.getOptions().getOrDefault("", "0")) != 0;
    }

    public CatalogPartition getPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)objectPath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)catalogPartitionSpec, (String)"CatalogPartitionSpec cannot be null");
        Preconditions.checkNotNull(catalogPartitionSpec.getPartitionSpec().get("partition"), (String)"CatalogPartitionSpec cannot be null");
        Preconditions.checkNotNull(catalogPartitionSpec.getPartitionSpec().get("name"), (String)"CatalogPartitionSpec cannot be null");
        try {
            CatalogPartitionSpec catalogPartitionSpec2 = this.getCePartition(objectPath, catalogPartitionSpec);
            Map map = catalogPartitionSpec2.getPartitionSpec();
            String string = (String)map.get("comment");
            return new CatalogPartitionImpl(map, string);
        }
        catch (PartitionSpecInvalidException partitionSpecInvalidException) {
            throw new PartitionNotExistException(this.getName(), objectPath, catalogPartitionSpec, (Throwable)partitionSpecInvalidException);
        }
        catch (Exception exception) {
            Log.error((String)String.format("Failed to get partition %s of table %s", catalogPartitionSpec, objectPath), (Throwable)exception);
            throw new CatalogException(String.format("Failed to get partition %s of table %s", catalogPartitionSpec, objectPath), (Throwable)exception);
        }
    }

    public boolean partitionExists(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws CatalogException {
        Preconditions.checkNotNull((Object)objectPath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)catalogPartitionSpec, (String)"CatalogPartitionSpec cannot be null");
        try {
            return this.getCePartition(objectPath, catalogPartitionSpec).getPartitionSpec().isEmpty();
        }
        catch (PartitionSpecInvalidException partitionSpecInvalidException) {
            return false;
        }
        catch (Exception exception) {
            throw new CatalogException(String.format("Failed to get partition %s of table %s", catalogPartitionSpec, objectPath), (Throwable)exception);
        }
    }

    @VisibleForTesting
    public CatalogPartitionSpec getCePartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionSpecInvalidException, Exception {
        Map map = catalogPartitionSpec.getPartitionSpec();
        String string = (String)map.get("partition");
        String string2 = (String)map.get("name");
        Collection<HashMap<String, Object>> collection = this.client.retrievePartitionByPartitionName(objectPath.getDatabaseName(), this.getSchemaTableName(objectPath), string, string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (HashMap<String, Object> hashMap2 : collection) {
            hashMap.put(hashMap2.get("partition").toString(), hashMap2.get("name").toString());
        }
        return new CatalogPartitionSpec(hashMap);
    }

    public void createPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean bl) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, boolean bl) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean bl) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listFunctions(String string) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogFunction getFunction(ObjectPath objectPath) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public boolean functionExists(ObjectPath objectPath) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createFunction(ObjectPath objectPath, CatalogFunction catalogFunction, boolean bl) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterFunction(ObjectPath objectPath, CatalogFunction catalogFunction, boolean bl) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropFunction(ObjectPath objectPath, boolean bl) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath objectPath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath objectPath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableStatistics(ObjectPath objectPath, CatalogTableStatistics catalogTableStatistics, boolean bl) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableColumnStatistics(ObjectPath objectPath, CatalogColumnStatistics catalogColumnStatistics, boolean bl) throws TableNotExistException, CatalogException, TablePartitionedException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogTableStatistics catalogTableStatistics, boolean bl) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionColumnStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogColumnStatistics catalogColumnStatistics, boolean bl) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    protected String getSchemaTableName(ObjectPath objectPath) {
        return objectPath.getObjectName();
    }

    protected String getSchemaName(ObjectPath objectPath) {
        return objectPath.getDatabaseName();
    }

    protected String getTableName(ObjectPath objectPath) {
        return objectPath.getObjectName();
    }
}

