/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.flink.table.catalog;

import com.bytedance.bytehouse.commons.DataTypeAdapter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

public final class FlinkToClickHouseDataTypeAdapter$
implements DataTypeAdapter<DataType, String> {
    public static FlinkToClickHouseDataTypeAdapter$ MODULE$;

    static {
        new FlinkToClickHouseDataTypeAdapter$();
    }

    @Override
    public String adapt(DataType fromType) {
        return this.adapt(fromType.getLogicalType());
    }

    @Override
    private String adapt(LogicalType fromType) {
        String string;
        LogicalTypeRoot logicalTypeRoot = fromType.getTypeRoot();
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = "Boolean";
        } else if (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot)) {
            string = "String";
        } else if (LogicalTypeRoot.CHAR.equals(logicalTypeRoot)) {
            CharType typeInfo = (CharType)fromType;
            string = new StringBuilder(13).append("FixedString(").append(typeInfo.getLength()).append(")").toString();
        } else if (LogicalTypeRoot.BINARY.equals(logicalTypeRoot)) {
            BinaryType typeInfo = (BinaryType)fromType;
            string = new StringBuilder(8).append("BINARY(").append(typeInfo.getLength()).append(")").toString();
        } else if (LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot)) {
            string = "String";
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = "Int8";
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = "Int16";
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            string = "Int32";
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            string = "Int64";
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = "Float64";
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = "Float32";
        } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
            DecimalType typeInfo = (DecimalType)fromType;
            int precision = typeInfo.getPrecision();
            int scale = typeInfo.getScale();
            string = precision == 20 && scale == 0 ? "UInt64" : new StringBuilder(11).append("Decimal(").append(precision).append(", ").append(scale).append(")").toString();
        } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            string = "Date";
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimeType typeInfo = (TimeType)fromType;
            int precision = typeInfo.getPrecision();
            string = new StringBuilder(6).append("Time(").append(precision).append(")").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampType typeInfo = (TimestampType)fromType;
            int precision = typeInfo.getPrecision();
            string = this.getDateTimeType(precision);
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot)) {
            ZonedTimestampType typeInfo = (ZonedTimestampType)fromType;
            int precision = typeInfo.getPrecision();
            string = this.getDateTimeType(precision);
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            LocalZonedTimestampType typeInfo = (LocalZonedTimestampType)fromType;
            int precision = typeInfo.getPrecision();
            string = this.getDateTimeType(precision);
        } else if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
            ArrayType typeInfo = (ArrayType)fromType;
            LogicalType elemType = typeInfo.getElementType();
            string = new StringBuilder(7).append("Array(").append(this.adapt(elemType)).append(")").toString();
        } else if (LogicalTypeRoot.MAP.equals(logicalTypeRoot)) {
            MapType typeInfo = (MapType)fromType;
            LogicalType keyType = typeInfo.getKeyType();
            LogicalType valueType = typeInfo.getValueType();
            string = new StringBuilder(7).append("Map(").append(this.adapt(keyType)).append(", ").append(this.adapt(valueType)).append(")").toString();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(56).append("Unsupported Flink-to-ClickHouse adaption for data type '").append(fromType.toString()).toString());
        }
        String ckType = string;
        if (fromType.isNullable()) {
            return new StringBuilder(10).append("Nullable(").append(ckType).append(")").toString();
        }
        return ckType;
    }

    private String getDateTimeType(int precision) {
        if (precision > 0) {
            return new StringBuilder(12).append("DateTime64(").append(precision).append(")").toString();
        }
        return "DateTime";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FlinkToClickHouseDataTypeAdapter$() {
        MODULE$ = this;
    }
}

