/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.flink.table.data;

import com.bytedance.bytehouse.commons.TemporalUtils$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.apache.flink.table.data.TimestampData;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class TimestampDataUtils$ {
    public static TimestampDataUtils$ MODULE$;
    private final Map<String, Try<TimestampData>> predefined;

    static {
        new TimestampDataUtils$();
    }

    private Map<String, Try<TimestampData>> predefined() {
        return this.predefined;
    }

    public Try<TimestampData> parse(String text) {
        return (Try)this.predefined().getOrElse((Object)text, (Function0 & Serializable & scala.Serializable)() -> MODULE$.parseAsLocalDateTime(text).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseAsSqlTimestamp(text)).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseAsUnixEpochMillis(new StringOps(Predef$.MODULE$.augmentString(text)).toLong())).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseWithTimeZone(text)));
    }

    public Try<TimestampData> parseWithTimeZone(String text) {
        return this.parseAsZonedDateTime(text).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseAsInstant(text));
    }

    public Try<TimestampData> parseAsLocalDateTime(CharSequence text) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TimestampData.fromLocalDateTime((LocalDateTime)TemporalUtils$.MODULE$.parseDateTime(text)));
    }

    public Try<TimestampData> parseAsSqlTimestamp(String text) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf(text)));
    }

    public Function1<Object, Try<TimestampData>> parseAsUnixEpoch(int precision) {
        int n = precision;
        switch (n) {
            case 0: {
                return (Function1 & Serializable & scala.Serializable)secs -> TimestampDataUtils$.MODULE$.parseAsUnixEpochSeconds(BoxesRunTime.unboxToLong((Object)secs));
            }
        }
        if (n <= 3) {
            return (Function1 & Serializable & scala.Serializable)millis -> TimestampDataUtils$.MODULE$.parseAsUnixEpochMillis(BoxesRunTime.unboxToLong((Object)millis));
        }
        if (n <= 6) {
            return (Function1 & Serializable & scala.Serializable)micros -> TimestampDataUtils$.MODULE$.parseAsUnixEpochMicros(BoxesRunTime.unboxToLong((Object)micros));
        }
        return (Function1 & Serializable & scala.Serializable)nanos -> TimestampDataUtils$.MODULE$.parseAsUnixEpochNanos(BoxesRunTime.unboxToLong((Object)nanos));
    }

    private Try<TimestampData> parseAsUnixEpochSeconds(long secs) {
        return this.parseAsUnixEpochMillis(secs * 1000L);
    }

    private Try<TimestampData> parseAsUnixEpochMillis(long millis) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TimestampData.fromEpochMillis((long)millis));
    }

    private Try<TimestampData> parseAsUnixEpochMicros(long micros) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = Integral.Implicits$.MODULE$.infixIntegralOps((Object)BoxesRunTime.boxToLong((long)micros), (Integral)Numeric.LongIsIntegral$.MODULE$).$div$percent((Object)BoxesRunTime.boxToLong((long)1000L));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long millis = tuple2._1$mcJ$sp();
            long microsRemainder = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(millis, microsRemainder);
            long millis2 = sp2._1$mcJ$sp();
            long microsRemainder2 = sp2._2$mcJ$sp();
            int nanosRemainder = (int)(microsRemainder2 * 1000L);
            return TimestampData.fromEpochMillis((long)millis2, (int)nanosRemainder);
        });
    }

    private Try<TimestampData> parseAsUnixEpochNanos(long nanos) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = Integral.Implicits$.MODULE$.infixIntegralOps((Object)BoxesRunTime.boxToLong((long)nanos), (Integral)Numeric.LongIsIntegral$.MODULE$).$div$percent((Object)BoxesRunTime.boxToLong((long)1000000L));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long millis = tuple2._1$mcJ$sp();
            long nanosRemainder = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(millis, nanosRemainder);
            long millis2 = sp2._1$mcJ$sp();
            long nanosRemainder2 = sp2._2$mcJ$sp();
            return TimestampData.fromEpochMillis((long)millis2, (int)((int)nanosRemainder2));
        });
    }

    public Try<TimestampData> parseAsZonedDateTime(CharSequence text) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TimestampData.fromLocalDateTime((LocalDateTime)ZonedDateTime.parse(text).toLocalDateTime()));
    }

    public Try<TimestampData> parseAsInstant(CharSequence text) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TimestampData.fromInstant((Instant)Instant.parse(text)));
    }

    private TimestampDataUtils$() {
        MODULE$ = this;
        this.predefined = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0000-00-00 00:00:00"), this.parseAsInstant("1970-01-01T00:00:00.00Z"))}));
    }
}

