/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.sql;

import com.bytedance.bytehouse.ByteHouseSystemTables$;
import com.bytedance.bytehouse.commons.Preconditions$;
import com.bytedance.bytehouse.commons.package$;
import com.bytedance.bytehouse.commons.package$StringOps$;
import com.bytedance.bytehouse.sql.SelectStatementBuilder;
import com.bytedance.bytehouse.table.QualifiedTableName;
import scala.Predef$;
import scala.collection.Seq;

public final class ByteHouseSql$ {
    public static ByteHouseSql$ MODULE$;

    static {
        new ByteHouseSql$();
    }

    public String sqlShowDatabases() {
        return "SHOW DATABASES";
    }

    public String sqlExistsDatabase(String dbName) {
        return new StringBuilder(16).append("EXISTS DATABASE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(Preconditions$.MODULE$.checkNonBlank(dbName)))).toString();
    }

    public String sqlCreateDatabase(String dbName) {
        return new StringBuilder(16).append("CREATE DATABASE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(Preconditions$.MODULE$.checkNonBlank(dbName)))).toString();
    }

    public String sqlCreateDatabaseIfNotExists(String dbName) {
        return new StringBuilder(16).append("CREATE DATABASE ").append(this.sqlIfNotExists(dbName)).toString();
    }

    public String sqlDropDatabase(String clusterName, String dbName) {
        return new StringBuilder(1).append(this.sqlDropDatabase(dbName)).append(" ").append(this.sqlOnClusterSync(clusterName)).toString();
    }

    public String sqlDropDatabase(String dbName) {
        return new StringBuilder(14).append("DROP DATABASE ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(Preconditions$.MODULE$.checkNonBlank(dbName)))).toString();
    }

    public String sqlDropDatabaseIfExists(String dbName) {
        return new StringBuilder(14).append("DROP DATABASE ").append(this.sqlIfExists(dbName)).toString();
    }

    public String sqlDropDatabaseIfExists(String clusterName, String dbName) {
        return new StringBuilder(1).append(this.sqlDropDatabaseIfExists(dbName)).append(" ").append(this.sqlOnClusterSync(clusterName)).toString();
    }

    public String sqlShowTables(String dbName) {
        return new StringBuilder(15).append("SHOW TABLES IN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(Preconditions$.MODULE$.checkNonBlank(dbName)))).toString();
    }

    public String sqlExistsTable(QualifiedTableName dbTable) {
        return new StringBuilder(13).append("EXISTS TABLE ").append(Preconditions$.MODULE$.checkNotNull(dbTable)).toString();
    }

    public String sqlDropTable(String clusterName, QualifiedTableName dbTable) {
        return new StringBuilder(1).append(this.sqlDropTable(dbTable)).append(" ").append(this.sqlOnClusterSync(clusterName)).toString();
    }

    public String sqlDropTable(QualifiedTableName dbTable) {
        return new StringBuilder(11).append("DROP TABLE ").append(Preconditions$.MODULE$.checkNotNull(dbTable)).toString();
    }

    public String sqlDropTableIfExists(String clusterName, QualifiedTableName dbTable) {
        return new StringBuilder(1).append(this.sqlDropTableIfExists(dbTable)).append(" ").append(this.sqlOnClusterSync(clusterName)).toString();
    }

    public String sqlDropTableIfExists(QualifiedTableName dbTable) {
        return new StringBuilder(11).append("DROP TABLE ").append(this.sqlIfExists(Preconditions$.MODULE$.checkNotNull(dbTable).toString())).toString();
    }

    public String sqlTruncateTable(String clusterName, QualifiedTableName dbTable) {
        return new StringBuilder(1).append(this.sqlTruncateTable(dbTable)).append(" ").append(this.sqlOnCluster(clusterName)).toString();
    }

    public String sqlTruncateTable(QualifiedTableName dbTable) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(dbTable).toString();
    }

    public String sqlCountDistinctShards(String clusterName) {
        return new SelectStatementBuilder().select(new StringBuilder(40).append("count(DISTINCT shard_num) AS ").append("shard_count").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).from(ByteHouseSystemTables$.MODULE$.clusters()).where(new StringBuilder(12).append("cluster = '").append(clusterName).append("'").toString()).build();
    }

    public String sqlAddColumn(QualifiedTableName dbTable, String colName, String colType) {
        return this.sqlAddColumn(dbTable, colName, colType, "");
    }

    public String sqlAddColumn(QualifiedTableName dbTable, String colName, String colType, String position) {
        String manipulation = new StringBuilder(13).append("ADD COLUMN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(colName))).append(" ").append(colType).append(" ").append(position).toString();
        return this.sqlAlterTable(dbTable, manipulation);
    }

    public String sqlAddColumnIfNotExists(QualifiedTableName dbTable, String colName, String colType) {
        return this.sqlAddColumnIfNotExists(dbTable, colName, colType, "");
    }

    public String sqlAddColumnIfNotExists(QualifiedTableName dbTable, String colName, String colType, String position) {
        String manipulation = new StringBuilder(13).append("ADD COLUMN ").append(this.sqlIfNotExists(colName)).append(" ").append(colType).append(" ").append(position).toString();
        return this.sqlAlterTable(dbTable, manipulation);
    }

    public String sqlDropColumn(QualifiedTableName dbTable, String colName) {
        String manipulation = new StringBuilder(12).append("DROP COLUMN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(colName))).toString();
        return this.sqlAlterTable(dbTable, manipulation);
    }

    public String sqlDropColumnIfExists(QualifiedTableName dbTable, String colName) {
        String manipulation = new StringBuilder(12).append("DROP COLUMN ").append(this.sqlIfExists(colName)).toString();
        return this.sqlAlterTable(dbTable, manipulation);
    }

    public String sqlRenameColumn(QualifiedTableName dbTable, String oldColName, String newColName) {
        String manipulation = new StringBuilder(18).append("RENAME COLUMN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(oldColName))).append(" TO ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(newColName))).toString();
        return this.sqlAlterTable(dbTable, manipulation);
    }

    public String sqlModifyColumn(QualifiedTableName dbTable, String colName, String colDef) {
        return this.sqlModifyColumn(dbTable, colName, colDef, "");
    }

    public String sqlModifyColumn(QualifiedTableName dbTable, String colName, String colDef, String position) {
        String manipulation = new StringBuilder(16).append("MODIFY COLUMN ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(colName))).append(" ").append(colDef).append(" ").append(position).toString();
        return this.sqlAlterTable(dbTable, manipulation);
    }

    public String sqlModifyColumnIfExists(QualifiedTableName dbTable, String colName, String colDef) {
        return this.sqlModifyColumnIfExists(dbTable, colName, colDef, "");
    }

    public String sqlModifyColumnIfExists(QualifiedTableName dbTable, String colName, String colDef, String position) {
        String manipulation = new StringBuilder(16).append("MODIFY COLUMN ").append(this.sqlIfExists(colName)).append(" ").append(colDef).append(" ").append(position).toString();
        return this.sqlAlterTable(dbTable, manipulation);
    }

    public String sqlIfExists(String entity) {
        return new StringBuilder(10).append("IF EXISTS ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(Preconditions$.MODULE$.checkNonBlank(entity)))).toString();
    }

    public String sqlIfNotExists(String entity) {
        return new StringBuilder(14).append("IF NOT EXISTS ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(Preconditions$.MODULE$.checkNonBlank(entity)))).toString();
    }

    public String sqlAlterTable(QualifiedTableName dbTable, String manipulation) {
        return new StringBuilder(13).append("ALTER TABLE ").append(Preconditions$.MODULE$.checkNotNull(dbTable)).append(" ").append(manipulation.trim()).toString();
    }

    public String sqlOnClusterSync(String clusterName) {
        return new StringBuilder(5).append(this.sqlOnCluster(clusterName)).append(" SYNC").toString();
    }

    public String sqlOnCluster(String clusterName) {
        return new StringBuilder(11).append("ON CLUSTER ").append(package$StringOps$.MODULE$.backQuotedIfNot$extension(package$.MODULE$.StringOps(Preconditions$.MODULE$.checkNonBlank(clusterName)))).toString();
    }

    private ByteHouseSql$() {
        MODULE$ = this;
    }
}

