/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.utils;

import org.byted.security.ztijwthelper.LegacyIdentity;
import org.byted.security.ztijwthelper.ZTIJwtHelper;
import org.byted.security.ztijwthelper.ZtiJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);

    public static String getToken() {
        try {
            String string = ZTIJwtHelper.getJwtSVID();
            log.info("Get token from env variables SEC_TOKEN_PATH or SEC_TOKEN_STRING, token={}", (Object)string);
            return string;
        }
        catch (ZtiJwtException ztiJwtException) {
            throw new RuntimeException("fail to getJwtSVID, please check.", ztiJwtException);
        }
    }

    public static LegacyIdentity getIdentity() {
        String string = null;
        try {
            string = JwtUtils.getToken();
            return ZTIJwtHelper.decodeGDPRorJwtSVID(string);
        }
        catch (ZtiJwtException ztiJwtException) {
            throw new RuntimeException(String.format("Failed to decode token string, please check the token %s.", string), ztiJwtException);
        }
    }
}

