/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bytehouse.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;

public class NativeUtils {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String TEMP_WORKDIR_PROPERTY_NAME = "java.io.tmpdir";
    private static final String TEMP_DIR_NAME = "native";

    public static void loadLibraryFromJar(String path) throws Exception {
        Path dir;
        NativeUtils.checkArgument(path.startsWith("/"), "absolute path must start with /");
        String[] parts = path.split("/");
        NativeUtils.checkArgument(parts.length > 0, "absolute path must contain file name");
        String filename = parts[parts.length - 1];
        String tempWorkDirName = System.getProperty(TEMP_WORKDIR_PROPERTY_NAME);
        if (tempWorkDirName == null || tempWorkDirName.isEmpty()) {
            dir = Files.createTempDirectory(TEMP_DIR_NAME, new FileAttribute[0]);
        } else {
            File tempWorkDir = new File(tempWorkDirName);
            if (!tempWorkDir.exists() || !tempWorkDir.isDirectory()) {
                throw new FileNotFoundException("The tempWorkDir doesn't exist: " + tempWorkDirName);
            }
            dir = Files.createTempDirectory(tempWorkDir.toPath(), TEMP_DIR_NAME, new FileAttribute[0]);
        }
        dir.toFile().deleteOnExit();
        File temp = new File(dir.toString(), filename);
        temp.deleteOnExit();
        byte[] buffer = new byte[1024];
        try (InputStream input = NativeUtils.class.getResourceAsStream(path);
             FileOutputStream out = new FileOutputStream(temp);){
            int read;
            if (input == null) {
                throw new FileNotFoundException("Couldn't find file into jar " + path);
            }
            while ((read = input.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        if (!temp.exists()) {
            throw new FileNotFoundException("Failed to copy file from jar at " + temp.getAbsolutePath());
        }
        System.load(temp.getAbsolutePath());
    }

    public static String libType() {
        if (OS_NAME.indexOf("mac") >= 0) {
            return ".dylib";
        }
        if (OS_NAME.indexOf("nix") >= 0 || OS_NAME.indexOf("nux") >= 0 || OS_NAME.indexOf("aix") > 0) {
            return ".so";
        }
        if (OS_NAME.indexOf("win") >= 0) {
            return ".dll";
        }
        throw new TypeNotPresentException(OS_NAME + " not supported", null);
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }
}

