/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.metrics.ServerMetrics;
import java.io.IOException;
import shaded.bytehouse.com.fasterxml.jackson.core.JsonFactory;
import shaded.bytehouse.com.fasterxml.jackson.core.JsonParser;
import shaded.bytehouse.com.fasterxml.jackson.core.JsonToken;

public class ProcessParser {
    private static JsonFactory parserFactory = new JsonFactory();

    public static void parseSummary(String text, OperationMetrics metrics) {
        try (JsonParser parser = parserFactory.createParser(text);){
            parser.nextToken();
            JsonToken t2 = parser.nextToken();
            while (t2 != null) {
                if (t2 == JsonToken.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    parser.nextValue();
                    if ("read_rows".equals(fieldName)) {
                        metrics.updateMetric(ServerMetrics.NUM_ROWS_READ, parser.getValueAsLong());
                    } else if ("read_bytes".equals(fieldName)) {
                        metrics.updateMetric(ServerMetrics.NUM_BYTES_READ, parser.getValueAsLong());
                    } else if ("written_rows".equals(fieldName)) {
                        metrics.updateMetric(ServerMetrics.NUM_ROWS_WRITTEN, parser.getValueAsLong());
                    } else if ("written_bytes".equals(fieldName)) {
                        metrics.updateMetric(ServerMetrics.NUM_BYTES_WRITTEN, parser.getValueAsLong());
                    } else if ("total_rows_to_read".equals(fieldName)) {
                        metrics.updateMetric(ServerMetrics.TOTAL_ROWS_TO_READ, parser.getValueAsLong());
                    } else if ("elapsed_ns".equals(fieldName)) {
                        metrics.updateMetric(ServerMetrics.ELAPSED_TIME, parser.getValueAsLong());
                    } else if ("result_rows".equals(fieldName)) {
                        metrics.updateMetric(ServerMetrics.RESULT_ROWS, parser.getValueAsLong());
                    }
                }
                t2 = parser.nextToken();
            }
        }
        catch (IOException e) {
            throw new ClientException("Failed to parse summary", e);
        }
    }
}

