/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.internal.ClickHouseLZ4InputStream;
import com.clickhouse.client.api.internal.ClickHouseLZ4OutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import shaded.bytehouse.net.jpountz.lz4.LZ4Factory;
import shaded.bytehouse.org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import shaded.bytehouse.org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;

class LZ4Entity
implements HttpEntity {
    private HttpEntity httpEntity;
    private final boolean useHttpCompression;
    private final boolean serverCompression;
    private final boolean clientCompression;
    private final int bufferSize;

    LZ4Entity(HttpEntity httpEntity, boolean useHttpCompression, boolean serverCompression, boolean clientCompression, int bufferSize) {
        this.httpEntity = httpEntity;
        this.useHttpCompression = useHttpCompression;
        this.serverCompression = serverCompression;
        this.clientCompression = clientCompression;
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isRepeatable() {
        return this.httpEntity.isRepeatable();
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        if (this.serverCompression && this.useHttpCompression) {
            InputStream content = this.httpEntity.getContent();
            try {
                return new FramedLZ4CompressorInputStream(content);
            }
            catch (IOException e) {
                return content;
            }
        }
        if (this.serverCompression) {
            return new ClickHouseLZ4InputStream(this.httpEntity.getContent(), LZ4Factory.fastestInstance().fastDecompressor(), this.bufferSize);
        }
        return this.httpEntity.getContent();
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        if (this.clientCompression && this.useHttpCompression) {
            this.httpEntity.writeTo(new FramedLZ4CompressorOutputStream(outStream));
        } else if (this.clientCompression) {
            this.httpEntity.writeTo(new ClickHouseLZ4OutputStream(outStream, LZ4Factory.fastestInstance().fastCompressor(), this.bufferSize));
        } else {
            this.httpEntity.writeTo(outStream);
        }
    }

    @Override
    public boolean isStreaming() {
        return this.httpEntity.isStreaming();
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        return this.httpEntity.getTrailers();
    }

    @Override
    public void close() throws IOException {
        this.httpEntity.close();
    }

    @Override
    public long getContentLength() {
        return this.httpEntity.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.httpEntity.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.httpEntity.getContentEncoding();
    }

    @Override
    public boolean isChunked() {
        return this.httpEntity.isChunked();
    }

    @Override
    public Set<String> getTrailerNames() {
        return this.httpEntity.getTrailerNames();
    }
}

