/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.format.BinaryStreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializerUtils.class);

    public static void serializeData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        switch (column.getDataType()) {
            case Array: {
                SerializerUtils.serializeArrayData(stream, value, column);
                break;
            }
            case Tuple: {
                SerializerUtils.serializeTupleData(stream, value, column);
                break;
            }
            case Map: {
                SerializerUtils.serializeMapData(stream, value, column);
                break;
            }
            default: {
                SerializerUtils.serializePrimitiveData(stream, value, column);
            }
        }
    }

    private static void serializeArrayData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        List values = (List)value;
        BinaryStreamUtils.writeVarInt(stream, (long)values.size());
        for (Object val : values) {
            SerializerUtils.serializeData(stream, val, column.getArrayBaseColumn());
        }
    }

    private static void serializeTupleData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        List values = (List)value;
        for (int i = 0; i < values.size(); ++i) {
            SerializerUtils.serializeData(stream, values.get(i), column.getNestedColumns().get(i));
        }
    }

    private static void serializeMapData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        Map map = (Map)value;
        BinaryStreamUtils.writeVarInt(stream, (long)map.size());
        map.forEach((key, val) -> {
            try {
                SerializerUtils.serializePrimitiveData(stream, key, Objects.requireNonNull(column.getKeyInfo()));
                SerializerUtils.serializeData(stream, val, Objects.requireNonNull(column.getValueInfo()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void serializePrimitiveData(OutputStream stream, Object value, ClickHouseColumn column) throws IOException {
        switch (column.getDataType()) {
            case Int8: {
                BinaryStreamUtils.writeInt8(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case Int16: {
                BinaryStreamUtils.writeInt16(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case Int32: {
                BinaryStreamUtils.writeInt32(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case Int64: {
                BinaryStreamUtils.writeInt64(stream, SerializerUtils.convertToLong(value));
                break;
            }
            case Int128: {
                BinaryStreamUtils.writeInt128(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case Int256: {
                BinaryStreamUtils.writeInt256(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case UInt8: {
                BinaryStreamUtils.writeUnsignedInt8(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case UInt16: {
                BinaryStreamUtils.writeUnsignedInt16(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case UInt32: {
                BinaryStreamUtils.writeUnsignedInt32(stream, SerializerUtils.convertToLong(value));
                break;
            }
            case UInt64: {
                BinaryStreamUtils.writeUnsignedInt64(stream, SerializerUtils.convertToLong(value));
                break;
            }
            case UInt128: {
                BinaryStreamUtils.writeUnsignedInt128(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case UInt256: {
                BinaryStreamUtils.writeUnsignedInt256(stream, SerializerUtils.convertToBigInteger(value));
                break;
            }
            case Float32: {
                BinaryStreamUtils.writeFloat32(stream, ((Float)value).floatValue());
                break;
            }
            case Float64: {
                BinaryStreamUtils.writeFloat64(stream, (Double)value);
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                BinaryStreamUtils.writeDecimal(stream, (BigDecimal)value, column.getPrecision(), column.getScale());
                break;
            }
            case Bool: {
                BinaryStreamUtils.writeBoolean(stream, (Boolean)value);
                break;
            }
            case String: {
                BinaryStreamUtils.writeString(stream, (String)value);
                break;
            }
            case FixedString: {
                BinaryStreamUtils.writeFixedString(stream, (String)value, column.getPrecision());
                break;
            }
            case Date: {
                BinaryStreamUtils.writeDate(stream, (LocalDate)value);
                break;
            }
            case Date32: {
                BinaryStreamUtils.writeDate32(stream, (LocalDate)value);
                break;
            }
            case DateTime: {
                BinaryStreamUtils.writeDateTime(stream, (LocalDateTime)value, column.getTimeZone());
                break;
            }
            case DateTime64: {
                BinaryStreamUtils.writeDateTime64(stream, (LocalDateTime)value, column.getScale(), column.getTimeZone());
                break;
            }
            case UUID: {
                BinaryStreamUtils.writeUuid(stream, (UUID)value);
                break;
            }
            case Enum8: {
                BinaryStreamUtils.writeEnum8(stream, (Byte)value);
                break;
            }
            case Enum16: {
                BinaryStreamUtils.writeEnum16(stream, SerializerUtils.convertToInteger(value));
                break;
            }
            case IPv4: {
                BinaryStreamUtils.writeInet4Address(stream, (Inet4Address)value);
                break;
            }
            case IPv6: {
                BinaryStreamUtils.writeInet6Address(stream, (Inet6Address)value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)column.getDataType()));
            }
        }
    }

    public static Integer convertToInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Integer");
    }

    public static Long convertToLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to Long");
    }

    public static BigInteger convertToBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to BigInteger");
    }
}

