/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.naming;

import com.clickhouse.client.ClickHouseDnsResolver;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.net.InetSocketAddress;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public class SrvResolver
extends ClickHouseDnsResolver {
    private static final Logger log = LoggerFactory.getLogger(SrvResolver.class);

    protected SRVRecord lookup(String srvDns, boolean basedOnWeight) {
        Record[] records = null;
        try {
            records = new Lookup(srvDns, 33).run();
        }
        catch (TextParseException e) {
            log.warn((Object)"Not able to resolve given DNS query: [%s]", new Object[]{srvDns, e});
        }
        SRVRecord record2 = null;
        if (records != null) {
            if (basedOnWeight) {
                for (int i = 0; i < records.length; ++i) {
                    SRVRecord rec = (SRVRecord)records[i];
                    if (record2 != null && record2.getWeight() <= rec.getWeight()) continue;
                    record2 = rec;
                }
            } else {
                record2 = (SRVRecord)records[0];
            }
        }
        return record2;
    }

    @Override
    public InetSocketAddress resolve(ClickHouseProtocol protocol, String host, int port) {
        if (protocol == null || host == null) {
            throw new IllegalArgumentException("Non-null protocol and host are required");
        }
        SRVRecord r = this.lookup(host, false);
        if (r != null) {
            host = r.getName().canonicalize().toString(true);
            port = r.getPort();
        }
        return new InetSocketAddress(host, port);
    }
}

