/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.config;

import java.util.function.UnaryOperator;

public enum ClickHouseRenameMethod {
    NONE(null),
    REMOVE_PREFIX(s2 -> {
        int index = s2.lastIndexOf(46);
        return index >= 0 ? s2.substring(index + 1) : s2;
    }),
    TO_CAMELCASE(s2 -> {
        StringBuilder builder = new StringBuilder(s2.length());
        boolean toUpperCase = false;
        for (char ch : s2.toCharArray()) {
            if (Character.isWhitespace(ch) || ch == '_') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                builder.append(Character.toUpperCase(ch));
                toUpperCase = false;
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }),
    TO_CAMELCASE_WITHOUT_PREFIX(s2 -> TO_CAMELCASE.rename(REMOVE_PREFIX.rename((String)s2))),
    TO_UNDERSCORE(s2 -> {
        StringBuilder builder = new StringBuilder(s2.length() + 5);
        int prev = -1;
        for (char ch : s2.toCharArray()) {
            if (Character.isWhitespace(ch)) {
                if (prev == 0) {
                    builder.append('_');
                }
                prev = 1;
                continue;
            }
            if (Character.isUpperCase(ch)) {
                if (prev == 0) {
                    builder.append('_').append(Character.toLowerCase(ch));
                } else if (prev == 1) {
                    builder.append(Character.toLowerCase(ch));
                } else {
                    builder.append(ch);
                }
                prev = 2;
                continue;
            }
            builder.append(ch);
            prev = 0;
        }
        return builder.toString();
    }),
    TO_UNDERSCORE_WITHOUT_PREFIX(s2 -> TO_UNDERSCORE.rename(REMOVE_PREFIX.rename((String)s2)));

    private final UnaryOperator<String> renameFunc;

    private ClickHouseRenameMethod(UnaryOperator<String> renameFunc) {
        this.renameFunc = renameFunc;
    }

    public String rename(String name) {
        if (name == null) {
            name = "";
        }
        return this.renameFunc != null ? (String)this.renameFunc.apply(name) : name;
    }
}

