/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseUtils;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class ClickHouseDeferredValue<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private final AtomicReference<Optional<T>> value;

    public static <T> ClickHouseDeferredValue<T> of(CompletableFuture<T> future) {
        return ClickHouseDeferredValue.of(future, 0L);
    }

    public static <T> ClickHouseDeferredValue<T> of(CompletableFuture<T> future, long timeout) {
        CompletableFuture<Object> f = future != null ? future : ClickHouseUtils.NULL_FUTURE;
        long t2 = timeout < 0L ? 0L : timeout;
        Supplier<Object> supplier = () -> {
            try {
                return t2 > 0L ? f.get(t2, TimeUnit.MILLISECONDS) : f.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                f.cancel(false);
                throw new CompletionException(e);
            }
            catch (CancellationException e) {
                f.cancel(true);
                throw new CompletionException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new CompletionException(e);
            }
        };
        return new ClickHouseDeferredValue<Object>(supplier, null);
    }

    public static <T> ClickHouseDeferredValue<T> of(Supplier<T> supplier) {
        return new ClickHouseDeferredValue<T>(supplier != null ? supplier : ClickHouseUtils.NULL_SUPPLIER, null);
    }

    public static <T> ClickHouseDeferredValue<T> of(T value, Class<T> clazz) {
        return new ClickHouseDeferredValue(ClickHouseUtils.NULL_SUPPLIER, Optional.ofNullable(value));
    }

    private ClickHouseDeferredValue(Supplier<T> supplier, Optional<T> value) {
        this.supplier = supplier;
        this.value = new AtomicReference<Optional<T>>(value);
    }

    @Override
    public T get() {
        return this.getOptional().orElse(null);
    }

    public Optional<T> getOptional() {
        Optional<T> v = this.value.get();
        if (v == null && !this.value.compareAndSet(null, v = Optional.ofNullable(this.supplier.get()))) {
            v = this.value.get();
        }
        return v != null ? v : Optional.empty();
    }
}

