/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import java.math.BigInteger;

public final class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    public static final BigInteger MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    public static final int BYTES = 8;
    public static final UnsignedLong ZERO = new UnsignedLong(0L);
    public static final UnsignedLong ONE = new UnsignedLong(1L);
    public static final UnsignedLong TWO = new UnsignedLong(2L);
    public static final UnsignedLong TEN = new UnsignedLong(10L);
    public static final UnsignedLong MIN_VALUE = ZERO;
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    private final long value;

    public static UnsignedLong valueOf(long l) {
        if (l == -1L) {
            return MAX_VALUE;
        }
        if (l == 0L) {
            return ZERO;
        }
        if (l == 1L) {
            return ONE;
        }
        if (l == 2L) {
            return TWO;
        }
        if (l == 10L) {
            return TEN;
        }
        return new UnsignedLong(l);
    }

    public static UnsignedLong valueOf(BigInteger val) {
        return val == null ? ZERO : UnsignedLong.valueOf(val.longValue());
    }

    public static UnsignedLong valueOf(String s2) {
        return UnsignedLong.valueOf(s2, 10);
    }

    public static UnsignedLong valueOf(String s2, int radix) {
        return UnsignedLong.valueOf(Long.parseUnsignedLong(s2, radix));
    }

    private UnsignedLong(long value) {
        this.value = value;
    }

    public UnsignedLong add(UnsignedLong val) {
        if (val == null || val.value == 0L) {
            return this;
        }
        return UnsignedLong.valueOf(this.value + val.value);
    }

    public UnsignedLong subtract(UnsignedLong val) {
        if (val == null || val.value == 0L) {
            return this;
        }
        return UnsignedLong.valueOf(this.value - val.value);
    }

    public UnsignedLong multiply(UnsignedLong val) {
        if (this.value == 0L || val == null || val.value == 0L) {
            return ZERO;
        }
        return UnsignedLong.valueOf(this.value * val.value);
    }

    public UnsignedLong divide(UnsignedLong val) {
        return UnsignedLong.valueOf(Long.divideUnsigned(this.value, val == null ? 0L : val.value));
    }

    public UnsignedLong remainder(UnsignedLong val) {
        return UnsignedLong.valueOf(Long.remainderUnsigned(this.value, val == null ? 0L : val.value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        BigInteger v = BigInteger.valueOf(this.value);
        if (this.value < 0L) {
            v = v.and(MASK);
        }
        return v;
    }

    @Override
    public float floatValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (float)(this.value >>> 1 | this.value & 1L) * 2.0f;
    }

    @Override
    public double doubleValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (double)(this.value >>> 1 | this.value & 1L) * 2.0;
    }

    @Override
    public int compareTo(UnsignedLong o) {
        return Long.compareUnsigned(this.value, o == null ? 0L : o.value);
    }

    public int hashCode() {
        return 31 + (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((UnsignedLong)obj).value;
    }

    public String toString() {
        return Long.toUnsignedString(this.value);
    }

    public String toString(int radix) {
        return Long.toUnsignedString(this.value, radix);
    }
}

