/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseTransaction;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.config.ClickHouseDefaultOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.config.ClickHouseRenameMethod;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.ClickHouseVersion;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDatabaseMetaData;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.JdbcParameterizedQuery;
import com.clickhouse.jdbc.JdbcParseHandler;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import com.clickhouse.jdbc.internal.InputBasedPreparedStatement;
import com.clickhouse.jdbc.internal.JdbcSavepoint;
import com.clickhouse.jdbc.internal.JdbcTransaction;
import com.clickhouse.jdbc.internal.SqlBasedPreparedStatement;
import com.clickhouse.jdbc.internal.StreamBasedPreparedStatement;
import com.clickhouse.jdbc.internal.TableBasedPreparedStatement;
import com.clickhouse.jdbc.parser.ClickHouseSqlParser;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.jdbc.parser.StatementType;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.Serializable;
import java.net.URI;
import java.sql.ClientInfoStatus;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ClickHouseConnectionImpl
extends JdbcWrapper
implements ClickHouseConnection {
    static final String SETTING_READONLY = "readonly";
    static final String SETTING_MAX_INSERT_BLOCK = "max_insert_block_size";
    static final String SETTING_LW_DELETE = "allow_experimental_lightweight_delete";
    static final ClickHouseDefaultOption CUSTOM_CONFIG = new ClickHouseDefaultOption("custom_jdbc_config", "custom_jdbc_config");
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConnectionImpl.class);
    private static final String SQL_GET_SERVER_INFO = "select currentUser() user, timezone() timezone, version() version, " + ClickHouseConnectionImpl.getSetting("readonly", ClickHouseDataType.UInt8) + ", " + ClickHouseConnectionImpl.getSetting("throw_on_unsupported_query_inside_transaction", ClickHouseDataType.Int8) + ", " + ClickHouseConnectionImpl.getSetting("wait_changes_become_visible_after_commit_mode", ClickHouseDataType.String) + "," + ClickHouseConnectionImpl.getSetting("implicit_transaction", ClickHouseDataType.Int8) + ", " + ClickHouseConnectionImpl.getSetting("max_insert_block_size", ClickHouseDataType.UInt64) + ", " + ClickHouseConnectionImpl.getSetting("allow_experimental_lightweight_delete", ClickHouseDataType.Int8) + ", " + ClickHouseConnectionImpl.getSetting((String)((Object)CUSTOM_CONFIG.getEffectiveDefaultValue()), ClickHouseDataType.String) + " FORMAT RowBinaryWithNamesAndTypes";
    public static final Map<String, ClickHouseColumn> upsertColumnsMap = new HashMap<String, ClickHouseColumn>(){
        {
            this.put("_update_columns_", ClickHouseColumn.of("_update_columns_", ClickHouseDataType.String, false, new ClickHouseColumn[0]));
            this.put("_delete_flag_", ClickHouseColumn.of("_delete_flag_", ClickHouseDataType.Int8, false, new ClickHouseColumn[0]));
        }
    };
    private final JdbcConfig jdbcConf;
    private final ClickHouseClient client;
    private final ClickHouseRequest<?> clientRequest;
    private final Optional<TimeZone> clientTimeZone;
    private final Calendar defaultCalendar;
    private final TimeZone jvmTimeZone;
    private final TimeZone serverTimeZone;
    private final ClickHouseVersion serverVersion;
    private final String user;
    private final int initialReadOnly;
    private final int initialNonTxQuerySupport;
    private final String initialTxCommitWaitMode;
    private final int initialImplicitTx;
    private final long initialMaxInsertBlockSize;
    private final int initialDeleteSupport;
    private final Map<String, Class<?>> typeMap;
    private final AtomicReference<JdbcTransaction> txRef;
    private boolean autoCommit;
    private boolean closed;
    private String database;
    private boolean readOnly;
    private int networkTimeout;
    private int rsHoldability;
    private int txIsolation;

    public ClickHouseConnectionImpl(String string) throws SQLException {
        this(string, new Properties());
    }

    public ClickHouseConnectionImpl(String string, Properties properties) throws SQLException {
        this(ClickHouseJdbcUrlParser.parse(string, properties));
    }

    public ClickHouseConnectionImpl(ClickHouseJdbcUrlParser.ConnectionInfo connectionInfo) throws SQLException {
        String string;
        ClickHouseRequest<?> clickHouseRequest;
        ClickHouseClient clickHouseClient;
        ClickHouseNode clickHouseNode;
        Properties properties = connectionInfo.getProperties();
        this.jvmTimeZone = TimeZone.getDefault();
        ClickHouseClientBuilder clickHouseClientBuilder = ClickHouseClient.builder().options(ClickHouseDriver.toClientOptions(properties)).defaultCredentials(connectionInfo.getDefaultCredentials());
        ClickHouseNodes clickHouseNodes = connectionInfo.getNodes();
        if (clickHouseNodes.isSingleNode()) {
            try {
                clickHouseNode = clickHouseNodes.apply(clickHouseNodes.getNodeSelector());
            }
            catch (Exception exception) {
                throw SqlExceptionUtils.clientError("Failed to get single-node", exception);
            }
            clickHouseClient = clickHouseClientBuilder.nodeSelector(ClickHouseNodeSelector.of(clickHouseNode.getProtocol(), new ClickHouseProtocol[0])).build();
            clickHouseRequest = clickHouseClient.read(clickHouseNode);
        } else {
            log.debug((Object)"Selecting node from: %s", clickHouseNodes);
            clickHouseClient = clickHouseClientBuilder.build();
            clickHouseRequest = clickHouseClient.read(clickHouseNodes);
            try {
                clickHouseNode = clickHouseRequest.getServer();
            }
            catch (Exception exception) {
                throw SqlExceptionUtils.clientError("No healthy node available", exception);
            }
        }
        log.debug((Object)"Connecting to: %s", clickHouseNode);
        ClickHouseConfig clickHouseConfig = clickHouseRequest.getConfig();
        String string2 = null;
        TimeZone timeZone = null;
        ClickHouseVersion clickHouseVersion = null;
        ClickHouseRecord clickHouseRecord = null;
        if (clickHouseConfig.hasServerInfo()) {
            timeZone = clickHouseConfig.getServerTimeZone();
            clickHouseVersion = clickHouseConfig.getServerVersion();
            if (connectionInfo.getJdbcConfig().isCreateDbIfNotExist()) {
                clickHouseRecord = ClickHouseConnectionImpl.getServerInfo(clickHouseNode, clickHouseRequest, true);
            }
        } else {
            clickHouseRecord = ClickHouseConnectionImpl.getServerInfo(clickHouseNode, clickHouseRequest, connectionInfo.getJdbcConfig().isCreateDbIfNotExist());
            string2 = clickHouseRecord.getValue(0).asString();
            String string3 = clickHouseRecord.getValue(1).asString();
            string = clickHouseRecord.getValue(2).asString();
            clickHouseVersion = ClickHouseVersion.of(string);
            if (clickHouseVersion.check("(,20.7)")) {
                throw SqlExceptionUtils.unsupportedError("We apologize, but this driver only works with ClickHouse servers 20.7 and above. Please consider to upgrade your server to a more recent version.");
            }
            if (ClickHouseChecker.isNullOrBlank(string3)) {
                string3 = "UTC";
            }
            timeZone = "UTC".equals(string3) ? ClickHouseValues.UTC_TIMEZONE : TimeZone.getTimeZone(string3);
            ((ClickHouseRequest)clickHouseRequest.option(ClickHouseClientOption.SERVER_TIME_ZONE, (Serializable)((Object)string3))).option(ClickHouseClientOption.SERVER_VERSION, (Serializable)((Object)string));
        }
        boolean bl = clickHouseVersion.check("[23.3,)");
        if (clickHouseRecord != null) {
            this.initialReadOnly = clickHouseRecord.getValue(3).asInteger();
            this.initialNonTxQuerySupport = clickHouseRecord.getValue(4).asInteger();
            this.initialTxCommitWaitMode = clickHouseRecord.getValue(5).asString().toLowerCase(Locale.ROOT);
            this.initialImplicitTx = clickHouseRecord.getValue(6).asInteger();
            this.initialMaxInsertBlockSize = clickHouseRecord.getValue(7).asLong();
            this.initialDeleteSupport = bl ? 2 : clickHouseRecord.getValue(8).asInteger();
            string = ClickHouseUtils.unescape(clickHouseRecord.getValue(9).asString());
            if (ClickHouseChecker.isNullOrBlank(string)) {
                this.jdbcConf = connectionInfo.getJdbcConfig();
                this.client = clickHouseClient;
                this.clientRequest = clickHouseRequest;
            } else {
                clickHouseClient.close();
                Properties properties2 = ClickHouseJdbcUrlParser.newProperties();
                Map<String, String> map = ClickHouseUtils.extractParameters(string, null);
                boolean bl2 = Boolean.parseBoolean(map.get("*"));
                if (bl2) {
                    clickHouseClientBuilder.clearOptions();
                } else {
                    properties2.putAll((Map<?, ?>)connectionInfo.getJdbcConfig().getProperties());
                    properties2.putAll((Map<?, ?>)properties);
                }
                properties2.putAll(map);
                this.jdbcConf = new JdbcConfig(properties2);
                Map<ClickHouseOption, Serializable> map2 = ClickHouseConfig.toClientOptions(properties2);
                clickHouseClientBuilder.options(map2);
                this.client = clickHouseClientBuilder.build();
                this.clientRequest = this.client.read(clickHouseNode);
                if (bl2 && !clickHouseRequest.getSettings().isEmpty()) {
                    this.clientRequest.clearSettings();
                }
                ((ClickHouseRequest)this.clientRequest.option(ClickHouseClientOption.SERVER_TIME_ZONE, (Serializable)((Object)timeZone.getID()))).option(ClickHouseClientOption.SERVER_VERSION, (Serializable)((Object)clickHouseVersion.toString()));
                for (Map.Entry<ClickHouseOption, Serializable> entry : map2.entrySet()) {
                    this.clientRequest.option(entry.getKey(), entry.getValue());
                }
                if (bl2) {
                    ((ClickHouseRequest)this.clientRequest.freezeOptions()).freezeSettings();
                }
                clickHouseConfig = this.clientRequest.getConfig();
            }
        } else {
            this.jdbcConf = connectionInfo.getJdbcConfig();
            this.initialReadOnly = clickHouseRequest.getSetting(SETTING_READONLY, 0);
            this.initialNonTxQuerySupport = clickHouseRequest.getSetting("throw_on_unsupported_query_inside_transaction", 1);
            this.initialTxCommitWaitMode = clickHouseRequest.getSetting("wait_changes_become_visible_after_commit_mode", "wait_unknown");
            this.initialImplicitTx = clickHouseRequest.getSetting("implicit_transaction", 0);
            this.initialMaxInsertBlockSize = clickHouseRequest.getSetting(SETTING_MAX_INSERT_BLOCK, 0L);
            this.initialDeleteSupport = clickHouseRequest.getSetting(SETTING_LW_DELETE, bl ? 2 : 0);
            this.client = clickHouseClient;
            this.clientRequest = clickHouseRequest;
        }
        this.autoCommit = !this.jdbcConf.isJdbcCompliant() || this.jdbcConf.isAutoCommit();
        this.closed = false;
        this.database = clickHouseConfig.getDatabase();
        this.clientRequest.use(this.database);
        this.readOnly = this.clientRequest.getSetting(SETTING_READONLY, this.initialReadOnly) != 0;
        this.networkTimeout = 0;
        this.rsHoldability = 1;
        if (this.isTransactionSupported()) {
            this.txIsolation = 4;
            if (this.jdbcConf.isJdbcCompliant() && !this.readOnly && !this.clientRequest.hasSetting("throw_on_unsupported_query_inside_transaction")) {
                this.clientRequest.set("throw_on_unsupported_query_inside_transaction", Integer.valueOf(0));
            }
        } else {
            this.txIsolation = this.jdbcConf.isJdbcCompliant() ? 2 : 0;
        }
        this.user = string2 != null ? string2 : clickHouseNode.getCredentials(clickHouseConfig).getUserName();
        this.serverTimeZone = timeZone;
        if (clickHouseConfig.isUseServerTimeZone()) {
            this.clientTimeZone = Optional.empty();
            this.defaultCalendar = new GregorianCalendar();
        } else {
            this.clientTimeZone = Optional.of(clickHouseConfig.getUseTimeZone());
            this.defaultCalendar = new GregorianCalendar(this.clientTimeZone.get());
        }
        this.serverVersion = clickHouseVersion;
        this.typeMap = new HashMap(this.jdbcConf.getTypeMap());
        this.txRef = new AtomicReference<JdbcTransaction>(this.autoCommit ? null : this.createTransaction());
    }

    private static String getSetting(String string, ClickHouseDataType clickHouseDataType) {
        return ClickHouseConnectionImpl.getSetting(string, clickHouseDataType, null);
    }

    private static String getSetting(String string, ClickHouseDataType clickHouseDataType, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (clickHouseDataType == ClickHouseDataType.String) {
            stringBuilder.append("(ifnull((select value from system.settings where name = '").append(string).append("'), ");
        } else {
            stringBuilder.append("to").append(clickHouseDataType.name()).append("(ifnull((select value from system.settings where name = '").append(string).append("'), ");
        }
        if (ClickHouseChecker.isNullOrEmpty(string2)) {
            stringBuilder.append(clickHouseDataType.getMaxPrecision() > 0 ? (clickHouseDataType.isSigned() ? "'-1'" : "'0'") : "''");
        } else {
            stringBuilder.append('\'').append(string2).append('\'');
        }
        return stringBuilder.append(")) as ").append(string).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ClickHouseRecord getServerInfo(ClickHouseNode clickHouseNode, ClickHouseRequest<?> clickHouseRequest, boolean bl) throws SQLException {
        Object obj = clickHouseRequest.copy().option(ClickHouseClientOption.RENAME_RESPONSE_COLUMN, (Serializable)((Object)ClickHouseRenameMethod.NONE));
        if (!bl) {
            ((ClickHouseRequest)obj).option(ClickHouseClientOption.DATABASE, (Serializable)((Object)""));
        }
        try (ClickHouseResponse clickHouseResponse = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)obj).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false))).option(ClickHouseClientOption.COMPRESS, Boolean.valueOf(false))).option(ClickHouseClientOption.DECOMPRESS, Boolean.valueOf(false))).option(ClickHouseClientOption.FORMAT, (Serializable)((Object)ClickHouseFormat.RowBinaryWithNamesAndTypes))).query(SQL_GET_SERVER_INFO)).executeAndWait();){
            ClickHouseRecord throwable3 = clickHouseResponse.firstRecord();
            return throwable3;
        }
        catch (Exception exception) {
            SQLException sQLException = SqlExceptionUtils.handle(exception, new Throwable[0]);
            if (!bl) throw sQLException;
            if (sQLException.getErrorCode() != 81) throw sQLException;
            String string = clickHouseNode.getDatabase(clickHouseRequest.getConfig());
            try (ClickHouseResponse sQLException2 = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)obj).use("")).query("CREATE DATABASE IF NOT EXISTS `" + ClickHouseUtils.escape(string, '`') + '`')).executeAndWait();){
                ClickHouseRecord clickHouseRecord = ClickHouseConnectionImpl.getServerInfo(clickHouseNode, clickHouseRequest, false);
                return clickHouseRecord;
            }
            catch (SQLException exception2) {
                throw exception2;
            }
            catch (Exception exception2) {
                throw SqlExceptionUtils.handle(exception2, new Throwable[0]);
            }
        }
    }

    protected JdbcTransaction createTransaction() throws SQLException {
        if (!this.isTransactionSupported()) {
            return new JdbcTransaction(null);
        }
        try {
            ClickHouseTransaction clickHouseTransaction = this.clientRequest.getManager().createTransaction(this.clientRequest);
            clickHouseTransaction.begin();
            this.clientRequest.transaction(clickHouseTransaction);
            return new JdbcTransaction(clickHouseTransaction);
        }
        catch (ClickHouseException clickHouseException) {
            throw SqlExceptionUtils.handle(clickHouseException);
        }
    }

    protected JdbcSavepoint createSavepoint() {
        return new JdbcSavepoint(1, "name");
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw SqlExceptionUtils.clientError("Cannot operate on a closed connection");
        }
    }

    protected void ensureSupport(String string, boolean bl) throws SQLException {
        String string2 = string + " is not supported";
        if (this.jdbcConf.isJdbcCompliant()) {
            if (bl) {
                log.debug((Object)"[JDBC Compliant Mode] %s. You may change %s to false to throw SQLException instead.", string2, "jdbcCompliant");
            } else {
                log.warn((Object)"[JDBC Compliant Mode] %s. You may change %s to false to throw SQLException instead.", string2, "jdbcCompliant");
            }
        } else if (!bl) {
            throw SqlExceptionUtils.unsupportedError(string2);
        }
    }

    protected void ensureTransactionSupport() throws SQLException {
        if (!this.isTransactionSupported()) {
            this.ensureSupport("Transaction", false);
        }
    }

    protected List<ClickHouseColumn> getTableColumns(String string2, String string3, String string4) throws SQLException {
        List list;
        Serializable serializable;
        String[] stringArray;
        block24: {
            if (string3 == null || string4 == null) {
                throw SqlExceptionUtils.clientError("Failed to extract table and columns from the query");
            }
            string4 = string4.isEmpty() ? "*" : string4.substring(1);
            stringArray = (String[])Arrays.stream(string4.split(",")).map(String::trim).toArray(String[]::new);
            CharSequence[] charSequenceArray = (String[])Arrays.stream(stringArray).filter(string -> !upsertColumnsMap.containsKey(string)).toArray(String[]::new);
            string4 = String.join((CharSequence)",", charSequenceArray);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DESC TABLE ");
            if (!ClickHouseChecker.isNullOrEmpty(string2)) {
                stringBuilder.append('`').append(ClickHouseUtils.escape(string2, '`')).append('`').append('.');
            }
            stringBuilder.append('`').append(ClickHouseUtils.escape(string3, '`')).append('`');
            try {
                serializable = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)this.clientRequest.copy().format(ClickHouseFormat.RowBinaryWithNamesAndTypes)).option(ClickHouseClientOption.RENAME_RESPONSE_COLUMN, (Serializable)((Object)ClickHouseRenameMethod.NONE))).query(stringBuilder.toString())).executeAndWait();
                Throwable throwable = null;
                try {
                    List list2 = StreamSupport.stream(serializable.records().spliterator(), false).map(clickHouseRecord -> ClickHouseColumn.of(clickHouseRecord.getValue(0).asString(), clickHouseRecord.getValue(1).asString())).collect(Collectors.toList());
                    if ("*".equalsIgnoreCase(string4)) {
                        list = list2;
                        break block24;
                    }
                    List list3 = Arrays.stream(string4.split(",")).map(string -> string.trim().replaceAll("`", "")).collect(Collectors.toList());
                    Map map = list2.stream().collect(Collectors.toMap(ClickHouseColumn::getColumnName, Function.identity()));
                    if (!list3.contains("*")) {
                        ArrayList arrayList = new ArrayList();
                        for (String string5 : list3) {
                            ClickHouseColumn clickHouseColumn = (ClickHouseColumn)map.get(string5);
                            if (clickHouseColumn != null) {
                                arrayList.add(clickHouseColumn);
                                continue;
                            }
                            throw new SQLException(String.format("can not get the column %s, the columns may be %s", string5, Arrays.toString(list2.toArray())));
                        }
                        list = arrayList;
                        break block24;
                    }
                    Set set = list3.stream().filter(string -> !"*".equals(string)).collect(Collectors.toSet());
                    ArrayList arrayList = new ArrayList();
                    for (String string6 : list3) {
                        if ("*".equals(string6)) {
                            for (ClickHouseColumn clickHouseColumn : list2) {
                                if (set.contains(clickHouseColumn.getColumnName())) continue;
                                arrayList.add(clickHouseColumn);
                            }
                            continue;
                        }
                        ClickHouseColumn clickHouseColumn = (ClickHouseColumn)map.get(string6);
                        if (clickHouseColumn != null) {
                            arrayList.add(clickHouseColumn);
                            continue;
                        }
                        throw new SQLException(String.format("can not get the column %s, the columns may be %s", string6, Arrays.toString(list2.toArray())));
                    }
                    list = arrayList;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (serializable != null) {
                        if (throwable != null) {
                            try {
                                serializable.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            serializable.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                log.warn((Object)"filter columns failed, ex: %s ", exception.getMessage());
                throw SqlExceptionUtils.handle(exception, new Throwable[0]);
            }
        }
        serializable = new ArrayList(list);
        this.addUpsertColumnsToList(stringArray, upsertColumnsMap, (List<ClickHouseColumn>)((Object)serializable));
        return serializable;
    }

    private void addUpsertColumnsToList(String[] stringArray, Map<String, ClickHouseColumn> map, List<ClickHouseColumn> list) {
        Arrays.stream(stringArray).filter(map::containsKey).forEach(string -> list.add((ClickHouseColumn)map.get(string)));
    }

    protected String getDatabase() throws SQLException {
        this.ensureOpen();
        return this.getCurrentDatabase();
    }

    final JdbcTransaction getJdbcTrasaction() {
        return this.txRef.get();
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.ensureOpen();
        return string;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpen();
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.ensureOpen();
        if (this.autoCommit == bl) {
            return;
        }
        this.ensureTransactionSupport();
        this.autoCommit = bl;
        if (this.autoCommit) {
            JdbcTransaction jdbcTransaction = this.txRef.getAndSet(null);
            if (jdbcTransaction != null) {
                jdbcTransaction.commit(log);
            }
        } else if (!this.txRef.compareAndSet(null, this.createTransaction())) {
            log.warn((Object)"Not able to start a new transaction, reuse the exist one: %s", this.txRef.get());
        }
    }

    @Override
    public void begin() throws SQLException {
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot start new transaction in auto-commit mode");
        }
        this.ensureTransactionSupport();
        JdbcTransaction jdbcTransaction = this.txRef.get();
        if (jdbcTransaction == null || !jdbcTransaction.isNew()) {
            throw new SQLException("Transaction has been started", "25000");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit() throws SQLException {
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot commit in auto-commit mode");
        }
        this.ensureTransactionSupport();
        JdbcTransaction jdbcTransaction = this.txRef.get();
        if (jdbcTransaction == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        try {
            jdbcTransaction.commit(log);
            if (this.txRef.compareAndSet(jdbcTransaction, this.createTransaction())) return;
        }
        catch (Throwable throwable) {
            if (this.txRef.compareAndSet(jdbcTransaction, this.createTransaction())) throw throwable;
            log.warn((Object)"Transaction was set to %s unexpectedly", this.txRef.get());
            throw throwable;
        }
        log.warn((Object)"Transaction was set to %s unexpectedly", this.txRef.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback() throws SQLException {
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback in auto-commit mode");
        }
        this.ensureTransactionSupport();
        JdbcTransaction jdbcTransaction = this.txRef.get();
        if (jdbcTransaction == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        try {
            jdbcTransaction.rollback(log);
            if (this.txRef.compareAndSet(jdbcTransaction, this.createTransaction())) return;
        }
        catch (Throwable throwable) {
            if (this.txRef.compareAndSet(jdbcTransaction, this.createTransaction())) throw throwable;
            log.warn((Object)"Transaction was set to %s unexpectedly", this.txRef.get());
            throw throwable;
        }
        log.warn((Object)"Transaction was set to %s unexpectedly", this.txRef.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws SQLException {
        try {
            this.client.close();
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to close connection due to %s", exception.getMessage());
            throw SqlExceptionUtils.handle(exception, new Throwable[0]);
        }
        finally {
            this.closed = true;
        }
        JdbcTransaction jdbcTransaction = this.txRef.get();
        if (jdbcTransaction == null) return;
        try {
            jdbcTransaction.commit(log);
            if (this.txRef.compareAndSet(jdbcTransaction, null)) return;
        }
        catch (Throwable throwable) {
            if (this.txRef.compareAndSet(jdbcTransaction, null)) throw throwable;
            log.warn((Object)"Transaction was set to %s unexpectedly", this.txRef.get());
            throw throwable;
        }
        log.warn((Object)"Transaction was set to %s unexpectedly", this.txRef.get());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ClickHouseDatabaseMetaData(this);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.ensureOpen();
        if (this.initialReadOnly != 0) {
            if (!bl) {
                throw SqlExceptionUtils.clientError("Cannot change the setting on a read-only connection");
            }
        } else {
            if (bl) {
                this.clientRequest.set(SETTING_READONLY, Integer.valueOf(2));
            } else {
                this.clientRequest.removeSetting(SETTING_READONLY);
            }
            this.readOnly = bl;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.jdbcConf.useCatalog() ? this.getDatabase() : null;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        if (this.jdbcConf.useCatalog()) {
            this.setCurrentDatabase(string, true);
        } else {
            log.warn((Object)"setCatalog method is no-op. Please either change databaseTerm to catalog or use setSchema method instead", new Object[0]);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpen();
        return this.txIsolation;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.ensureOpen();
        if (0 != n && 1 != n && 2 != n && 4 != n && 8 != n) {
            throw new SQLException("Invalid transaction isolation level: " + n);
        }
        this.txIsolation = this.isTransactionSupported() ? 4 : (this.jdbcConf.isJdbcCompliant() ? n : 0);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureOpen();
        return new HashMap(this.typeMap);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen();
        if (map != null) {
            this.typeMap.putAll(map);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return this.rsHoldability;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.ensureOpen();
        if (n != 2 && n != 1) {
            throw new SQLException("Invalid holdability: " + n);
        }
        this.rsHoldability = n;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot set savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("setSavepoint not implemented");
        }
        JdbcTransaction jdbcTransaction = this.txRef.get();
        if (jdbcTransaction == null && !this.txRef.compareAndSet(null, jdbcTransaction = this.createTransaction())) {
            jdbcTransaction = this.txRef.get();
        }
        return jdbcTransaction.newSavepoint(string);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback to savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        JdbcTransaction jdbcTransaction = this.txRef.get();
        if (jdbcTransaction == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        JdbcSavepoint jdbcSavepoint = (JdbcSavepoint)savepoint;
        jdbcTransaction.logSavepointDetails(log, jdbcSavepoint, "rolled back");
        jdbcTransaction.toSavepoint(jdbcSavepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot release savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        JdbcTransaction jdbcTransaction = this.txRef.get();
        if (jdbcTransaction == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        JdbcSavepoint jdbcSavepoint = (JdbcSavepoint)savepoint;
        jdbcTransaction.logSavepointDetails(log, jdbcSavepoint, "released");
        jdbcTransaction.toSavepoint(jdbcSavepoint);
    }

    @Override
    public ClickHouseStatement createStatement(int n, int n2, int n3) throws SQLException {
        this.ensureOpen();
        return new ClickHouseStatementImpl(this, this.clientRequest.copy(), n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        JdbcParameterizedQuery jdbcParameterizedQuery;
        this.ensureOpen();
        ClickHouseConfig clickHouseConfig = this.clientRequest.getConfig();
        ClickHouseSqlStatement[] clickHouseSqlStatementArray = this.parse(string, clickHouseConfig, this.clientRequest.getSettings());
        if (clickHouseSqlStatementArray.length != 1) {
            throw SqlExceptionUtils.clientError("Prepared statement only supports one query but we got: " + clickHouseSqlStatementArray.length);
        }
        ClickHouseSqlStatement clickHouseSqlStatement = clickHouseSqlStatementArray[0];
        try {
            jdbcParameterizedQuery = this.jdbcConf.useNamedParameter() ? ClickHouseParameterizedQuery.of(this.clientRequest.getConfig(), clickHouseSqlStatement.getSQL()) : JdbcParameterizedQuery.of(clickHouseConfig, clickHouseSqlStatement.getSQL());
        }
        catch (RuntimeException runtimeException) {
            throw SqlExceptionUtils.clientError(runtimeException);
        }
        AbstractPreparedStatement abstractPreparedStatement = null;
        if (jdbcParameterizedQuery.hasParameter()) {
            if (clickHouseSqlStatement.hasTempTable() || clickHouseSqlStatement.hasInput()) {
                throw SqlExceptionUtils.clientError("External table, input function, and query parameter cannot be used together in PreparedStatement.");
            }
            if (clickHouseSqlStatement.getStatementType() == StatementType.INSERT && !clickHouseSqlStatement.containsKeyword("SELECT") && clickHouseSqlStatement.hasValues() && (!clickHouseSqlStatement.hasFormat() || this.clientRequest.getFormat().name().equals(clickHouseSqlStatement.getFormat()))) {
                String string2 = clickHouseSqlStatement.getSQL();
                boolean bl = false;
                Integer n4 = clickHouseSqlStatement.getPositions().get("ValuesStart");
                if (n4 != null) {
                    bl = true;
                    int n5 = clickHouseSqlStatement.getPositions().get("ValuesEnd");
                    for (int i = n4 + 1; i < n5; ++i) {
                        char c = string2.charAt(i);
                        if (c == '?' || c == ',' || Character.isWhitespace(c)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    abstractPreparedStatement = new InputBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.write().query(string2.substring(0, clickHouseSqlStatement.getStartPosition("VALUES")), this.newQueryId()), this.getTableColumns(clickHouseSqlStatement.getDatabase(), clickHouseSqlStatement.getTable(), clickHouseSqlStatement.getContentBetweenKeywords("ColumnsStart", "ColumnsEnd")), n, n2, n3);
                }
            }
        } else if (clickHouseSqlStatement.hasTempTable()) {
            abstractPreparedStatement = new TableBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.copy().query(clickHouseSqlStatement.getSQL(), this.newQueryId()), clickHouseSqlStatement, n, n2, n3);
        } else if (clickHouseSqlStatement.getStatementType() == StatementType.INSERT) {
            if (!ClickHouseChecker.isNullOrBlank(clickHouseSqlStatement.getInput())) {
                ClickHouseRequest.Mutation mutation = this.clientRequest.write();
                if (clickHouseSqlStatement.hasFormat()) {
                    mutation.format(ClickHouseFormat.valueOf(clickHouseSqlStatement.getFormat()));
                }
                abstractPreparedStatement = new InputBasedPreparedStatement(this, (ClickHouseRequest<?>)mutation.query(clickHouseSqlStatement.getSQL(), this.newQueryId()), ClickHouseColumn.parse(clickHouseSqlStatement.getInput()), n, n2, n3);
            } else if (!clickHouseSqlStatement.containsKeyword("SELECT") && !clickHouseSqlStatement.hasValues()) {
                abstractPreparedStatement = clickHouseSqlStatement.hasFormat() ? new StreamBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.write().query(clickHouseSqlStatement.getSQL(), this.newQueryId()), clickHouseSqlStatement, n, n2, n3) : new InputBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.write().query(clickHouseSqlStatement.getSQL(), this.newQueryId()), this.getTableColumns(clickHouseSqlStatement.getDatabase(), clickHouseSqlStatement.getTable(), clickHouseSqlStatement.getContentBetweenKeywords("ColumnsStart", "ColumnsEnd")), n, n2, n3);
            }
        }
        return abstractPreparedStatement != null ? abstractPreparedStatement : new SqlBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.copy().query(jdbcParameterizedQuery, this.newQueryId()), clickHouseSqlStatementArray[0], n, n2, n3);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureOpen();
        return this.createClob();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        n = n == 0 ? this.clientRequest.getConfig().getConnectionTimeout() : (int)TimeUnit.SECONDS.toMillis(n);
        if (this.isClosed()) {
            return false;
        }
        return this.client.ping(this.clientRequest.getServer(), n);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException sQLException) {
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            hashMap.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            hashMap.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(sQLException.getMessage(), hashMap);
        }
        if ("ApplicationName".equals(string)) {
            if (ClickHouseChecker.isNullOrBlank(string2)) {
                this.clientRequest.removeOption(ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option(ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)string2));
            }
        } else if ("CustomHttpHeaders".equals(string)) {
            if (ClickHouseChecker.isNullOrBlank(string2)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)string2));
            }
        } else if ("CustomHttpParameters".equals(string)) {
            if (ClickHouseChecker.isNullOrBlank(string2)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)string2));
            }
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.ensureOpen();
        ClickHouseConfig clickHouseConfig = this.clientRequest.getConfig();
        String string2 = null;
        if ("ApplicationName".equals(string)) {
            string2 = clickHouseConfig.getClientName();
        } else if ("CustomHttpHeaders".equals(string)) {
            string2 = clickHouseConfig.getStrOption(ClickHouseHttpOption.CUSTOM_HEADERS);
        } else if ("CustomHttpParameters".equals(string)) {
            string2 = clickHouseConfig.getStrOption(ClickHouseHttpOption.CUSTOM_PARAMS);
        }
        return string2;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        ClickHouseConfig clickHouseConfig = this.clientRequest.getConfig();
        Properties properties = new Properties();
        properties.setProperty("ApplicationName", clickHouseConfig.getClientName());
        properties.setProperty("CustomHttpHeaders", clickHouseConfig.getStrOption(ClickHouseHttpOption.CUSTOM_HEADERS));
        properties.setProperty("CustomHttpParameters", clickHouseConfig.getStrOption(ClickHouseHttpOption.CUSTOM_PARAMS));
        return properties;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException sQLException) {
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            hashMap.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            hashMap.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(sQLException.getMessage(), hashMap);
        }
        if (properties != null) {
            String string = properties.getProperty("ApplicationName");
            if (ClickHouseChecker.isNullOrBlank(string)) {
                this.clientRequest.removeOption(ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option(ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)string));
            }
            string = properties.getProperty("CustomHttpHeaders");
            if (ClickHouseChecker.isNullOrBlank(string)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)string));
            }
            string = properties.getProperty("CustomHttpParameters");
            if (ClickHouseChecker.isNullOrBlank(string)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)string));
            }
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return this.jdbcConf.useSchema() ? this.getDatabase() : null;
    }

    @Override
    public void setSchema(String string) throws SQLException {
        if (this.jdbcConf.useSchema()) {
            this.setCurrentDatabase(string, true);
        } else {
            log.warn((Object)"setSchema method is no-op. Please either change databaseTerm to schema or use setCatalog method instead", new Object[0]);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        executor.execute(() -> {
            try {
                this.client.close();
            }
            finally {
                this.closed = true;
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.ensureOpen();
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        if (n < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        executor.execute(() -> {
            this.networkTimeout = n;
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureOpen();
        return this.networkTimeout;
    }

    @Override
    public ClickHouseConfig getConfig() {
        return this.clientRequest.getConfig();
    }

    @Override
    public boolean allowCustomSetting() {
        return this.initialReadOnly != 1;
    }

    @Override
    public String getCurrentDatabase() {
        return this.database;
    }

    @Override
    public void setCurrentDatabase(String string, boolean bl) throws SQLException {
        block20: {
            this.ensureOpen();
            if (string == null || string.isEmpty()) {
                throw new SQLException("Non-empty database name is required", "3F000");
            }
            this.clientRequest.use(string);
            if (bl) {
                try (ClickHouseResponse clickHouseResponse = ((ClickHouseRequest)this.clientRequest.query("select 1")).executeAndWait();){
                    this.database = string;
                    break block20;
                }
                catch (ClickHouseException clickHouseException) {
                    throw SqlExceptionUtils.handle(clickHouseException);
                }
                finally {
                    if (!string.equals(this.database)) {
                        this.clientRequest.use(this.database);
                    }
                }
            }
            this.database = string;
        }
    }

    @Override
    public String getCurrentUser() {
        return this.user;
    }

    @Override
    public Calendar getDefaultCalendar() {
        return this.defaultCalendar;
    }

    @Override
    public Optional<TimeZone> getEffectiveTimeZone() {
        return this.clientTimeZone;
    }

    @Override
    public TimeZone getJvmTimeZone() {
        return this.jvmTimeZone;
    }

    @Override
    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    @Override
    public ClickHouseVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public ClickHouseTransaction getTransaction() {
        return this.clientRequest.getTransaction();
    }

    @Override
    public URI getUri() {
        return this.clientRequest.getServer().toUri("jdbc:clickhouse:");
    }

    @Override
    public JdbcConfig getJdbcConfig() {
        return this.jdbcConf;
    }

    @Override
    public long getMaxInsertBlockSize() {
        return this.initialMaxInsertBlockSize;
    }

    @Override
    public boolean isTransactionSupported() {
        return this.jdbcConf.isTransactionSupported() && this.initialNonTxQuerySupport >= 0 && !ClickHouseChecker.isNullOrEmpty(this.initialTxCommitWaitMode);
    }

    @Override
    public boolean isImplicitTransactionSupported() {
        return this.jdbcConf.isTransactionSupported() && this.initialImplicitTx >= 0;
    }

    @Override
    public String newQueryId() {
        String string = this.clientRequest.getManager().createQueryId();
        JdbcTransaction jdbcTransaction = this.txRef.get();
        return jdbcTransaction != null ? jdbcTransaction.newQuery(string) : string;
    }

    @Override
    public ClickHouseSqlStatement[] parse(String string, ClickHouseConfig clickHouseConfig, Map<String, Serializable> map) {
        JdbcParseHandler jdbcParseHandler = null;
        if (this.jdbcConf.isJdbcCompliant()) {
            boolean bl = this.initialDeleteSupport > 1;
            boolean bl2 = false;
            if (map != null) {
                Serializable serializable = map.get(SETTING_LW_DELETE);
                if (!bl && (serializable == null ? this.initialDeleteSupport == 1 : (Boolean)((Object)ClickHouseOption.fromString(serializable.toString(), Boolean.class)) != false)) {
                    bl = true;
                }
            }
            jdbcParseHandler = JdbcParseHandler.getInstance(bl, bl2, this.jdbcConf.useLocalFile());
        } else if (this.jdbcConf.useLocalFile()) {
            jdbcParseHandler = JdbcParseHandler.getInstance(false, false, true);
        }
        return ClickHouseSqlParser.parse(string, clickHouseConfig != null ? clickHouseConfig : this.clientRequest.getConfig(), jdbcParseHandler);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz == ClickHouseClient.class || clazz == ClickHouseRequest.class || super.isWrapperFor(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz == ClickHouseClient.class) {
            return clazz.cast(this.client);
        }
        if (clazz == ClickHouseRequest.class) {
            return clazz.cast(this.clientRequest);
        }
        return super.unwrap(clazz);
    }
}

