/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataProcessor;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseParameterMetaData;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class InputBasedPreparedStatement
extends AbstractPreparedStatement
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(InputBasedPreparedStatement.class);
    private final Calendar defaultCalendar;
    private final ZoneId timeZoneForDate;
    private final ZoneId timeZoneForTs;
    private final ClickHouseColumn[] columns;
    private final ClickHouseValue[] values;
    private final ClickHouseParameterMetaData paramMetaData;
    private final boolean[] flags;
    private int counter;
    private ClickHousePipedOutputStream stream;

    protected InputBasedPreparedStatement(ClickHouseConnectionImpl clickHouseConnectionImpl, ClickHouseRequest<?> clickHouseRequest, List<ClickHouseColumn> list, int n, int n2, int n3) throws SQLException {
        super(clickHouseConnectionImpl, clickHouseRequest, n, n2, n3);
        if (list == null) {
            throw SqlExceptionUtils.clientError("Non-null column list is required");
        }
        ClickHouseConfig clickHouseConfig = this.getConfig();
        this.defaultCalendar = clickHouseConnectionImpl.getDefaultCalendar();
        this.timeZoneForTs = clickHouseConfig.getUseTimeZone().toZoneId();
        this.timeZoneForDate = clickHouseConfig.isUseServerTimeZoneForDates() ? this.timeZoneForTs : null;
        int n4 = list.size();
        this.columns = new ClickHouseColumn[n4];
        this.values = new ClickHouseValue[n4];
        ArrayList<ClickHouseColumn> arrayList = new ArrayList<ClickHouseColumn>(n4);
        int n5 = 0;
        Iterator<ClickHouseColumn> iterator = list.iterator();
        while (iterator.hasNext()) {
            ClickHouseColumn clickHouseColumn;
            this.columns[n5] = clickHouseColumn = iterator.next();
            this.values[n5] = clickHouseColumn.newValue(clickHouseConfig);
            arrayList.add(clickHouseColumn);
            ++n5;
        }
        this.paramMetaData = new ClickHouseParameterMetaData(Collections.unmodifiableList(arrayList), this.mapper, clickHouseConnectionImpl.getTypeMap());
        this.flags = new boolean[n4];
        this.counter = 0;
        this.stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(clickHouseConfig.getWriteBufferSize(), 0, clickHouseConfig.getSocketTimeout());
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            if (this.flags[i]) continue;
            arrayList.add(String.valueOf(i + 1));
        }
        if (!arrayList.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Missing parameter(s): %s", arrayList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long[] executeAny(boolean bl) throws SQLException {
        this.ensureOpen();
        boolean bl2 = false;
        if (bl) {
            if (this.counter < 1) {
                return ClickHouseValues.EMPTY_LONG_ARRAY;
            }
            bl2 = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        } else {
            try {
                if (this.counter != 0) {
                    throw SqlExceptionUtils.undeterminedExecutionError();
                }
                this.addBatch();
            }
            catch (SQLException sQLException) {
                this.clearBatch();
                throw sQLException;
            }
        }
        long[] lArray = new long[this.counter];
        long l = 0L;
        try {
            this.stream.close();
            l = this.executeInsert(this.getRequest().getStatements(false).get(0), this.stream.getInputStream());
            if (bl && this.getResultSet() != null) {
                throw SqlExceptionUtils.queryInBatchError(lArray);
            }
            if (this.counter == 1) {
                lArray[0] = l;
            } else {
                Arrays.fill(lArray, 1L);
            }
        }
        catch (Exception exception) {
            if (!bl) {
                throw SqlExceptionUtils.handle(exception, new Throwable[0]);
            }
            if (l < 1L) {
                lArray[0] = -3L;
            } else {
                if (l >= (long)this.counter) {
                    l = this.counter;
                }
                int n = (int)l - 1;
                for (int i = 0; i < n; ++i) {
                    lArray[i] = 1L;
                }
                lArray[(int)l] = -3L;
            }
            if (!bl2) {
                throw SqlExceptionUtils.batchUpdateError(exception, lArray);
            }
            log.error((Object)"Failed to execute batch insert of %d records", this.counter + 1, exception);
        }
        finally {
            this.clearBatch();
        }
        return lArray;
    }

    @Override
    protected int getMaxParameterIndex() {
        return this.values.length;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null) {
                throw sQLException;
            }
            throw new SQLException("Query failed", "07000", sQLException.getCause());
        }
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.newEmptyResultSet();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null) {
                throw sQLException;
            }
            throw new SQLException("Update failed", "07000", sQLException.getCause());
        }
        long l = this.getLargeUpdateCount();
        return l > 0L ? l : 0L;
    }

    @Override
    public void setByte(int n, byte by2) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(by2);
        this.flags[n2] = true;
    }

    @Override
    public void setShort(int n, short s2) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(s2);
        this.flags[n2] = true;
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.ensureOpen();
        int n3 = this.toArrayIndex(n);
        this.values[n3].update(n2);
        this.flags[n3] = true;
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(l);
        this.flags[n2] = true;
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(f);
        this.flags[n2] = true;
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(d);
        this.flags[n2] = true;
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(bigDecimal);
        this.flags[n2] = true;
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(string);
        this.flags[n2] = true;
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(byArray);
        this.flags[n2] = true;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            this.flags[i] = false;
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        this.values[n2].update(object);
        this.flags[n2] = true;
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.ensureOpen();
        int n4 = this.toArrayIndex(n);
        this.values[n4].update(object);
        this.flags[n4] = true;
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null) {
                throw sQLException;
            }
            throw new SQLException("Execution failed", "07000", sQLException.getCause());
        }
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        ClickHouseDataProcessor clickHouseDataProcessor = this.getDataProcessor(this.stream, null, this.columns);
        int n = this.getNullAsDefault();
        int n2 = this.values.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.flags[i]) {
                throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Missing value for parameter #%d [%s]", i + 1, this.columns[i]));
            }
            ClickHouseColumn serializable = this.columns[i];
            ClickHouseValue clickHouseValue = this.values[i];
            if (serializable.isNestedType() || serializable.isNullable() || clickHouseValue != null && !clickHouseValue.isNullOrEmpty()) continue;
            if (n > 1 && clickHouseValue != null) {
                clickHouseValue.resetToDefault();
                continue;
            }
            if (n >= 1) continue;
            if (ClickHouseConnectionImpl.upsertColumnsMap.containsKey(serializable.getColumnName())) {
                log.info((Object)ClickHouseUtils.format("Cannot set null to non-nullable column #%d [%s]", i + 1, serializable), new Object[0]);
                continue;
            }
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Cannot set null to non-nullable column #%d [%s]", i + 1, serializable));
        }
        for (ClickHouseValue clickHouseValue : this.values) {
            try {
                clickHouseDataProcessor.write(clickHouseValue);
            }
            catch (IOException iOException) {
                throw SqlExceptionUtils.handle(iOException, new Throwable[0]);
            }
        }
        ++this.counter;
        this.clearParameters();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        try {
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.counter = 0;
        ClickHouseConfig clickHouseConfig = this.getConfig();
        this.stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(clickHouseConfig.getWriteBufferSize(), 0, clickHouseConfig.getSocketTimeout());
        this.resetDataProcessor();
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        Object object = array != null ? array.getArray() : array;
        this.values[n2].update(object);
        this.flags[n2] = true;
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        if (date != null) {
            LocalDate localDate;
            if (calendar == null) {
                calendar = this.defaultCalendar;
            }
            ZoneId zoneId = calendar.getTimeZone().toZoneId();
            if (this.timeZoneForDate == null || zoneId.equals(this.timeZoneForDate)) {
                localDate = date.toLocalDate();
            } else {
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.setTime(date);
                localDate = calendar2.toInstant().atZone(zoneId).withZoneSameInstant(this.timeZoneForDate).toLocalDate();
            }
            this.values[n2].update(localDate);
        } else {
            this.values[n2].resetToNullOrEmpty();
        }
        this.flags[n2] = true;
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        if (time != null) {
            LocalTime localTime;
            ZoneId zoneId;
            if (calendar == null) {
                calendar = this.defaultCalendar;
            }
            if ((zoneId = calendar.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
                localTime = time.toLocalTime();
            } else {
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.setTime(time);
                localTime = calendar2.toInstant().atZone(zoneId).withZoneSameInstant(this.timeZoneForTs).toLocalTime();
            }
            this.values[n2].update(localTime);
        } else {
            this.values[n2].resetToNullOrEmpty();
        }
        this.flags[n2] = true;
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.ensureOpen();
        int n2 = this.toArrayIndex(n);
        if (timestamp != null) {
            LocalDateTime localDateTime;
            ZoneId zoneId;
            if (calendar == null) {
                calendar = this.defaultCalendar;
            }
            if ((zoneId = calendar.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
                localDateTime = timestamp.toLocalDateTime();
            } else {
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.setTime(timestamp);
                localDateTime = calendar2.toInstant().atZone(zoneId).withNano(timestamp.getNanos()).withZoneSameInstant(this.timeZoneForTs).toLocalDateTime();
            }
            this.values[n2].update(localDateTime);
        } else {
            this.values[n2].resetToNullOrEmpty();
        }
        this.flags[n2] = true;
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.ensureOpen();
        int n3 = this.toArrayIndex(n);
        this.values[n3].resetToNullOrEmpty();
        this.flags[n3] = true;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.paramMetaData;
    }
}

