/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.ffi.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.ffi.CallingConvention;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.ffi.annotations.IgnoreError;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.ffi.annotations.SaveError;

public final class NativeFunction {
    private final Method method;
    private final Collection<Annotation> annotations;
    private final boolean saveError;
    private final boolean ignoreError;
    private final CallingConvention callingConvention;

    public NativeFunction(Method method, CallingConvention callingConvention) {
        this.method = method;
        this.annotations = Collections.unmodifiableCollection(Arrays.asList(method.getAnnotations()));
        this.saveError = NativeFunction.hasSaveError(method);
        this.ignoreError = NativeFunction.hasIgnoreError(method);
        this.callingConvention = callingConvention;
    }

    public Collection<Annotation> annotations() {
        return this.annotations;
    }

    public CallingConvention convention() {
        return this.callingConvention;
    }

    public String name() {
        return this.method.getName();
    }

    public boolean isErrnoRequired() {
        return !this.ignoreError || this.saveError;
    }

    public boolean hasSaveError() {
        return this.saveError;
    }

    public boolean hasIgnoreError() {
        return this.ignoreError;
    }

    public Method getMethod() {
        return this.method;
    }

    public static boolean hasSaveError(Method method) {
        return method.getAnnotation(SaveError.class) != null;
    }

    public static boolean hasIgnoreError(Method method) {
        return method.getAnnotation(IgnoreError.class) != null;
    }
}

