/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Confstr;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Pathconf;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Sysconf;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.ffi.Memory;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.ffi.Pointer;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.ffi.mapper.FromNativeContext;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.BaseNativePOSIX;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.FileStat;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.FreeBSDFileStat;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.FreeBSDFileStat12;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.FreeBSDMsgHdr;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.FreeBSDPasswd;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.FreeBSDSocketMacros;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.LibCProvider;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.MsgHdr;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.NativeTimes;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.POSIXHandler;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.SocketMacros;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.posix.Times;

final class FreeBSDPOSIX
extends BaseNativePOSIX {
    private final int freebsdVersion;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new FreeBSDPasswd((Pointer)arg) : null;
        }
    };

    FreeBSDPOSIX(LibCProvider libc, POSIXHandler handler) {
        super(libc, handler);
        int parsed_version = 0;
        try {
            Process p = Runtime.getRuntime().exec("/bin/freebsd-version -u");
            String version = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
            if (p.waitFor() == 0 && version != null) {
                NumberFormat fmt = NumberFormat.getIntegerInstance();
                fmt.setGroupingUsed(false);
                parsed_version = fmt.parse(version, new ParsePosition(0)).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.freebsdVersion = parsed_version;
    }

    @Override
    public FileStat allocateStat() {
        if (this.freebsdVersion >= 12) {
            return new FreeBSDFileStat12(this);
        }
        return new FreeBSDFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return new FreeBSDMsgHdr(this);
    }

    @Override
    public SocketMacros socketMacros() {
        return FreeBSDSocketMacros.INSTANCE;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public int confstr(Confstr name, ByteBuffer buf, int len) {
        return this.libc().confstr(name, buf, len);
    }

    @Override
    public int fpathconf(int fd, Pathconf name) {
        return this.libc().fpathconf(fd, name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer allocatePosixSpawnFileActions() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public Pointer allocatePosixSpawnattr() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }
}

