/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketAddress;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.ProtocolFamily;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.unixsocket.SockAddrUnix;

public class UnixSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = 4821337010221569096L;
    private transient SockAddrUnix address = SockAddrUnix.create();

    UnixSocketAddress() {
        this.address.setFamily(ProtocolFamily.PF_UNIX);
    }

    public UnixSocketAddress(File path) {
        this.address.setFamily(ProtocolFamily.PF_UNIX);
        this.address.setPath(path.getPath());
    }

    public UnixSocketAddress(String path) {
        this.address.setFamily(ProtocolFamily.PF_UNIX);
        this.address.setPath(path);
    }

    SockAddrUnix getStruct() {
        return this.address;
    }

    int length() {
        return this.address.length();
    }

    public String path() {
        return this.address.getPath();
    }

    public String humanReadablePath() {
        String ret = this.path();
        if (ret.indexOf(0) == 0) {
            return ret.replace('\u0000', '@');
        }
        return ret;
    }

    public String toString() {
        return "[family=" + this.address.getFamily() + " path=" + this.humanReadablePath() + "]";
    }

    public boolean equals(Object _other) {
        if (!(_other instanceof UnixSocketAddress)) {
            return false;
        }
        UnixSocketAddress other = (UnixSocketAddress)_other;
        return this.address.getFamily() == other.address.getFamily() && this.path().equals(other.path());
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.defaultWriteObject();
        o.writeObject(this.path());
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
        String path = (String)o.readObject();
        if (null == this.address) {
            this.address = SockAddrUnix.create();
        }
        this.address.setPath(path);
        this.address.setFamily(ProtocolFamily.PF_UNIX);
    }
}

