/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.commons.conf;

import java.io.Serializable;
import java.util.List;
import org.byted.security.zti.jwt.shaded.com.bytedance.commons.conf.ParseConf;

public class Conf
implements Serializable {
    private ParseConf parseConf;

    public Conf(String fileName) {
        this.parseConf = new ParseConf(fileName);
    }

    public String getService(String name) {
        return name.startsWith("redis_") ? "toutiao.redis." + name.substring(name.indexOf("redis_")) : (name.startsWith("memcache_") ? "toutiao.memcache." + name.substring(name.indexOf("memcache_")) : "");
    }

    public String getPsm(String name) {
        return System.getenv("TCE_PSM") == null ? (System.getenv("SVC_NAME") == null ? (System.getenv("PSM") == null ? name : System.getenv("PSM")) : System.getenv("SVC_NAME")) : System.getenv("TCE_PSM");
    }

    public String getValuesFromConf(String confPath, String cluster) {
        this.parseConf = new ParseConf(confPath);
        String cluserInfo = this.parseConf.getString(cluster);
        return cluserInfo;
    }

    public String getServers(String cluster) {
        String value = this.parseConf.getString(cluster);
        if (value == null) {
            return null;
        }
        if (value.contains("consul")) {
            value = this.parseConf.getValueFromConsul(value);
        }
        return value;
    }

    public List<String> getList(String name) {
        return this.parseConf.getList(name);
    }

    public List<String> getListOrElse(String name, List<String> defaultList) {
        List<String> res = this.parseConf.getList(name);
        if (res == null) {
            return defaultList;
        }
        return res;
    }

    public String getString(String name) {
        return this.parseConf.getString(name);
    }

    public String getStringOrElse(String name, String defaultString) {
        String res = this.parseConf.getString(name);
        if (res == null) {
            return defaultString;
        }
        return res;
    }

    public int getInt(String name) {
        return this.parseConf.getInt(name);
    }

    public int getIntOrElse(String name, int defaultInt) {
        int res = this.parseConf.getInt(name);
        if (res == -1) {
            return defaultInt;
        }
        return res;
    }

    public long getLong(String name) {
        return this.parseConf.getLong(name);
    }

    public long getLongOrElse(String name, long defaultLong) {
        long res = this.parseConf.getLong(name);
        if (res == -1L) {
            return defaultLong;
        }
        return res;
    }

    public boolean getBoolean(String name) {
        return this.parseConf.getBoolean(name);
    }

    public boolean getBooleanOrElse(String name, boolean defaultBoolean) {
        boolean res = this.parseConf.getBoolean(name);
        return res ? true : defaultBoolean;
    }
}

