/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul.RegisterCheck;
import org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul.RegisterParam;
import org.byted.security.zti.jwt.shaded.com.bytedance.commons.consul.ServiceNode;
import org.byted.security.zti.jwt.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.byted.security.zti.jwt.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.byted.security.zti.jwt.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.byted.security.zti.jwt.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.byted.security.zti.jwt.shaded.okhttp3.MediaType;
import org.byted.security.zti.jwt.shaded.okhttp3.OkHttpClient;
import org.byted.security.zti.jwt.shaded.okhttp3.Request;
import org.byted.security.zti.jwt.shaded.okhttp3.RequestBody;
import org.byted.security.zti.jwt.shaded.okhttp3.Response;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class Discovery {
    private static final Logger logger = LoggerFactory.getLogger(Discovery.class);
    private String agentIp;
    private final String agentPort;
    private final ObjectMapper objectMapper;
    public String dc;
    public String domain;
    private boolean registerDualStack;
    private String lookupAddrFamily;
    private String lookupDualStackUnique;
    private final Map<String, String> emptyMap = new HashMap<String, String>();
    private static final OkHttpClient client = new OkHttpClient();
    private static final String defaultHost = "127.0.0.1";
    private static final String defaultPort = "2280";

    public Discovery() {
        this(defaultHost, defaultPort);
    }

    public Discovery(String agentIp, String agentPort) {
        Map<String, String> map = System.getenv();
        this.agentIp = map.getOrDefault("CONSUL_HTTP_HOST", agentIp);
        this.agentPort = map.getOrDefault("CONSUL_HTTP_PORT", agentPort);
        this.objectMapper = new ObjectMapper();
        this.dc = "";
        this.domain = "";
        this.overrideAddr();
        this.getLocation();
    }

    private void overrideAddr() {
        if (this.agentIp.equals(defaultHost)) {
            String consulHttpHost = System.getenv("CONSUL_HTTP_HOST");
            String tceHostIp = System.getenv("TCE_HOST_IP");
            String myHostIp = System.getenv("MY_HOST_IP");
            String myHostIpv6 = System.getenv("MY_HOST_IPV6");
            if (consulHttpHost != null && !consulHttpHost.equals("")) {
                this.agentIp = consulHttpHost;
            } else if (tceHostIp != null && !tceHostIp.equals("")) {
                this.agentIp = tceHostIp;
            } else if (myHostIp != null && !myHostIp.equals("")) {
                this.agentIp = myHostIp;
            } else if (myHostIpv6 != null && !myHostIpv6.equals("")) {
                this.agentIp = myHostIpv6;
            }
        }
    }

    public String GetAgentHost() {
        return this.agentIp;
    }

    public void SetRegisterDualStack(boolean dualstack) {
        this.setRegisterDualStack(dualstack);
    }

    public synchronized void setRegisterDualStack(boolean dualstack) {
        this.registerDualStack = dualstack;
    }

    public void SetLookupAddrFamily(String addrfam) {
        this.setLookupAddrFamily(addrfam);
    }

    public synchronized void setLookupAddrFamily(String addrfam) {
        this.lookupAddrFamily = addrfam;
    }

    public void SetLookupDualStackUnique(String unique) {
        this.setLookupDualStackUnique(unique);
    }

    public synchronized void setLookupDualStackUnique(String unique) {
        this.lookupDualStackUnique = unique;
    }

    private void getLocation() {
        try (Response response = this.getResponse("/v1/agent/self", this.emptyMap, "GET", "");){
            String body;
            ObjectNode node;
            if (response != null && response.code() == 200 && (node = this.objectMapper.readValue(body = response.body().string(), ObjectNode.class)).has("Config")) {
                String config = node.get("Config").toString();
                ObjectNode node2 = this.objectMapper.readValue(config, ObjectNode.class);
                this.dc = node2.get("Datacenter").toString();
                this.domain = node2.get("Domain").toString();
                this.dc = this.dc.substring(1, this.dc.length() - 1);
                this.domain = this.domain.substring(1, this.domain.length() - 1);
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
    }

    public boolean pass(String checkId) {
        try (Response response = this.getResponse("/v1/agent/check/pass/" + checkId, this.emptyMap, "GET", "");){
            if (response != null && response.code() == 200) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public double announce(String name, int port, int ttl, Map<String, String> tags) {
        return this.announce(name, "", port, ttl, tags);
    }

    public double announce(String name, String addr, int port, int ttl, Map<String, String> tags) {
        return this.register(this.defineService(name, addr, port, ttl, tags));
    }

    public RegisterParam defineService(String name, String addr, int port, int ttl, Map<String, String> tags) {
        String serviceId = name + "-" + String.valueOf(port);
        RegisterParam registerParam = new RegisterParam();
        registerParam.setId(serviceId);
        registerParam.setName(name);
        if (addr != null && !addr.isEmpty()) {
            registerParam.setAddress(addr);
        }
        registerParam.setPort(port);
        ArrayList<String> tagsParm = new ArrayList<String>();
        if (tags != null) {
            for (String key : tags.keySet()) {
                tagsParm.add(String.format("%s:%s", key, tags.get(key)));
            }
        }
        registerParam.setTags(tagsParm);
        RegisterCheck registerCheck = new RegisterCheck();
        registerCheck.setTtl(ttl);
        registerParam.setCheck(registerCheck);
        return registerParam;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double register(RegisterParam registerParam) {
        Throwable throwable;
        Response response;
        block16: {
            String serviceId = registerParam.getId();
            int ttl = registerParam.getCheck().getTtlInt();
            String url = "/v1/agent/service/register";
            if (this.registerDualStack) {
                url = url + "?dual-stack";
            }
            Random r = new Random();
            try {
                double d;
                block17: {
                    response = this.getResponse(url, this.emptyMap, "PUT", this.objectMapper.writeValueAsString(registerParam));
                    throwable = null;
                    try {
                        if (response == null || response.code() != 200 || !this.pass(String.format("service:%s", serviceId))) break block16;
                        logger.info(String.format("Register service %s success", serviceId));
                        d = Math.max(0.5, r.nextDouble() * 1.0 * (double)ttl);
                        if (response == null) return d;
                        if (throwable == null) break block17;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (response == null) throw throwable5;
                            if (throwable == null) {
                                response.close();
                                throw throwable5;
                            }
                            try {
                                response.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                    }
                    try {
                        response.close();
                        return d;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return d;
                    }
                }
                response.close();
                return d;
            }
            catch (JsonProcessingException e) {
                logger.error(e.toString());
                return -1.0;
            }
        }
        if (response == null) return -1.0;
        if (throwable == null) {
            response.close();
            return -1.0;
        }
        try {
            response.close();
            return -1.0;
        }
        catch (Throwable throwable3) {
            throwable.addSuppressed(throwable3);
            return -1.0;
        }
    }

    public boolean deregister(String name, int port) {
        String serviceId = name + "-" + port;
        try (Response response = this.getResponse("/v1/agent/service/deregister/" + serviceId, this.emptyMap, "PUT", "");){
            if (response != null && response.isSuccessful()) {
                logger.info("Deregister service {} success", (Object)serviceId);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private List<ServiceNode> lookUp(String name) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("name", name);
        if (this.lookupAddrFamily != null && !this.lookupAddrFamily.isEmpty()) {
            param.put("addr-family", this.lookupAddrFamily);
            if (this.lookupAddrFamily.equals("dual-stack") && this.lookupDualStackUnique != null && !this.lookupDualStackUnique.isEmpty()) {
                param.put("unique", this.lookupDualStackUnique);
            }
        }
        return this.lookupWithParam(param);
    }

    private List<ServiceNode> lookupWithParam(Map<String, String> param) {
        List<ServiceNode> nameInfo = new ArrayList<ServiceNode>();
        try (Response response = this.getResponse("/v1/lookup/name", param, "GET", "");){
            if (response != null && response.code() == 200) {
                String body = response.body().string();
                nameInfo = this.objectMapper.readValue(body, new TypeReference<List<ServiceNode>>(){});
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        return nameInfo;
    }

    public List<ServiceNode> translateOne(String name) {
        return this.lookUp(name);
    }

    public List<ServiceNode> lookupName(String name) {
        Map<String, String> map = System.getenv();
        String ipv4 = map.containsKey("BYTED_HOST_IP") ? map.get("BYTED_HOST_IP").toString() : "";
        String ipv6 = map.containsKey("BYTED_HOST_IPV6") ? map.get("BYTED_HOST_IPV6").toString() : "";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("name", name);
        if (!ipv4.isEmpty() && !ipv6.isEmpty()) {
            param.put("addr-family", "dual-stack");
            param.put("unique", "v6");
        } else if (!ipv6.isEmpty()) {
            param.put("addr-family", "v6");
        } else if (!ipv4.isEmpty()) {
            param.put("addr-family", "v4");
        }
        return this.lookupWithParam(param);
    }

    public String translateUri(String uri) {
        String res = "";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uri", uri);
        try (Response response = this.getResponse("/v1/lookup/uri", param, "GET", "");){
            if (response != null && response.code() == 200) {
                String body = response.body().string();
                res = body.substring(1, body.length() - 1);
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        return res;
    }

    private Response getResponse(String path, Map<String, String> params, String type, String postBody) {
        String url;
        Response res = null;
        StringBuilder paramUrl = new StringBuilder();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0) {
                paramUrl.append(String.format("%s=%s", key, params.get(key)));
            } else {
                paramUrl.append(String.format("&%s=%s", key, params.get(key)));
            }
            ++i;
        }
        String ip = this.agentIp;
        if (this.agentIp.contains(":")) {
            ip = "[" + this.agentIp + "]";
        }
        String string = url = paramUrl.toString().equals("") ? "http://" + ip + ":" + this.agentPort + path : "http://" + ip + ":" + this.agentPort + path + "?" + paramUrl.toString();
        if (type.equals("GET")) {
            res = this.sendGet(url);
        } else if (type.equals("POST")) {
            res = this.sendPost(url, postBody);
        } else if (type.equals("PUT")) {
            res = this.sendPut(url, postBody);
        }
        return res;
    }

    private Response sendGet(String url) {
        Request request = new Request.Builder().url(url).build();
        try {
            return client.newCall(request).execute();
        }
        catch (IOException e) {
            logger.error(e.toString());
            return null;
        }
    }

    private Response sendPost(String url, String json) {
        MediaType JSON2 = MediaType.parse("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(JSON2, json);
        Request request = new Request.Builder().url(url).post(body).build();
        try {
            return client.newCall(request).execute();
        }
        catch (IOException e) {
            logger.error(e.toString());
            return null;
        }
    }

    private Response sendPut(String url, String json) {
        MediaType JSON2 = MediaType.parse("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(JSON2, json);
        Request request = new Request.Builder().url(url).put(body).build();
        try {
            return client.newCall(request).execute();
        }
        catch (IOException e) {
            logger.error(e.toString());
            return null;
        }
    }

    public int readTimeoutMillis() {
        return client.readTimeoutMillis();
    }
}

