/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Sock;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsImpl;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsReporter;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.CallTracer;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.LockFreeSlidingWindowReservoir;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.TsStore;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Counter;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Gauge;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Histogram;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.MetricRegistry;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Timer;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public abstract class BytedanceMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(BytedanceMetrics.class);
    private static final int REPORT_PERIOD_SECONDS = 10;
    private static final int DEFAULT_MEASUREMENT_WINDOW_SIZE = 65536;
    private static final String procIdTagKV;
    private static BytedanceMetrics instance;

    public abstract String getPrefix();

    public abstract MetricRegistry getCodahaleRegistry();

    public abstract void shutdown();

    public abstract TsStore createTsStore(String var1) throws IOException;

    public static synchronized void initialize(BytedanceMetrics bytedanceMetrics) {
        if (bytedanceMetrics == null) {
            throw new IllegalArgumentException();
        }
        if (instance != null) {
            LOG.warn("BytedanceMetrics instance already exists, will be replaced. Update global prefix '{}' to '{}'", (Object)instance.getPrefix(), (Object)bytedanceMetrics.getPrefix());
        }
        instance = bytedanceMetrics;
    }

    public static void initialize(String prefix) {
        BytedanceMetrics.initialize(prefix, false);
    }

    public static void initialize(String prefix, boolean useUnixDomainSocket) {
        BytedanceMetrics.initialize(prefix, useUnixDomainSocket, InsertEnv.FALSE, Sock.SOCK_DGRAM);
    }

    public static void initialize(String prefix, InsertEnv insertEnvTag) {
        BytedanceMetrics.initialize(prefix, false, insertEnvTag, Sock.SOCK_DGRAM);
    }

    public static void initialize(String prefix, boolean useUnixDomainSocket, Sock sock) {
        BytedanceMetrics.initialize(prefix, useUnixDomainSocket, InsertEnv.FALSE, sock);
    }

    public static synchronized void initialize(String prefix, boolean useUnixDomainSocket, InsertEnv insertEnvTag, Sock sock) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("prefix is null or empty");
        }
        if (insertEnvTag == null) {
            throw new IllegalArgumentException("insertEnvTag is null");
        }
        Objects.requireNonNull(sock);
        if (instance != null) {
            if (!instance.getPrefix().equals(prefix)) {
                LOG.warn("global prefix already set to {}, can't change to {}", (Object)instance.getPrefix(), (Object)prefix);
            }
            return;
        }
        MetricRegistry registry = new MetricRegistry();
        BytedanceMetricsReporter reporter = BytedanceMetricsReporter.forRegistry(registry).setUnixDomainSocket(useUnixDomainSocket).prefixedWith(prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).setVendorEnv(insertEnvTag.insertEnv()).setSock(sock).build();
        instance = new BytedanceMetricsImpl(prefix, useUnixDomainSocket, registry, reporter);
        reporter.start(10L, TimeUnit.SECONDS);
    }

    public static String getTagKVs(Map<String, String> tagKVs) {
        return BytedanceMetrics.getTagKVs(tagKVs, "");
    }

    public static String getTagKVsWithPID(Map<String, String> tagKVs) {
        return BytedanceMetrics.getTagKVs(tagKVs, procIdTagKV);
    }

    private static String getTagKVs(Map<String, String> tagKVs, String attachTagKV) {
        if (tagKVs == null || tagKVs.isEmpty()) {
            return "{" + attachTagKV + "}";
        }
        StringBuilder str = new StringBuilder(256);
        str.append('{');
        boolean nonFirst = false;
        for (Map.Entry<String, String> tag2 : tagKVs.entrySet()) {
            if (nonFirst) {
                str.append(',');
            }
            nonFirst = true;
            str.append(tag2.getKey()).append('=').append(tag2.getValue());
        }
        if (attachTagKV.length() > 0) {
            if (nonFirst) {
                str.append(',');
            }
            str.append(attachTagKV);
        }
        str.append('}');
        return str.toString();
    }

    public static Timer timer(String name) {
        return BytedanceMetrics.timer(name, 65536);
    }

    public static Timer timerWithPID(String name) {
        return BytedanceMetrics.timerWithPID(name, 65536);
    }

    public static Timer timerWithPID(String name, int windownSize) {
        return BytedanceMetrics.timerWithPID(name, Collections.emptyMap(), windownSize);
    }

    public static Timer timerWithPID(String name, Map<String, String> tagKVs, int windownSize) {
        return BytedanceMetrics.timer(name + BytedanceMetrics.getTagKVsWithPID(tagKVs), windownSize);
    }

    public static Timer timer(String name, int windowSize) {
        return instance.getCodahaleRegistry().timer(name, () -> new Timer(new LockFreeSlidingWindowReservoir(windowSize)));
    }

    public static Counter counter(String name) {
        return instance.getCodahaleRegistry().counter(name);
    }

    public static Counter counterWithPID(String name) {
        return BytedanceMetrics.counterWithPID(name, Collections.emptyMap());
    }

    public static Counter counterWithPID(String name, Map<String, String> tagKVs) {
        return BytedanceMetrics.counter(name + BytedanceMetrics.getTagKVsWithPID(tagKVs));
    }

    public static Histogram histogram(String name) {
        return BytedanceMetrics.histogram(name, 65536);
    }

    public static Histogram histogram(String name, final int windowSize) {
        return instance.getCodahaleRegistry().histogram(name, new MetricRegistry.MetricSupplier<Histogram>(){

            @Override
            public Histogram newMetric() {
                return new Histogram(new LockFreeSlidingWindowReservoir(windowSize));
            }
        });
    }

    public static Gauge gauge(final String name, final Function<Object, Long> compute) {
        assert (instance.getCodahaleRegistry() != null);
        return instance.getCodahaleRegistry().gauge(name, new MetricRegistry.MetricSupplier<Gauge>(){

            @Override
            public Gauge newMetric() {
                return () -> (Long)compute.apply(name);
            }
        });
    }

    public static TsStore ts_store(String name) throws IOException {
        return instance.createTsStore(name);
    }

    public static TsStore tsStoreWithPID(String name) throws IOException {
        return BytedanceMetrics.tsStoreWithPID(name, Collections.emptyMap());
    }

    public static TsStore tsStoreWithPID(String name, Map<String, String> tagKVs) throws IOException {
        return BytedanceMetrics.ts_store(name + BytedanceMetrics.getTagKVsWithPID(tagKVs));
    }

    public static Supplier<CallTracer> callTracer(String name) {
        assert (instance.getCodahaleRegistry() != null);
        Counter throughput = BytedanceMetrics.counter(name + ".throughput");
        Timer latency = BytedanceMetrics.timer(name + ".latency");
        return () -> new CallTracer(throughput, latency);
    }

    public static Supplier<CallTracer> callTracer(String name, String suffix) {
        assert (instance.getCodahaleRegistry() != null);
        Counter throughput = BytedanceMetrics.counter(name + ".throughput" + suffix);
        Timer latency = BytedanceMetrics.timer(name + ".latency" + suffix);
        return () -> new CallTracer(throughput, latency);
    }

    public static boolean remove(String name) {
        return instance.getCodahaleRegistry().remove(name);
    }

    public static MetricRegistry getRegistry() {
        return instance.getCodahaleRegistry();
    }

    public static BytedanceMetricsReporter getReporter() {
        if (instance instanceof BytedanceMetricsImpl) {
            return ((BytedanceMetricsImpl)instance).getMetricReporter();
        }
        return null;
    }

    public static void close() {
        instance.shutdown();
    }

    static {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String processName = runtime.getName();
        procIdTagKV = "pid=" + processName.split("@")[0];
    }

    public static enum InsertEnv {
        TRUE(true),
        FALSE(false);

        private final boolean insertEnv;

        private InsertEnv(boolean insertEnv) {
            this.insertEnv = insertEnv;
        }

        public boolean insertEnv() {
            return this.insertEnv;
        }
    }
}

