/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Sock;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.MetricUtils;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.ParseCache;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.TagParser;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.TsStore;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.MetricsClient;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Counter;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Gauge;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Histogram;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Meter;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Metered;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Metric;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.MetricFilter;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.MetricRegistry;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Reservoir;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.ScheduledReporter;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Snapshot;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Timer;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class BytedanceMetricsReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(BytedanceMetricsReporter.class);
    final MetricsClient client;
    final MetricRegistry registry;
    final ParseCache parserCache;
    private String host;
    private String dc;
    private boolean insertEnvTag;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    protected BytedanceMetricsReporter(MetricRegistry registry, MetricFilter filter2, TimeUnit rateUnit, TimeUnit durationUnit, ParseCache parserCache, MetricsClient client, boolean insertEnvTag) {
        super(registry, "bytedance", filter2, rateUnit, durationUnit);
        this.client = client;
        this.registry = registry;
        this.parserCache = parserCache;
        this.insertEnvTag = insertEnvTag;
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.host = "UNKNOWN";
        }
    }

    synchronized TagParser.ParsedMetricAndTags parse(String m4) {
        TagParser.ParsedMetricAndTags parsed = this.parserCache.get(m4);
        if (parsed == null) {
            parsed = TagParser.parse(m4);
            if (this.insertEnvTag) {
                for (Map.Entry<String, String> entry : MetricUtils.getVendorEnvTags().entrySet()) {
                    parsed.tagKeys.add(entry.getKey());
                    parsed.tagValues.add(entry.getValue());
                }
            }
            this.parserCache.put(m4, parsed);
        }
        return parsed;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            try {
                this.reportGauge(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                LOG.error("Unable to report gauge metrics with key [" + entry.getKey() + "]", e);
            }
        }
        for (Map.Entry<String, Metric> entry : counters.entrySet()) {
            try {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue());
            }
            catch (Exception e) {
                LOG.error("Unable to report counter metrics with key [" + entry.getKey() + "]", e);
            }
        }
        for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
            try {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
            }
            catch (Exception e) {
                LOG.error("Unable to report histgram metrics with key [" + entry.getKey() + "]", e);
            }
        }
        for (Map.Entry<String, Metric> entry : meters.entrySet()) {
            try {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue());
            }
            catch (Exception e) {
                LOG.error("Unable to report metered metrics with key [" + entry.getKey() + "]", e);
            }
        }
        for (Map.Entry<String, Metric> entry : timers.entrySet()) {
            try {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue());
            }
            catch (Exception e) {
                LOG.error("Unable to report timer metrics with key [" + entry.getKey() + "]", e);
            }
        }
        this.parserCache.flushExpired(System.currentTimeMillis());
    }

    public TsStore createTsStore(String name) throws IOException {
        TagParser.ParsedMetricAndTags parsed = this.parse(name);
        String tags = parsed.buildTags();
        if (LOG.isDebugEnabled()) {
            LOG.debug("TsStore {} with tags {} creating", (Object)name, (Object)tags);
        }
        return TsStore.withReport(parsed, this);
    }

    private static long alignTimeStamp(long timestamp) {
        long passed = timestamp % 30L;
        if (passed == 0L) {
            return timestamp;
        }
        return timestamp + 30L - passed;
    }

    public void emitStoreWithTsAndTag(String name, String tags, double value, long timestamp) throws IOException {
        this.client.emitStoreWithTsAndTag(name, value, tags, timestamp);
    }

    private void reportTimer(String name, Timer timer) throws IOException {
        TagParser.ParsedMetricAndTags parsed;
        Snapshot snapshot = timer.getSnapshot();
        try {
            parsed = this.parse(name);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("invalid metrics and tag, {}, dropped", (Object)name);
            return;
        }
        String tags = parsed.buildTags();
        if (snapshot.size() > 0) {
            this.client.emitStoreWithTag(parsed.metricName + ".max", this.format(this.convertDuration(snapshot.getMax())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".avg", this.format(this.convertDuration(snapshot.getMean())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".min", this.format(this.convertDuration(snapshot.getMin())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".stddev", this.format(this.convertDuration(snapshot.getStdDev())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct50", this.format(this.convertDuration(snapshot.getMedian())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct75", this.format(this.convertDuration(snapshot.get75thPercentile())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct90", this.format(this.convertDuration(snapshot.getValue(0.9))), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct95", this.format(this.convertDuration(snapshot.get95thPercentile())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct98", this.format(this.convertDuration(snapshot.get98thPercentile())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct99", this.format(this.convertDuration(snapshot.get99thPercentile())), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct999", this.format(this.convertDuration(snapshot.get999thPercentile())), tags);
        }
        this.reportMetered(name, timer);
    }

    private void reportMetered(String name, Metered meter) throws IOException {
        TagParser.ParsedMetricAndTags parsed;
        try {
            parsed = this.parse(name);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("invalid metrics and tag, {}, dropped", (Object)name);
            return;
        }
        String tags = parsed.buildTags();
        this.client.emitStoreWithTag(parsed.metricName + ".counter", this.format(meter.getCount()), tags);
        this.client.emitStoreWithTag(parsed.metricName + ".m1_rate", this.format(this.convertRate(meter.getOneMinuteRate())), tags);
        this.client.emitStoreWithTag(parsed.metricName + ".m5_rate", this.format(this.convertRate(meter.getFiveMinuteRate())), tags);
        this.client.emitStoreWithTag(parsed.metricName + ".m15_rate", this.format(this.convertRate(meter.getFifteenMinuteRate())), tags);
        this.client.emitStoreWithTag(parsed.metricName + ".mean_rate", this.format(this.convertRate(meter.getMeanRate())), tags);
    }

    private void reportHistogram(String name, Histogram histogram) throws IOException {
        TagParser.ParsedMetricAndTags parsed;
        try {
            parsed = this.parse(name);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("invalid metrics and tag, {}, dropped", (Object)name);
            return;
        }
        String tags = parsed.buildTags();
        Snapshot snapshot = histogram.getSnapshot();
        this.client.emitStoreWithTag(parsed.metricName + ".counter", this.format(histogram.getCount()), tags);
        if (snapshot.size() > 0) {
            this.client.emitStoreWithTag(parsed.metricName + ".max", this.format(snapshot.getMax()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".avg", this.format(snapshot.getMean()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".min", this.format(snapshot.getMin()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".stddev", this.format(snapshot.getStdDev()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct50", this.format(snapshot.getMedian()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct75", this.format(snapshot.get75thPercentile()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct90", this.format(snapshot.getValue(0.9)), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct95", this.format(snapshot.get95thPercentile()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct98", this.format(snapshot.get98thPercentile()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct99", this.format(snapshot.get99thPercentile()), tags);
            this.client.emitStoreWithTag(parsed.metricName + ".pct999", this.format(snapshot.get999thPercentile()), tags);
        }
    }

    private void reportCounter(String name, Counter counter) throws IOException {
        TagParser.ParsedMetricAndTags parsed;
        try {
            parsed = this.parse(name);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("invalid metrics and tag, {}, dropped", (Object)name);
            return;
        }
        String tags = parsed.buildTags();
        this.client.emitStoreWithTag(parsed.metricName, this.format(counter.getCount()), tags);
    }

    private void reportGauge(String name, Gauge gauge) throws IOException {
        TagParser.ParsedMetricAndTags parsed;
        try {
            parsed = this.parse(name);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("invalid metrics and tag, {}, dropped", (Object)name);
            return;
        }
        String tags = parsed.buildTags();
        double value = this.format(gauge.getValue());
        this.client.emitStoreWithTag(parsed.metricName, value, tags);
    }

    private double format(long n) {
        return n;
    }

    private double format(double v) {
        return v;
    }

    private double format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        return 0.0;
    }

    public Timer timer(String name) {
        return this.timer(name, new SlidingTimeWindowArrayReservoir(30L, TimeUnit.SECONDS));
    }

    public Timer timer(String name, Reservoir reservoir) {
        Timer t2 = new Timer(reservoir);
        this.registry.register(name, t2);
        return t2;
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String producer_name;
        private String client_dc;
        private long parseCacheTTLMs;
        private int parseCacheCapacity;
        private boolean useUnixDomainSocket;
        private MetricsClient metricsClient;
        private boolean insertEnvTag;
        private Sock sock = Sock.SOCK_DGRAM;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.producer_name = "";
            this.client_dc = "";
            this.parseCacheTTLMs = 3600000L;
            this.parseCacheCapacity = 10000;
            this.useUnixDomainSocket = false;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter2) {
            this.filter = filter2;
            return this;
        }

        public Builder setUnixDomainSocket(boolean flag) {
            this.useUnixDomainSocket = flag;
            return this;
        }

        @Deprecated
        public Builder parse_cache_expired_ms(long ms) {
            return this.parseCacheTTLMs(ms);
        }

        public Builder parseCacheTTLMs(long ttlMs) {
            this.parseCacheTTLMs = ttlMs;
            return this;
        }

        public Builder parseCacheCapacity(int cacheCapacity) {
            this.parseCacheCapacity = cacheCapacity;
            return this;
        }

        public Builder metricsClient(MetricsClient metricsClient) {
            this.metricsClient = metricsClient;
            return this;
        }

        public Builder setVendorEnv(boolean insertEnvTag) {
            this.insertEnvTag = insertEnvTag;
            return this;
        }

        public Builder setSock(Sock sock) {
            this.sock = sock;
            return this;
        }

        public BytedanceMetricsReporter build() {
            if (this.metricsClient == null) {
                this.metricsClient = MetricsClient.get(this.prefix, this.useUnixDomainSocket || MetricsClient.ENABLE_SOCK_FROM_ENV, this.sock);
            }
            ParseCache parseCache = new ParseCache(this.parseCacheTTLMs, this.parseCacheCapacity);
            return new BytedanceMetricsReporter(this.registry, this.filter, this.rateUnit, this.durationUnit, parseCache, this.metricsClient, this.insertEnvTag);
        }
    }
}

