/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsReporter;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsV2;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.CallTracer;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.LockFreeSlidingWindowReservoir;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.NamedThreadFactory;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.expirable_metrics.ExpirableCounter;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.expirable_metrics.ExpirableGauge;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.expirable_metrics.ExpirableHistogram;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.expirable_metrics.ExpirableStore;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.expirable_metrics.ExpirableTimer;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.expirable_metrics.IExpirable;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Counter;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Gauge;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Histogram;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.MetricRegistry;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Timer;
import org.byted.security.zti.jwt.shaded.com.sun.istack.NotNull;
import org.byted.security.zti.jwt.shaded.com.sun.istack.Nullable;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

class BytedanceMetricsV2Impl
extends BytedanceMetricsV2 {
    private static final Logger LOG = LoggerFactory.getLogger(BytedanceMetricsV2Impl.class);
    private static final int DEFAULT_MEASUREMENT_WINDOW_SIZE = 65536;
    private static final String procIdTagKV;
    private BytedanceMetricsReporter reporter;
    private MetricRegistry registry;
    private long ttlInMs;
    private ConcurrentHashMap<String, ExpirableStore> storeMetrics;
    private ScheduledExecutorService executor;

    BytedanceMetricsV2Impl(BytedanceMetricsReporter reporter, MetricRegistry registry, long ttlInMs) {
        this.reporter = reporter;
        this.registry = registry;
        this.ttlInMs = ttlInMs <= 0L ? 43200000L : ttlInMs;
        this.storeMetrics = new ConcurrentHashMap(256);
        this.executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("expire", true));
        this.executor.scheduleAtFixedRate(this::tidyMetrics, this.ttlInMs, this.ttlInMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidyMetrics() {
        List expiredStores;
        List expiredMetrics = this.registry.getMetrics().entrySet().parallelStream().filter(metrics -> ((IExpirable)metrics.getValue()).isExpired()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!expiredMetrics.isEmpty()) {
            BytedanceMetricsV2Impl bytedanceMetricsV2Impl = this;
            synchronized (bytedanceMetricsV2Impl) {
                expiredMetrics.parallelStream().forEach(key -> {
                    this.remove((String)key);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Remove expired metrics {} ", key);
                    }
                });
            }
        }
        if (!(expiredStores = this.storeMetrics.entrySet().parallelStream().filter(metrics -> ((ExpirableStore)metrics.getValue()).isExpired()).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
            BytedanceMetricsV2Impl bytedanceMetricsV2Impl = this;
            synchronized (bytedanceMetricsV2Impl) {
                expiredStores.parallelStream().forEach(key -> {
                    this.storeMetrics.remove(key);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Remove expired store {} ", key);
                    }
                });
            }
        }
    }

    @Override
    public void emitGauge(@NotNull String metricName, String tagKVs, Function<Object, Long> compute) {
        assert (this.registry != null);
        if (!this.isValidTagKvs(tagKVs)) {
            throw new IllegalArgumentException("incorrect format for tagKVs: " + tagKVs);
        }
        String name = tagKVs == null ? metricName : metricName + tagKVs;
        this.getOrAddGauge(name, compute);
    }

    @Override
    public void emitCounterWithPID(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs) {
        this.emitCounter(metricName, value, this.getTagKVWithPID(tagKVs));
    }

    @Override
    public void emitCounter(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs) {
        assert (this.registry != null);
        if (!this.isValidTagKvs(tagKVs)) {
            throw new IllegalArgumentException("incorrect format for tagKVs: " + tagKVs);
        }
        String name = tagKVs == null ? metricName : metricName + tagKVs;
        this.getOrAddCounter(name).inc(value);
    }

    private ExpirableCounter getOrAddCounter(String name) {
        Counter counter = this.registry.counter(name, ExpirableCounter::new);
        assert (counter instanceof ExpirableCounter);
        return ((ExpirableCounter)counter).updateExpireTime(this.ttlInMs);
    }

    @Override
    public void emitTimerWithPID(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs) {
        this.emitTimer(metricName, value, this.getTagKVWithPID(tagKVs), TimeUnit.MILLISECONDS, 65536);
    }

    @Override
    public void emitTimerWithPID(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs, @Nullable TimeUnit timeUnit) {
        this.emitTimer(metricName, value, this.getTagKVWithPID(tagKVs), timeUnit, 65536);
    }

    @Override
    public void emitTimerWithPID(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs, @Nullable TimeUnit timeUnit, @NotNull int windowSize) {
        this.emitTimer(metricName, value, this.getTagKVWithPID(tagKVs), timeUnit, windowSize);
    }

    @Override
    public void emitTimer(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs) {
        this.emitTimer(metricName, value, tagKVs, TimeUnit.MILLISECONDS, 65536);
    }

    @Override
    public void emitTimer(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs, @Nullable TimeUnit timeUnit) {
        this.emitTimer(metricName, value, tagKVs, timeUnit, 65536);
    }

    @Override
    public void emitTimer(@NotNull String metricName, @NotNull long value, @Nullable String tagKVs, @Nullable TimeUnit timeUnit, @Nullable int windowSize) {
        assert (this.registry != null);
        if (!this.isValidTagKvs(tagKVs)) {
            throw new IllegalArgumentException("incorrect format for tagKVs: " + tagKVs);
        }
        String name = tagKVs == null ? metricName : metricName + tagKVs;
        TimeUnit mTimeUnit = timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit;
        int mWindowSize = windowSize <= 0 ? 65536 : windowSize;
        this.getOrAddTimer(name, mWindowSize).update(value, mTimeUnit);
    }

    private synchronized ExpirableTimer getOrAddTimer(String name, int windowSize) {
        Timer timer = this.registry.timer(name, () -> new ExpirableTimer(new LockFreeSlidingWindowReservoir(windowSize)));
        assert (timer instanceof ExpirableTimer);
        return ((ExpirableTimer)timer).updateExpireTime(this.ttlInMs);
    }

    private synchronized ExpirableTimer getOrAddTimer(String name) {
        Timer timer = this.registry.timer(name, () -> new ExpirableTimer(new LockFreeSlidingWindowReservoir(65536)));
        assert (timer instanceof ExpirableTimer);
        return ((ExpirableTimer)timer).updateExpireTime(this.ttlInMs);
    }

    private boolean isValidTagKvs(String tagKVs) {
        if (tagKVs == null || tagKVs.isEmpty()) {
            return true;
        }
        if (!tagKVs.startsWith("{") || !tagKVs.endsWith("}")) {
            return false;
        }
        String[] tags = tagKVs.substring(1, tagKVs.length() - 1).split("\\|");
        for (int i = 0; i < tags.length; ++i) {
            int idx = tags[i].trim().indexOf("=");
            if (idx > 0 && idx != tags[i].length() - 1) continue;
            return false;
        }
        return true;
    }

    private String getTagKVWithPID(String tagKVs) {
        if (tagKVs == null || tagKVs.isEmpty()) {
            return "{" + procIdTagKV + "}";
        }
        return tagKVs.substring(0, tagKVs.length() - 1) + "|" + procIdTagKV + "}";
    }

    @Override
    public void emitHistogram(@NotNull String name, @NotNull int value) {
        this.emitHistogram(name, value, 65536);
    }

    @Override
    public void emitHistogram(@NotNull String name, @NotNull long value) {
        this.emitHistogram(name, value, 65536);
    }

    @Override
    public void emitHistogram(@NotNull String name, @NotNull int value, @Nullable int windowSize) {
        this.getOrAddHistogram(name, windowSize).update(value);
    }

    @Override
    public void emitHistogram(@NotNull String name, @NotNull long value, @Nullable int windowSize) {
        this.getOrAddHistogram(name, windowSize).update(value);
    }

    private ExpirableHistogram getOrAddHistogram(String name, int windowSize) {
        assert (this.registry != null);
        int mWindowSize = windowSize <= 0 ? 65536 : windowSize;
        Histogram histogram = this.registry.histogram(name, () -> new ExpirableHistogram(new LockFreeSlidingWindowReservoir(mWindowSize)));
        assert (histogram instanceof ExpirableHistogram);
        return ((ExpirableHistogram)histogram).updateExpireTime(this.ttlInMs);
    }

    @Override
    public void getGaugeValue(@NotNull String name, @NotNull Function<Object, Long> compute) {
        assert (this.registry != null);
        this.getOrAddGauge(name, compute).getValue();
    }

    private ExpirableGauge getOrAddGauge(String name, Function<Object, Long> compute) {
        Gauge gauge = this.registry.gauge(name, () -> new ExpirableGauge(() -> (Long)compute.apply(name)));
        assert (gauge instanceof ExpirableGauge);
        return ((ExpirableGauge)gauge).updateExpireTime(this.ttlInMs);
    }

    @Override
    public void emitStore(String name, double value, long timestamp) throws IOException {
        this.getOrAddTsStore(name).emit(value, timestamp);
    }

    private ExpirableStore getOrAddTsStore(String name) throws IOException {
        assert (this.reporter != null);
        ExpirableStore expirableStore = this.storeMetrics.get(name);
        if (expirableStore != null) {
            return expirableStore.updateExpireTime(this.ttlInMs);
        }
        expirableStore = new ExpirableStore(this.reporter.createTsStore(name)).updateExpireTime(this.ttlInMs);
        this.storeMetrics.put(name, expirableStore);
        return expirableStore;
    }

    @Override
    public Supplier<CallTracer> callTracer(String name) {
        assert (this.registry != null);
        ExpirableCounter throughput = this.getOrAddCounter(name + ".throughput");
        ExpirableTimer latency = this.getOrAddTimer(name + ".latency");
        return () -> new CallTracer(throughput, latency);
    }

    @Override
    public Supplier<CallTracer> callTracer(String name, String suffix) {
        assert (this.registry != null);
        ExpirableCounter throughput = this.getOrAddCounter(name + ".throughput" + suffix);
        ExpirableTimer latency = this.getOrAddTimer(name + ".latency" + suffix);
        return () -> new CallTracer(throughput, latency);
    }

    @Override
    public boolean remove(String name) {
        assert (this.registry != null);
        return this.registry.remove(name);
    }

    public MetricRegistry getRegistry() {
        assert (this.registry != null);
        return this.registry;
    }

    public BytedanceMetricsReporter getReporter() {
        assert (this.reporter != null);
        return this.reporter;
    }

    public ConcurrentHashMap<String, ExpirableStore> getStoreMetrics() {
        assert (this.storeMetrics != null);
        return this.storeMetrics;
    }

    @Override
    public void close() {
        assert (this.reporter != null);
        this.reporter.close();
        this.executor.shutdownNow();
    }

    static {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String processName = runtime.getName();
        procIdTagKV = "pid=" + processName.split("@")[0];
    }
}

