/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Reservoir;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.Snapshot;
import org.byted.security.zti.jwt.shaded.com.codahale.metrics.UniformSnapshot;

public class LockFreeSlidingWindowReservoir
implements Reservoir {
    private final long[] measurements;
    private AtomicLong count;
    private long sliceStart;

    public LockFreeSlidingWindowReservoir(int size) {
        this.measurements = new long[size];
        this.count = new AtomicLong(0L);
        this.sliceStart = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return (int)Math.min(this.count.get(), (long)this.measurements.length);
    }

    @Override
    public void update(long value) {
        this.measurements[(int)(this.count.getAndIncrement() & Integer.MAX_VALUE) % this.measurements.length] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot getSnapshot() {
        long[] values = new long[this.size()];
        LockFreeSlidingWindowReservoir lockFreeSlidingWindowReservoir = this;
        synchronized (lockFreeSlidingWindowReservoir) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.measurements[i];
            }
        }
        long now = System.currentTimeMillis();
        if (now - this.sliceStart > 30000L) {
            this.sliceStart = now;
            this.count.set(0L);
        }
        return new UniformSnapshot(values);
    }
}

