/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.TagParser;

public class ParseCache {
    private final long ttlMs;
    private long currentMs;
    private final Map<String, Item> name2TapMap;

    public ParseCache(long ttlMs, int capacity) {
        this(ttlMs, capacity, System.currentTimeMillis());
    }

    public ParseCache(long ttlMs, int capacity, long currentMs) {
        this.ttlMs = ttlMs;
        this.currentMs = currentMs;
        this.name2TapMap = new LinkedHashMap<String, Item>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return true;
            }
        };
    }

    public TagParser.ParsedMetricAndTags get(String m4) {
        Item item = this.name2TapMap.get(m4);
        if (item == null) {
            return null;
        }
        item.setExpireAtMs(this.currentMs + this.ttlMs);
        return item.getTags();
    }

    public void put(String m4, TagParser.ParsedMetricAndTags parsed) {
        Item n_item = new Item(m4, parsed, this.currentMs + this.ttlMs);
        this.name2TapMap.put(m4, n_item);
    }

    public void flushExpired(long currentMs) {
        this.currentMs = currentMs;
        this.name2TapMap.values().removeIf(i -> ((Item)i).expireAtMs < currentMs);
    }

    public int size() {
        return this.name2TapMap.size();
    }

    static class Item {
        private long expireAtMs;
        private final String name;
        private final TagParser.ParsedMetricAndTags tags;

        public Item(String name, TagParser.ParsedMetricAndTags tags, long expireAtMs) {
            this.name = name;
            this.tags = tags;
            this.expireAtMs = expireAtMs;
        }

        public void setExpireAtMs(long expireAtMs) {
            this.expireAtMs = expireAtMs;
        }

        public boolean isExpired(long currentMs) {
            return currentMs > this.expireAtMs;
        }

        public String getName() {
            return this.name;
        }

        public TagParser.ParsedMetricAndTags getTags() {
            return this.tags;
        }
    }
}

