/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics;

import java.io.IOException;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.BytedanceMetricsReporter;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.TagParser;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public abstract class TsStore {
    private static final Logger LOG = LoggerFactory.getLogger(TsStore.class);

    public abstract void emit(double var1, long var3) throws IOException;

    public static TsStore withReport(TagParser.ParsedMetricAndTags metricAndTags, BytedanceMetricsReporter reporter) {
        return new TsStoreImpl(metricAndTags, reporter);
    }

    private static class TsStoreImpl
    extends TsStore {
        private final TagParser.ParsedMetricAndTags metricAndTags;
        private final BytedanceMetricsReporter reporter;

        public TsStoreImpl(TagParser.ParsedMetricAndTags metricAndTags, BytedanceMetricsReporter reporter) {
            this.metricAndTags = metricAndTags;
            this.reporter = reporter;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Create timestamp store with metric name:" + this.metricAndTags.metricName + " tag:" + this.metricAndTags.builtTags);
            }
        }

        @Override
        public void emit(double value, long timestamp) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Emit metric:" + this.metricAndTags.metricName + " with tags:" + this.metricAndTags.builtTags + " value:" + String.valueOf(value) + " timestamp:" + String.valueOf(timestamp));
            }
            this.reporter.emitStoreWithTsAndTag(this.metricAndTags.metricName, this.metricAndTags.builtTags, value, timestamp);
        }
    }
}

