/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.remote_writer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.remote_writer.PerformMetrics;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public class InputBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(InputBuffer.class);
    private static final AtomicInteger curSeq = new AtomicInteger(0);
    private static final char lineDelimiter = '\n';
    private static ThreadLocal<ByteBuffer> tlsBf = ThreadLocal.withInitial(() -> ByteBuffer.allocate(20));
    private static ThreadLocal<Deflater> tlsCompressor = ThreadLocal.withInitial(() -> new Deflater());
    private static ThreadLocal<ByteArrayOutputStream> tlsByteOuts = ThreadLocal.withInitial(() -> new ByteArrayOutputStream());
    private static ThreadLocal<byte[]> tlsByteTmp = ThreadLocal.withInitial(() -> new byte[1024]);
    private final int bufferCap;
    private int bytesUsed;
    private StringBuilder sb;
    private String msg;
    private byte[] compressedBytes;
    private byte[] header;
    private int compressSize = 0;
    private AtomicInteger tried;
    private final int seq;
    private boolean expired;
    private PerformMetrics performMetrics;

    public InputBuffer(int bufferCap, PerformMetrics performMetrics) {
        this.bufferCap = bufferCap;
        this.bytesUsed = 0;
        this.sb = new StringBuilder();
        this.compressedBytes = null;
        this.header = null;
        this.msg = null;
        this.tried = new AtomicInteger(0);
        this.seq = curSeq.incrementAndGet();
        this.expired = false;
        this.performMetrics = performMetrics;
    }

    public void Dispose() {
        this.compressedBytes = null;
        this.header = null;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setExpired() {
        this.expired = true;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public String getKafkaString() {
        if (this.sb != null) {
            this.msg = this.sb.toString();
            this.sb = null;
        }
        return this.msg;
    }

    public boolean pushData(String inputData) {
        if (this.bytesUsed + inputData.length() + 1 > this.bufferCap) {
            return false;
        }
        this.sb.append(inputData);
        this.sb.append('\n');
        this.bytesUsed += inputData.length() + 1;
        return true;
    }

    public boolean isCompressed() {
        return this.compressedBytes != null;
    }

    public byte[] getBytes() {
        return this.getKafkaString().getBytes();
    }

    public void currentStatus(String status) {
        LOG.info("IN Status {} the byteUsed {} and the byte is: {}", status, this.bytesUsed, this.getKafkaString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHeader() {
        InputBuffer inputBuffer = this;
        synchronized (inputBuffer) {
            if (this.header != null) {
                return this.header;
            }
            if (this.compressedBytes == null) {
                LOG.warn("Call compressBuf first!!!");
                return null;
            }
            tlsBf.get().order(ByteOrder.nativeOrder());
            tlsBf.get().clear();
            tlsBf.get().putShort(0, (short)1);
            tlsBf.get().putShort(2, (short)0);
            tlsBf.get().putInt(4, this.compressSize);
            tlsBf.get().putInt(8, this.getKafkaString().length());
            tlsBf.get().putLong(12, 0L);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Get header version {} compress codec {} content len {} decompress length {} cookie {}", (short)1, (short)0, this.compressSize, this.getKafkaString().length(), 0);
            }
            this.header = (byte[])tlsBf.get().array().clone();
        }
        return this.header;
    }

    public int incTried() {
        return this.tried.incrementAndGet();
    }

    public boolean isEmpty() {
        return this.getKafkaString().length() == 0;
    }

    public byte[] getCompressedBytes() {
        this.compressBuf();
        return this.compressedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compressBuf() {
        if (this.compressedBytes != null) {
            return;
        }
        if (this.isEmpty()) {
            LOG.warn("empty content");
            return;
        }
        Deflater compressor = tlsCompressor.get();
        compressor.reset();
        compressor.setInput(this.getKafkaString().getBytes(), 0, this.getKafkaString().length());
        compressor.finish();
        ByteArrayOutputStream bos = tlsByteOuts.get();
        bos.reset();
        this.compressSize = 0;
        byte[] outputByte = tlsByteTmp.get();
        try {
            while (!compressor.finished()) {
                int len = compressor.deflate(outputByte);
                bos.write(outputByte, 0, len);
                this.compressSize += len;
            }
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                LOG.warn("Compress byte failed");
                this.compressSize = 0;
                return;
            }
        }
        this.compressedBytes = bos.toByteArray();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bytes size before compress {} and after {} for seq {}", this.bytesUsed, this.compressSize, this.seq);
        }
    }
}

