/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.remote_writer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.remote_writer.MetricLooper;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.remote_writer.Protocol;

public class PerformMetrics {
    AtomicLong succeed_cnt;
    AtomicLong retried_failed_cnt;
    AtomicLong unretriable_failed_cnt;
    AtomicLong invalid_record_cnt;
    AtomicLong input_records;
    AtomicLong input_packets;
    AtomicLong finished_packets;
    AtomicLong total_size;
    AtomicLong total_compressed_size;
    AtomicLong running;
    AtomicLong parse_cache_cnt;
    AtomicLong connect_created_cnt;
    AtomicLong connect_closed_cnt;
    AtomicLong ready_connection_cnt;
    AtomicLong connecting_cnt;
    AtomicLong disconnecting_cnt;
    private MetricLooper metricLooper;
    private ConcurrentHashMap<Protocol.ProcessStatusCode, AtomicLong> processFailedMap;
    private ConcurrentHashMap<Protocol.ResponseStatusCode, AtomicLong> producerFailedMap;

    AtomicLong getProcessCounter(Protocol.ProcessStatusCode code) {
        if (this.processFailedMap.contains((Object)code)) {
            return this.processFailedMap.get((Object)code);
        }
        this.processFailedMap.putIfAbsent(code, this.metricLooper.defineCounter("process_failed", "type", code.name()));
        return this.processFailedMap.get((Object)code);
    }

    AtomicLong getResponseStatusCounter(Protocol.ResponseStatusCode code) {
        if (this.producerFailedMap.contains((Object)code)) {
            return this.producerFailedMap.get((Object)code);
        }
        this.producerFailedMap.putIfAbsent(code, this.metricLooper.defineCounter("producer_failed", "type", code.name()));
        return this.producerFailedMap.get((Object)code);
    }

    PerformMetrics(MetricLooper metricLooper) {
        this.metricLooper = metricLooper;
        this.succeed_cnt = metricLooper.defineCounter("succeed", new String[0]);
        this.retried_failed_cnt = metricLooper.defineCounter("failed", "type", "retriable");
        this.unretriable_failed_cnt = metricLooper.defineCounter("failed", "type", "unretriable");
        this.invalid_record_cnt = metricLooper.defineCounter("process_failed", "type", "invalid_record");
        this.input_records = metricLooper.defineCounter("input_records", new String[0]);
        this.input_packets = metricLooper.defineCounter("input_packets", new String[0]);
        this.finished_packets = metricLooper.defineCounter("finished_packets", new String[0]);
        this.total_size = metricLooper.defineCounter("total_size", new String[0]);
        this.total_compressed_size = metricLooper.defineCounter("total_compressed_size", new String[0]);
        this.running = metricLooper.defineCounter("current_running", new String[0]);
        this.parse_cache_cnt = metricLooper.defineCounter("parse_cached_size", new String[0]);
        this.connect_created_cnt = metricLooper.defineCounter("connection_created", new String[0]);
        this.connect_closed_cnt = metricLooper.defineCounter("connection_closed", new String[0]);
        this.ready_connection_cnt = metricLooper.defineCounter("connect_running_count", "type", "ready");
        this.connecting_cnt = metricLooper.defineCounter("connect_running_count", "type", "connecting");
        this.disconnecting_cnt = metricLooper.defineCounter("connect_running_count", "type", "disconnecting");
        this.producerFailedMap = new ConcurrentHashMap();
        this.processFailedMap = new ConcurrentHashMap();
    }
}

