/*
 * Decompiled with CFR 0.152.
 */
package org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.byted.security.zti.jwt.shaded.com.bytedance.apm.shade.jnr.constants.platform.Sock;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.MetricUtils;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.SimpleByteTSDMetricsImpl;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender.Sender;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.simple.sender.UdpSender;
import org.byted.security.zti.jwt.shaded.com.bytedance.metrics.udpclient.MetricsClient;
import org.byted.security.zti.jwt.shaded.org.slf4j.Logger;
import org.byted.security.zti.jwt.shaded.org.slf4j.LoggerFactory;

public abstract class SimpleByteTSDMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleByteTSDMetrics.class);

    public static Builder builder() {
        return new Builder();
    }

    public abstract void emitStore(String var1, double var2, String var4);

    public abstract void emitTsStore(String var1, double var2, String var4, long var5);

    public abstract void emitTimer(String var1, double var2, String var4);

    public abstract void emitCounter(String var1, double var2, String var4);

    public abstract void emitRateCounter(String var1, double var2, String var4);

    public abstract void emitMeter(String var1, double var2, String var4);

    static boolean validateTags(String tags) {
        String[] kvs;
        if (tags == null || tags.isEmpty()) {
            return true;
        }
        if (!tags.startsWith("{") || !tags.endsWith("}")) {
            LOG.error("tags must be surrounded by braces");
            return false;
        }
        String inner = tags.substring(1, tags.length() - 1);
        if (inner.isEmpty()) {
            return true;
        }
        for (String kv : kvs = inner.split("[|,]")) {
            int idx = kv.trim().indexOf("=");
            if (idx > 0 && idx != kv.length() - 1) continue;
            LOG.error("invalid tag, key or value missing, {}", (Object)kv);
            return false;
        }
        return true;
    }

    static boolean validateTagKv(String kv, int from2, int to) {
        boolean valid;
        int l;
        int r = to;
        for (l = from2; l < r && Character.isWhitespace(kv.charAt(l)); ++l) {
        }
        while (l < r && Character.isWhitespace(kv.charAt(r - 1))) {
            --r;
        }
        int idx = SimpleByteTSDMetrics.indexOf(kv, '=', l, r);
        boolean bl = valid = idx > l && idx < r - 1;
        if (!valid) {
            LOG.error("invalid tag, key or value missing, {}", (Object)kv);
        }
        return valid;
    }

    static int indexOf(String s2, char ch, int from2, int to) {
        for (int i = from2; i < to; ++i) {
            if (s2.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    static boolean validateTagsV2(String tags) {
        if (tags == null || tags.isEmpty()) {
            return true;
        }
        if (!tags.startsWith("{") || !tags.endsWith("}")) {
            LOG.error("tags must be surrounded by braces");
            return false;
        }
        int start = 1;
        for (int i = 1; i < tags.length() - 1; ++i) {
            char ch = tags.charAt(i);
            if (ch != '|' && ch != ',') continue;
            if (!SimpleByteTSDMetrics.validateTagKv(tags, start, i)) {
                return false;
            }
            start = i;
        }
        return start >= tags.length() - 1 || SimpleByteTSDMetrics.validateTagKv(tags, start, tags.length() - 1);
    }

    public static class Builder {
        private String prefix;
        private int maxPendingSize = 1000;
        private int emitIntervalMs = 200;
        private boolean blockOnBufferFull = false;
        private boolean useUnixDomainSocket;
        private Sender sender;
        private Sock sock = Sock.SOCK_DGRAM;
        private Map<String, String> globalTags = new HashMap<String, String>();
        private static ConcurrentMap<String, SimpleByteTSDMetrics> registered = new ConcurrentHashMap<String, SimpleByteTSDMetrics>();

        public Builder prefix(String prefix) {
            Objects.requireNonNull(prefix);
            this.prefix = prefix;
            return this;
        }

        public Builder setVendorEnv() {
            this.globalTags = MetricUtils.getVendorEnvTags();
            return this;
        }

        public Builder maxPendingSize(int maxPendingSize) {
            if (maxPendingSize < 100) {
                maxPendingSize = 100;
                LOG.warn("maxPendingSize {} too small, not recommended", (Object)maxPendingSize);
            }
            this.maxPendingSize = maxPendingSize;
            return this;
        }

        public Builder emitIntervalMs(int emitIntervalMs) {
            if (emitIntervalMs < 100) {
                emitIntervalMs = 100;
                LOG.warn("emitIntervalMs {} too small, not recommended", (Object)this.maxPendingSize);
            }
            this.emitIntervalMs = emitIntervalMs;
            return this;
        }

        public Builder setUseUnixDomainSocket(boolean useUnixDomainSocket) {
            this.setUseUnixDomainSocket(useUnixDomainSocket, Sock.SOCK_DGRAM);
            return this;
        }

        public Builder setUseUnixDomainSocket(boolean useUnixDomainSocket, Sock sock) {
            Objects.requireNonNull(sock);
            this.useUnixDomainSocket = useUnixDomainSocket;
            this.sock = sock;
            return this;
        }

        public Builder setBlockOnBufferFull(boolean blockOnBufferFull) {
            this.blockOnBufferFull = blockOnBufferFull;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SimpleByteTSDMetrics build() {
            if (this.prefix == null || this.prefix.isEmpty()) {
                throw new IllegalArgumentException("non empty prefix is required");
            }
            Class<SimpleByteTSDMetrics> clazz = SimpleByteTSDMetrics.class;
            synchronized (SimpleByteTSDMetrics.class) {
                if (registered.containsKey(this.prefix)) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (SimpleByteTSDMetrics)registered.get(this.prefix);
                }
                Sender sender = this.sender == null ? new UdpSender(this.useUnixDomainSocket || MetricsClient.ENABLE_SOCK_FROM_ENV, this.sock) : this.sender;
                SimpleByteTSDMetricsImpl client = new SimpleByteTSDMetricsImpl(sender, this.maxPendingSize, this.prefix.endsWith(".") ? this.prefix : this.prefix + ".", this.blockOnBufferFull, this.emitIntervalMs, this.globalTags);
                registered.put(this.prefix, client);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return client;
            }
        }
    }
}

